/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.common.data;

import com.aizistral.enigmaticlegacy.registries.EnigmaticBlocks;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.sammy.malum.data.recipe.builder.SpiritInfusionRecipeBuilder;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.dreamtinker.dreamtinker.Dreamtinker;
import org.dreamtinker.dreamtinker.common.DreamtinkerCommon;
import org.dreamtinker.dreamtinker.common.DreamtinkerTagkeys;
import org.dreamtinker.dreamtinker.fluids.DreamtinkerFluids;
import org.dreamtinker.dreamtinker.tools.DreamtinkerModifiers;
import org.dreamtinker.dreamtinker.tools.DreamtinkerToolParts;
import org.dreamtinker.dreamtinker.tools.DreamtinkerTools;
import org.dreamtinker.dreamtinker.tools.data.DreamtinkerMaterialIds;
import org.dreamtinker.dreamtinker.utils.CastLookup;
import org.dreamtinker.dreamtinker.utils.DThelper;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.recipe.data.IRecipeHelper;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IToolRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.ItemPartRecipeBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipeBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.recycle.PartBuilderToolRecycleBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipeBuilder;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class DreamtinkerRecipeProvider
extends RecipeProvider
implements IMaterialRecipeHelper,
IToolRecipeHelper,
IConditionBuilder,
IRecipeHelper {
    String materials_folder = "tools/materials/";
    String partFolder = "tools/parts/";
    String castFolder = "smeltery/casts/";

    public DreamtinkerRecipeProvider(PackOutput p_248933_) {
        super(p_248933_);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> consumer) {
        this.addCraftingRecipes(consumer);
        this.addMeltingRecipes(consumer);
        this.addCastingRecipes(consumer);
        this.addAlloyRecipes(consumer);
        this.addMaterialRecipes(consumer);
        this.addCompactMaterialRecipes(consumer);
        this.addPartRecipes(consumer);
        this.addToolBuildingRecipes(consumer);
        this.addModifierRecipes(consumer);
        this.addEntityMeltingRecipes(consumer);
    }

    private void addToolBuildingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/building/";
        String armorFolder = "tools/armor/";
        ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)((IModifiable)DreamtinkerTools.tntarrow.get())).outputSize(4).save(consumer, this.prefix((IdAwareObject)DreamtinkerTools.tntarrow, folder));
        this.toolBuilding(consumer, (Supplier)DreamtinkerTools.mashou, folder);
        this.toolBuilding(consumer, (Supplier)DreamtinkerTools.narcissus_wing, folder);
        String recycle_folder = "tools/recycling/";
        PartBuilderToolRecycleBuilder.tools((SizedIngredient)SizedIngredient.fromItems((int)4, (ItemLike[])new ItemLike[]{DreamtinkerTools.tntarrow.get()})).save(consumer, this.location(recycle_folder + "tntarrow"));
        DreamtinkerTools.underPlate.forEach(item -> ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)item).layoutSlot(Dreamtinker.getLocation("under_plate")).addExtraRequirement(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerModifiers.silkyCloth})).addExtraRequirement(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerModifiers.silkyCloth})).save(consumer, this.prefix(this.id((ItemLike)item), armorFolder)));
    }

    private void addAlloyRecipes(Consumer<FinishedRecipe> consumer) {
        AlloyRecipeBuilder.alloy(DreamtinkerFluids.molten_albedo_stibium, (int)100).addCatalyst((FluidIngredient)FluidIngredient.of(DreamtinkerTagkeys.Fluids.molten_lupi_antimony, (int)90)).addInput(TinkerTags.Fluids.METAL_TOOLTIPS, 90).save(consumer, this.location("currus_triumphalis_antimonii/lupi_to_albedo"));
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromStack((FluidStack)new FluidStack(DreamtinkerFluids.liquid_smoky_antimony.get(), 180)), (int)6000).addInput(DreamtinkerTagkeys.Fluids.molten_ascending_antimony, 90).addInput(TinkerFluids.liquidSoul.getTag(), 1000).save(consumer, this.location("currus_triumphalis_antimonii/ascending_to_smoky"));
        AlloyRecipeBuilder.alloy(DreamtinkerFluids.molten_evil, (int)180).addInput(DreamtinkerTagkeys.Fluids.molten_nefariousness, 400).addInput(DreamtinkerTagkeys.Fluids.liquid_trist, 40).addInput(TinkerFluids.moltenNetherite.getTag(), 90).save(consumer, this.location("evil_ingot"));
        AlloyRecipeBuilder.alloy((FluidOutput)FluidOutput.fromStack((FluidStack)new FluidStack(DreamtinkerFluids.liquid_pure_soul.get(), 100)), (int)1600).addInput(DreamtinkerTagkeys.Fluids.liquid_trist, 10).addInput(TinkerFluids.liquidSoul.getTag(), 10000).save(consumer, this.location("liquid_pure_soul"));
        AlloyRecipeBuilder.alloy(DreamtinkerFluids.molten_soul_aether, (int)90).addInput(DreamtinkerTagkeys.Fluids.molten_nefariousness, 100).addInput(DreamtinkerTagkeys.Fluids.liquid_pure_soul, 100).addInput(DreamtinkerTagkeys.Fluids.unstable_liquid_aether, 90).addInput(DreamtinkerTagkeys.Fluids.molten_void, 250).addInput(DreamtinkerTagkeys.Fluids.molten_echo_shard, 100).save(consumer, this.location("molten_soul_aether"));
        AlloyRecipeBuilder.alloy(DreamtinkerFluids.reversed_shadow, (int)250).addInput(DreamtinkerTagkeys.Fluids.molten_void, 500).addInput(TinkerFluids.moltenEnder.getTag(), 500).save(consumer, this.location("reversed_shadow"));
        AlloyRecipeBuilder.alloy(DreamtinkerFluids.molten_echo_alloy, (int)100).addInput(DreamtinkerTagkeys.Fluids.molten_echo_shard, 100).addInput(TinkerFluids.moltenEnder.getTag(), 500).save(consumer, this.location("molten_echo_alloy"));
    }

    private void addCastingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/casting/";
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.regulus.get())).setFluid(DreamtinkerFluids.liquid_smoky_antimony.getLocalTag(), 90).setCoolingTime(100).setCast(Tags.Items.DUSTS_REDSTONE, true).save(consumer, this.location(folder + "currus_triumphalis_antimonii/smoky_to_star"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.metallivorous_stibium_lupus.get())).setFluid(DreamtinkerFluids.molten_albedo_stibium.getLocalTag(), 100).setCoolingTime(100).setCast(Tags.Items.STORAGE_BLOCKS_GOLD, true).save(consumer, this.location(folder + "currus_triumphalis_antimonii/albedo_to_lupus_block"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.metallivorous_stibium_lupus.get())).setFluid(DreamtinkerFluids.molten_albedo_stibium.getLocalTag(), 100).setCoolingTime(100).setCast(DreamtinkerRecipeProvider.forgeItemTag("dusts/gold"), true).save(this.withCondition(consumer, new ICondition[]{this.tagCondition("dusts/gold")}), this.location(folder + "currus_triumphalis_antimonii/albedo_to_lupus_dust"));
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)Blocks.f_50723_).setFluidAndTime(DreamtinkerFluids.molten_crying_obsidian, 1000).save(consumer, this.location(folder + "crying_obsidian/block"));
        ItemCastingRecipeBuilder.tableRecipe(DreamtinkerCommon.crying_obsidian_plane).setFluidAndTime(DreamtinkerFluids.molten_crying_obsidian, 250).save(consumer, this.location(folder + "crying_obsidian/pane"));
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)EnigmaticBlocks.ETHERIUM_BLOCK).setFluidAndTime(DreamtinkerFluids.unstable_liquid_aether, 810).save(consumer, this.location(folder + "etherium/block"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)EnigmaticItems.VOID_PEARL).setCoolingTime(2000, 10).setCast((ItemLike)DreamtinkerCommon.void_pearl.get(), true).setFluid(FluidIngredient.of((FluidStack)new FluidStack(DreamtinkerFluids.molten_ascending_antimony.get(), 810))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)EnigmaticItems.VOID_PEARL))}), this.location(folder + "void_pearl/ascending"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)EnigmaticItems.OCEAN_STONE).setCoolingTime(2000, 10).setCast((ItemLike)Items.f_42716_, true).setFluid(FluidIngredient.of((FluidStack)new FluidStack(DreamtinkerFluids.molten_ascending_antimony.get(), 810))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)EnigmaticItems.OCEAN_STONE))}), this.location(folder + "ocean_stone/ascending"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.twist_obsidian_pane.get())).setFluidAndTime(DreamtinkerFluids.liquid_trist, 30).setCast(DreamtinkerCommon.crying_obsidian_plane.get(), true).save(consumer, this.location(folder + folder + "twist_obsidian/pane"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.unborn_egg.get())).setCast(Tags.Items.EGGS, true).setFluid((FluidIngredient)FluidIngredient.of(DreamtinkerTagkeys.Fluids.molten_nigrescence_antimony, (int)300)).setCoolingTime(10).save(consumer, this.location(folder + "unborn_egg"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.unborn_turtle_egg.get())).setCast((ItemLike)Items.f_42279_, true).setFluid((FluidIngredient)FluidIngredient.of(DreamtinkerTagkeys.Fluids.molten_nigrescence_antimony, (int)300)).setCoolingTime(10).save(consumer, this.location(folder + "unborn_turtle_egg"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.unborn_sniffer_egg.get())).setCast((ItemLike)Items.f_276468_, true).setFluid((FluidIngredient)FluidIngredient.of(DreamtinkerTagkeys.Fluids.molten_nigrescence_antimony, (int)300)).setCoolingTime(10).save(consumer, this.location(folder + "unborn_sniffer_egg"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.unborn_dragon_egg.get())).setCast((ItemLike)Items.f_42104_, true).setFluid((FluidIngredient)FluidIngredient.of(DreamtinkerTagkeys.Fluids.molten_albedo_stibium, (int)300)).setCoolingTime(10).save(consumer, this.location(folder + "unborn_dragon_egg"));
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)((ItemLike)BlockRegistry.BLOCK_OF_SOUL_STAINED_STEEL.get())).setFluidAndTime(DreamtinkerFluids.molten_soul_stained_steel, 810).save(consumer, this.location(folder + "soul_stained_steel/block"));
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)((ItemLike)BlockRegistry.BLOCK_OF_MALIGNANT_PEWTER.get())).setFluidAndTime(DreamtinkerFluids.molten_malignant_pewter, 810).save(consumer, this.location(folder + "malignant_pewter/block"));
        PotionCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)ItemRegistry.CONCENTRATED_GLUTTONY.get())).setBottle((ItemLike)Items.f_42590_).setFluid(FluidIngredient.of((FluidStack)new FluidStack(DreamtinkerFluids.liquid_concentrated_gluttony.get(), 250))).save(consumer, this.location(folder + "filling/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.CONCENTRATED_GLUTTONY.get()))).m_135815_()));
    }

    private void addMeltingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/melting/";
        MeltingFuelBuilder.fuel((FluidIngredient)DreamtinkerFluids.molten_lupi_antimony.ingredient(90), (int)776, (int)7776).save(consumer, this.location(folder + "fuel/molten_lupi_antimony"));
        MeltingFuelBuilder.fuel((FluidIngredient)DreamtinkerFluids.reversed_shadow.ingredient(250), (int)17, (int)2200).save(consumer, this.location(folder + "fuel/reversed_shadow"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42754_}), DreamtinkerFluids.molten_crying_obsidian, (int)1000, (float)2.0f).save(consumer, this.location(folder + "crying_obsidian/block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerCommon.crying_obsidian_plane}), DreamtinkerFluids.molten_crying_obsidian, (int)250, (float)1.5f).save(consumer, this.location(folder + "crying_obsidian/pane"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220224_}), DreamtinkerFluids.molten_echo_shard, (int)100, (float)2.0f).save(consumer, this.location(folder + "echo_shard/gem"));
        this.cast(DreamtinkerFluids.molten_echo_shard.get(), (ItemLike)Items.f_220224_, 100, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.echo_alloy.get()}), DreamtinkerFluids.molten_echo_alloy, (int)100, (float)2.0f).save(consumer, this.location(folder + "echo_alloy/gem"));
        this.cast(DreamtinkerFluids.molten_echo_alloy.get(), (ItemLike)DreamtinkerCommon.echo_alloy.get(), 100, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.metallivorous_stibium_lupus.get()}), DreamtinkerFluids.molten_lupi_antimony, (int)90, (float)2.0f).addByproduct(DreamtinkerFluids.molten_ascending_antimony.result(10)).save(consumer, this.location(folder + "metallivorous_stibium_lupus/foundry"));
        this.cast(DreamtinkerFluids.molten_lupi_antimony.get(), (ItemLike)DreamtinkerCommon.metallivorous_stibium_lupus.get(), 90, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.nigrescence_antimony.get()}), DreamtinkerFluids.molten_nigrescence_antimony, (int)100, (float)2.0f).addByproduct(DreamtinkerFluids.molten_albedo_stibium.result(30)).save(consumer, this.location(folder + "nigrescence_antimony/foundry"));
        this.cast(DreamtinkerFluids.molten_nigrescence_antimony.get(), (ItemLike)DreamtinkerCommon.nigrescence_antimony.get(), 100, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_INGOT}), DreamtinkerFluids.unstable_liquid_aether, (int)90, (float)4.0f).save(consumer, this.location(folder + "etherium/ingot"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_NUGGET}), DreamtinkerFluids.unstable_liquid_aether, (int)10, (float)4.0f).save(consumer, this.location(folder + "etherium/nugget"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticBlocks.ETHERIUM_BLOCK}), DreamtinkerFluids.unstable_liquid_aether, (int)810, (float)4.0f).save(consumer, this.location(folder + "etherium/block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_ORE}), DreamtinkerFluids.unstable_liquid_aether, (int)90, (float)4.0f).addByproduct(DreamtinkerFluids.reversed_shadow.result(30)).setOre(IMeltingContainer.OreRateType.METAL, new IMeltingContainer.OreRateType[0]).save(consumer, this.location(folder + "etherium/ore"));
        int[] etherium_damage = new int[]{10, 50};
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_AXE}), DreamtinkerFluids.unstable_liquid_aether, (int)360, (float)4.0f).setDamagable(etherium_damage).addByproduct(TinkerFluids.moltenEnder.result(500)).save(consumer, this.location(folder + "etherium/axe"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_SWORD}), DreamtinkerFluids.unstable_liquid_aether, (int)180, (float)4.0f).setDamagable(new int[]{10, 50, 25}).addByproduct(TinkerFluids.moltenEnder.result(250)).addByproduct(TinkerFluids.moltenDiamond.result(200)).save(consumer, this.location(folder + "etherium/sword"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_SCYTHE}), DreamtinkerFluids.unstable_liquid_aether, (int)180, (float)4.0f).setDamagable(etherium_damage).addByproduct(TinkerFluids.moltenEnder.result(500)).save(consumer, this.location(folder + "etherium/scythe"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_PICKAXE}), DreamtinkerFluids.unstable_liquid_aether, (int)270, (float)4.0f).setDamagable(etherium_damage).addByproduct(TinkerFluids.moltenEnder.result(500)).save(consumer, this.location(folder + "etherium/pickaxe"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_SHOVEL}), DreamtinkerFluids.unstable_liquid_aether, (int)90, (float)4.0f).setDamagable(etherium_damage).addByproduct(TinkerFluids.moltenEnder.result(500)).save(consumer, this.location(folder + "etherium/shovel"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_HELMET}), DreamtinkerFluids.unstable_liquid_aether, (int)450, (float)4.0f).setDamagable(new int[]{10}).save(consumer, this.location(folder + "etherium/helmet"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_CHESTPLATE}), DreamtinkerFluids.unstable_liquid_aether, (int)720, (float)4.0f).setDamagable(new int[]{10}).save(consumer, this.location(folder + "etherium/chestplate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_LEGGINGS}), DreamtinkerFluids.unstable_liquid_aether, (int)630, (float)4.0f).setDamagable(new int[]{10}).save(consumer, this.location(folder + "etherium/leggings"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_BOOTS}), DreamtinkerFluids.unstable_liquid_aether, (int)360, (float)4.0f).setDamagable(new int[]{10}).save(consumer, this.location(folder + "etherium/boots"));
        this.cast(DreamtinkerFluids.unstable_liquid_aether.get(), (ItemLike)EnigmaticItems.ETHERIUM_INGOT, 90, consumer);
        this.cast(DreamtinkerFluids.unstable_liquid_aether.get(), (ItemLike)EnigmaticItems.ETHERIUM_NUGGET, 10, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.EVIL_INGOT}), DreamtinkerFluids.molten_evil, (int)90, (float)4.0f).save(consumer, this.location(folder + "evil/ingot"));
        this.cast(DreamtinkerFluids.molten_evil.get(), (ItemLike)EnigmaticItems.EVIL_INGOT, 90, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.EVIL_ESSENCE}), DreamtinkerFluids.molten_nefariousness, (int)100, (float)4.0f).save(consumer, this.location(folder + "evil/gem"));
        this.cast(DreamtinkerFluids.molten_nefariousness.get(), (ItemLike)EnigmaticItems.EVIL_ESSENCE, 100, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42586_}), DreamtinkerFluids.liquid_trist, (int)10, (float)4.0f).save(consumer, this.location(folder + "ghast_tear/nugget"));
        this.cast(DreamtinkerFluids.liquid_trist.get(), (ItemLike)Items.f_42586_, 10, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.SOUL_CRYSTAL}), DreamtinkerFluids.liquid_pure_soul, (int)100, (float)4.0f).save(consumer, this.location(folder + "soul_crystal/gem"));
        this.cast(DreamtinkerFluids.liquid_pure_soul.get(), (ItemLike)EnigmaticItems.SOUL_CRYSTAL, 100, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.void_pearl.get()}), DreamtinkerFluids.molten_void, (int)250, (float)4.0f).save(consumer, this.location(folder + "void_pearl/slime"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)((ItemLike)DreamtinkerCommon.void_pearl.get())).setCoolingTime(IMeltingRecipe.getTemperature(DreamtinkerFluids.molten_void), 250).setFluid(FluidIngredient.of((FluidStack)new FluidStack(DreamtinkerFluids.molten_void.get(), 250))).save(consumer, this.location("smeltery/casting/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)DreamtinkerCommon.void_pearl.get()))).m_135815_() + "/slime"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.soul_etherium.get()}), DreamtinkerFluids.molten_soul_aether, (int)90, (float)2.0f).save(consumer, this.location(folder + "soul_etherium/foundry"));
        this.cast(DreamtinkerFluids.molten_soul_aether.get(), (ItemLike)DreamtinkerCommon.soul_etherium.get(), 90, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.twist_obsidian_pane.get()}), DreamtinkerFluids.liquid_trist, (int)30).addByproduct(DreamtinkerFluids.molten_crying_obsidian.result(250)).save(consumer, this.location(folder + "twist/reinforcement"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get()}), DreamtinkerFluids.molten_soul_stained_steel, (int)90, (float)2.0f).save(consumer, this.location(folder + "soul_stained_steel/ingot"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SOUL_STAINED_STEEL_NUGGET.get()}), DreamtinkerFluids.molten_soul_stained_steel, (int)10, (float)2.0f).save(consumer, this.location(folder + "soul_stained_steel/nugget"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.BLOCK_OF_SOUL_STAINED_STEEL.get()}), DreamtinkerFluids.molten_soul_stained_steel, (int)810, (float)2.0f).save(consumer, this.location(folder + "soul_stained_steel/block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SOUL_STAINED_STEEL_PLATING.get()}), DreamtinkerFluids.molten_soul_stained_steel, (int)65, (float)2.0f).save(consumer, this.location(folder + "soul_stained_steel/plating"));
        this.cast(DreamtinkerFluids.molten_soul_stained_steel.get(), (ItemLike)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get(), 90, consumer);
        this.cast(DreamtinkerFluids.molten_soul_stained_steel.get(), (ItemLike)ItemRegistry.SOUL_STAINED_STEEL_NUGGET.get(), 10, consumer);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MALIGNANT_PEWTER_INGOT.get()}), DreamtinkerFluids.molten_malignant_pewter, (int)90, (float)2.0f).save(consumer, this.location(folder + "malignant_pewter/ingot"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MALIGNANT_PEWTER_NUGGET.get()}), DreamtinkerFluids.molten_malignant_pewter, (int)10, (float)2.0f).save(consumer, this.location(folder + "malignant_pewter/nugget"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.BLOCK_OF_MALIGNANT_PEWTER.get()}), DreamtinkerFluids.molten_malignant_pewter, (int)810, (float)2.0f).save(consumer, this.location(folder + "malignant_pewter/block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MALIGNANT_PEWTER_PLATING.get()}), DreamtinkerFluids.molten_malignant_pewter, (int)65, (float)2.0f).save(consumer, this.location(folder + "malignant_pewter/plating"));
        this.cast(DreamtinkerFluids.molten_malignant_pewter.get(), (ItemLike)ItemRegistry.MALIGNANT_PEWTER_INGOT.get(), 90, consumer);
        this.cast(DreamtinkerFluids.molten_malignant_pewter.get(), (ItemLike)ItemRegistry.MALIGNANT_PEWTER_NUGGET.get(), 10, consumer);
        this.cast(DreamtinkerFluids.molten_malignant_gluttony.get(), (ItemLike)DreamtinkerCommon.malignant_gluttony.get(), 90, consumer);
    }

    private void addMaterialRecipes(Consumer<FinishedRecipe> consumer) {
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.crying_obsidian, (FluidObject)DreamtinkerFluids.molten_crying_obsidian, 1000, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.crying_obsidian, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42754_}), 1, 1, this.materials_folder + "crying_obsidian");
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.echo_alloy, (FluidObject)DreamtinkerFluids.molten_echo_alloy, 100, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.echo_alloy, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.echo_alloy.get()}), 1, 1, this.materials_folder + "echo_alloy");
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.metallivorous_stibium_lupus, (FluidObject)DreamtinkerFluids.molten_lupi_antimony, 90, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.metallivorous_stibium_lupus, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.metallivorous_stibium_lupus.get()}), 1, 1, this.materials_folder + "metallivorous_stibium_lupus");
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.nigrescence_antimony, (FluidObject)DreamtinkerFluids.molten_nigrescence_antimony, 100, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.nigrescence_antimony, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.nigrescence_antimony.get()}), 1, 1, this.materials_folder + "nigrescence_antimony");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.string, (MaterialVariantId)DreamtinkerMaterialIds.nigrescence_antimony, (FluidObject)DreamtinkerFluids.molten_nigrescence_antimony, 100, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.star_regulus, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.regulus.get()}), 1, 1, this.materials_folder + "star_regulus");
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.valentinite, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.valentinite.get()}), 1, 1, this.materials_folder + "valentinite");
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.larimar, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.larimar.get()}), 1, 1, this.materials_folder + "larimar");
    }

    private void addCompactMaterialRecipes(Consumer<FinishedRecipe> consumer) {
        this.addELMaterialRecipes(consumer);
        this.addMalumMaterialRecipes(consumer);
    }

    private void addELMaterialRecipes(Consumer<FinishedRecipe> consumer) {
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.etherium, (FluidObject)DreamtinkerFluids.unstable_liquid_aether, 90, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.etherium, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.ETHERIUM_INGOT}), 1, 1, this.materials_folder + "etherium");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.string, (MaterialVariantId)DreamtinkerMaterialIds.etherium, (FluidObject)DreamtinkerFluids.unstable_liquid_aether, 90, this.materials_folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.nefarious, (FluidObject)DreamtinkerFluids.molten_evil, 90, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.nefarious, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EnigmaticItems.EVIL_INGOT}), 1, 1, this.materials_folder + "nefarious");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.string, (MaterialVariantId)DreamtinkerMaterialIds.nefarious, (FluidObject)DreamtinkerFluids.molten_evil, 90, this.materials_folder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.soul_etherium, (FluidObject)DreamtinkerFluids.molten_soul_aether, 90, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.soul_etherium, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.soul_etherium.get()}), 1, 1, this.materials_folder + "soul_etherium");
        this.materialComposite(consumer, (MaterialVariantId)MaterialIds.string, (MaterialVariantId)DreamtinkerMaterialIds.soul_etherium, (FluidObject)DreamtinkerFluids.molten_soul_aether, 90, this.materials_folder);
    }

    private void addMalumMaterialRecipes(Consumer<FinishedRecipe> consumer) {
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.spirit_fabric, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SPIRIT_FABRIC.get()}), 1, 3, this.materials_folder + "spirit_fabric");
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.hallowed_gold, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.HALLOWED_GOLD_INGOT.get()}), 1, 1, this.materials_folder + "hallowed_gold");
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.mnemonic_fragment, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MNEMONIC_FRAGMENT.get()}), 1, 4, this.materials_folder + "mnemonic_fragment");
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.soul_stained_steel, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SOUL_STAINED_STEEL_PLATING.get()}), 1, 2, this.materials_folder + "soul_stained_steel");
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.soul_stained_steel, (FluidObject)DreamtinkerFluids.molten_soul_stained_steel, 130, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.malignant_pewter, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MALIGNANT_PEWTER_PLATING.get()}), 1, 2, this.materials_folder + "malignant_pewter");
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.malignant_pewter, (FluidObject)DreamtinkerFluids.molten_malignant_pewter, 130, this.materials_folder);
        this.materialRecipe(consumer, (MaterialVariantId)DreamtinkerMaterialIds.malignant_gluttony, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerCommon.malignant_gluttony.get()}), 1, 1, this.materials_folder + "malignant_gluttony");
        this.materialMeltingCasting(consumer, (MaterialVariantId)DreamtinkerMaterialIds.malignant_gluttony, (FluidObject)DreamtinkerFluids.molten_malignant_gluttony, 90, this.materials_folder);
    }

    private void addCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)DreamtinkerCommon.nigrescence_antimony.get()), (int)1).m_126209_((ItemLike)DreamtinkerCommon.valentinite.get()).m_126209_((ItemLike)Items.f_42583_).m_126132_("has_valentinite", (CriterionTriggerInstance)DreamtinkerRecipeProvider.m_125977_((ItemLike)((ItemLike)DreamtinkerCommon.valentinite.get()))).m_126140_(consumer, this.location("currus_triumphalis_antimonii/valentinite_nigredo"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(DreamtinkerTagkeys.Items.raw_stibnite), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)DreamtinkerCommon.valentinite.get()), (float)1.0f, (int)100).m_126132_("has_stibnite", (CriterionTriggerInstance)DreamtinkerRecipeProvider.m_206406_(DreamtinkerTagkeys.Items.raw_stibnite)).m_126140_(consumer, this.location("currus_triumphalis_antimonii/stibnite_to_valentinite"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)DreamtinkerCommon.persona_cast.get())).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_41907_).m_126127_(Character.valueOf('M'), (ItemLike)DreamtinkerCommon.twist_obsidian_pane.get()).m_126130_(" e ").m_126130_("eMe").m_126130_(" e ").m_126132_("has_item", (CriterionTriggerInstance)DreamtinkerRecipeProvider.m_125977_((ItemLike)((ItemLike)DreamtinkerCommon.twist_obsidian_pane.get()))).m_126140_(consumer, this.location("casts/" + DreamtinkerCommon.persona_cast.get()));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)DreamtinkerCommon.wish_cast.get())).m_206416_(Character.valueOf('e'), Tags.Items.GEMS_LAPIS).m_126127_(Character.valueOf('M'), (ItemLike)DreamtinkerCommon.unborn_egg.get()).m_126130_("eee").m_126130_("eMe").m_126130_("eee").m_126132_("has_item", (CriterionTriggerInstance)DreamtinkerRecipeProvider.m_125977_((ItemLike)((ItemLike)DreamtinkerCommon.unborn_egg.get()))).m_126140_(consumer, this.location("casts/" + DreamtinkerCommon.reason_cast.get()));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)DreamtinkerCommon.reason_cast.get())).m_126127_(Character.valueOf('e'), DreamtinkerCommon.narcissus.get()).m_126127_(Character.valueOf('M'), (ItemLike)Items.f_42524_).m_126130_("eee").m_126130_("eMe").m_126130_("eee").m_126132_("has_item", (CriterionTriggerInstance)DreamtinkerRecipeProvider.m_125977_((ItemLike)((ItemLike)DreamtinkerCommon.unborn_egg.get()))).m_126140_(consumer, this.location("casts/" + DreamtinkerCommon.wish_cast.get()));
        new SpiritInfusionRecipeBuilder((ItemLike)ItemRegistry.THE_VESSEL.get(), 1, new ItemStack((ItemLike)DreamtinkerCommon.malignant_gluttony.get())).addExtraItem((Item)ItemRegistry.NULL_SLATE.get(), 4).addExtraItem((Item)ItemRegistry.MALIGNANT_PEWTER_INGOT.get(), 1).addExtraItem((Item)ItemRegistry.CURSED_SAP.get(), 3).addExtraItem((Item)ItemRegistry.FUSED_CONSCIOUSNESS.get(), 1).addSpirit(SpiritTypeRegistry.WICKED_SPIRIT, 6).addSpirit(SpiritTypeRegistry.SACRED_SPIRIT, 6).addSpirit(SpiritTypeRegistry.ELDRITCH_SPIRIT, 6).addSpirit(SpiritTypeRegistry.INFERNAL_SPIRIT, 6).build(consumer, "malum_" + DreamtinkerCommon.malignant_gluttony.getId().m_135815_());
        new SpiritInfusionRecipeBuilder((ItemLike)Items.f_42446_, 1, new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(Dreamtinker.getLocation("liquid_arcana_juice_bucket"))))).addExtraItem((Item)ItemRegistry.NULL_SLATE.get(), 8).addExtraItem((Item)ItemRegistry.MNEMONIC_FRAGMENT.get(), 8).addExtraItem((Item)ItemRegistry.CURSED_SAP.get(), 2).addExtraItem((Item)ItemRegistry.RUNIC_SAP.get(), 2).addSpirit(SpiritTypeRegistry.ARCANE_SPIRIT, 6).addSpirit(SpiritTypeRegistry.AQUEOUS_SPIRIT, 6).addSpirit(SpiritTypeRegistry.SACRED_SPIRIT, 6).addSpirit(SpiritTypeRegistry.ELDRITCH_SPIRIT, 6).build(consumer, "malum_liquid_arcana_juice_bucket");
    }

    private void addPartRecipes(Consumer<FinishedRecipe> consumer) {
        this.armorPlatingBuilder(consumer, DreamtinkerMaterialIds.star_regulus);
        this.armorPlatingBuilder(consumer, DreamtinkerMaterialIds.spirit_fabric);
        PartRecipeBuilder.partRecipe((IMaterialItem)((IMaterialItem)DreamtinkerToolParts.explode_core.get())).setPattern(this.id((ItemLike)DreamtinkerToolParts.explode_core.get())).setPatternItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamtinkerToolParts.explode_core.get()})).setCost(8).save(consumer, this.location(this.partFolder + "builder/" + this.id((ItemLike)DreamtinkerToolParts.explode_core.get()).m_135815_()));
        MaterialCastingRecipeBuilder.tableRecipe((IMaterialItem)((IMaterialItem)DreamtinkerToolParts.explode_core.get())).setCast((ItemLike)Items.f_42403_, true).setItemCost(8).save(consumer, this.location(this.partFolder + "explode_core_cast"));
        CompositeCastingRecipeBuilder.table((IMaterialItem)((IMaterialItem)DreamtinkerToolParts.explode_core.get()), (int)8).save(consumer, this.location(this.castFolder + "explode_core_composite"));
        ToolPartItem[] tree_parts = new ToolPartItem[]{(ToolPartItem)DreamtinkerToolParts.memoryOrthant.get(), (ToolPartItem)DreamtinkerToolParts.wishOrthant.get(), (ToolPartItem)DreamtinkerToolParts.soulOrthant.get(), (ToolPartItem)DreamtinkerToolParts.personaOrthant.get(), (ToolPartItem)DreamtinkerToolParts.reasonEmanation.get()};
        Item[] tree_casts = new Item[]{(Item)DreamtinkerCommon.memory_cast.get(), (Item)DreamtinkerCommon.wish_cast.get(), (Item)DreamtinkerCommon.soul_cast.get(), (Item)DreamtinkerCommon.persona_cast.get(), (Item)DreamtinkerCommon.reason_cast.get()};
        int[] tree_costs = new int[]{8, 3, 3, 3, 8};
        for (int i = 0; i < tree_parts.length; ++i) {
            PartRecipeBuilder.partRecipe((IMaterialItem)tree_parts[i]).setPattern(this.id((ItemLike)tree_parts[i])).setPatternItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{tree_casts[i]})).setCost(tree_costs[i]).save(consumer, this.location(this.partFolder + "builder/" + this.id((ItemLike)tree_parts[i]).m_135815_()));
            MaterialCastingRecipeBuilder.tableRecipe((IMaterialItem)tree_parts[i]).setItemCost(tree_costs[i]).setCast((ItemLike)tree_casts[i], true).save(consumer, this.location(this.castFolder + this.id((ItemLike)tree_parts[i]).m_135815_() + "_cast"));
            CompositeCastingRecipeBuilder.table((IMaterialItem)tree_parts[i], (int)tree_costs[i]).save(consumer, this.location(this.castFolder + this.id((ItemLike)tree_parts[i]).m_135815_() + "_composite"));
        }
        this.malumCompactMaterialBuilder(consumer, DreamtinkerMaterialIds.mnemonic_fragment, 4, HeadMaterialStats.ID);
        this.malumCompactMaterialBuilder(consumer, DreamtinkerMaterialIds.mnemonic_fragment, 4, HandleMaterialStats.ID);
        this.malumCompactMaterialBuilder(consumer, DreamtinkerMaterialIds.mnemonic_fragment, 4, StatlessMaterialStats.BINDING.getIdentifier());
    }

    private void armorPlatingBuilder(Consumer<FinishedRecipe> consumer, MaterialId id) {
        ArrayList<CastItemObject> armor_casts = new ArrayList<CastItemObject>(Arrays.asList(TinkerSmeltery.helmetPlatingCast, TinkerSmeltery.chestplatePlatingCast, TinkerSmeltery.leggingsPlatingCast, TinkerSmeltery.bootsPlatingCast));
        List toolParts = TinkerToolParts.plating.values();
        int[] armor_costs = new int[]{3, 6, 5, 2};
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Material", id.toString());
        for (int i = 0; i < armor_casts.size(); ++i) {
            ItemStack stack = new ItemStack((ItemLike)toolParts.get(i));
            stack.m_41784_().m_128391_(nbt);
            ItemPartRecipeBuilder.item((ResourceLocation)armor_casts.get(i).getName(), (ItemOutput)ItemOutput.fromStack((ItemStack)stack)).material(id, armor_costs[i]).setPatternItem(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)TinkerTags.Items.DEFAULT_PATTERNS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{armor_casts.get(i).get()})})).save(consumer, this.location(this.partFolder + "builder/" + id.m_135815_() + "/" + armor_casts.get(i).getName().m_135815_()));
        }
    }

    private void malumCompactMaterialBuilder(Consumer<FinishedRecipe> consumer, MaterialId id, int value, MaterialStatsId statsId) {
        List<ToolPartItem> Parts = DThelper.getPartList(statsId);
        Map<ToolPartItem, CastLookup.CastTriple> map = CastLookup.findCastsForParts(Parts);
        for (ToolPartItem part : Parts) {
            Item castItem = map.get(part).cast();
            if (part == DreamtinkerToolParts.memoryOrthant.get()) {
                castItem = (Item)DreamtinkerCommon.memory_cast.get();
            }
            if (part == DreamtinkerToolParts.reasonEmanation.get()) {
                castItem = (Item)DreamtinkerCommon.reason_cast.get();
            }
            if (part == DreamtinkerToolParts.explode_core.get()) {
                castItem = (Item)DreamtinkerToolParts.explode_core.get();
            }
            if (part == DreamtinkerToolParts.wishOrthant.get()) {
                castItem = (Item)DreamtinkerCommon.wish_cast.get();
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Material", id.toString());
            ItemStack stack = new ItemStack((ItemLike)part);
            stack.m_41784_().m_128391_(nbt);
            new SpiritInfusionRecipeBuilder((ItemLike)castItem, 1, stack).addExtraItem((Item)ItemRegistry.MNEMONIC_FRAGMENT.get(), 2 * value).addExtraItem((Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get(), 1).addExtraItem((Item)ItemRegistry.AURIC_EMBERS.get(), 2 * value).addExtraItem((Item)ItemRegistry.FUSED_CONSCIOUSNESS.get(), 1).addSpirit(SpiritTypeRegistry.WICKED_SPIRIT, 6 * value).addSpirit(SpiritTypeRegistry.AERIAL_SPIRIT, 4 * value).addSpirit(SpiritTypeRegistry.AQUEOUS_SPIRIT, 2 * value).addSpirit(SpiritTypeRegistry.ELDRITCH_SPIRIT, 2 * value).addSpirit(SpiritTypeRegistry.INFERNAL_SPIRIT, 2 * value).build(consumer, id.m_135815_() + "_" + part);
        }
    }

    private void addModifierRecipes(Consumer<FinishedRecipe> consumer) {
        String upgradeFolder = "tools/modifiers/upgrade/";
        String abilityFolder = "tools/modifiers/ability/";
        String slotlessFolder = "tools/modifiers/slotless/";
        String defenseFolder = "tools/modifiers/defense/";
        String compatFolder = "tools/modifiers/compat/";
        String worktableFolder = "tools/modifiers/worktable/";
        String soulFolder = "tools/modifiers/soul/";
        String salvageFolder = "tools/modifiers/salvage/";
        String upgradeSalvage = salvageFolder + "upgrade/";
        String abilitySalvage = salvageFolder + "ability/";
        String defenseSalvage = salvageFolder + "defense/";
        String compatSalvage = salvageFolder + "compat/";
        String soulSalvage = salvageFolder + "soul/";
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.real_sweep).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.mashou.get()}))).addInput((ItemLike)Items.f_220224_).addInput((ItemLike)Items.f_220224_).setMaxLevel(2)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.real_sweep, abilitySalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.real_sweep, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.strong_explode).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.tntarrow.get()}))).addInput((ItemLike)TinkerGadgets.efln).addInput(Tags.Items.GUNPOWDER).setMaxLevel(3)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.strong_explode, upgradeSalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.strong_explode, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.continuous_explode).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.tntarrow.get()}))).addInput((ItemLike)TinkerGadgets.efln).addInput((ItemLike)Items.f_41996_).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.continuous_explode, abilitySalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.continuous_explode, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.continuous_explode).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.tntarrow.get()}))).addInput((ItemLike)Items.f_41996_).addInput(Tags.Items.GUNPOWDER).setMinLevel(2)).setMaxLevel(3)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.continuous_explode, upgradeSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.continuous_explode, upgradeFolder));
        ((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.mei).setTools(TinkerTags.Items.MELEE)).addInput((ItemLike)Items.f_41940_).addInput((ItemLike)Items.f_41940_).addInput((ItemLike)Items.f_42026_).addInput((ItemLike)Items.f_42026_).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.mei, slotlessFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.ender_slayer).setTools(TinkerTags.Items.MELEE)).addInput(Tags.Items.OBSIDIAN, 2).addInput((ItemLike)Items.f_42586_, 2).addInput((ItemLike)Items.f_42545_, 2).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.ender_slayer, abilitySalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.ender_slayer, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.life_looting).setTools(TinkerTags.Items.MODIFIABLE)).addInput((ItemLike)EnigmaticItems.LORE_INSCRIBER, 1).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.life_looting, abilitySalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)EnigmaticItems.LORE_INSCRIBER))}), this.prefix((IdAwareObject)DreamtinkerModifiers.life_looting, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.life_looting).setTools(TinkerTags.Items.MODIFIABLE)).addInput(Tags.Items.GEMS_EMERALD, 1).addInput(Tags.Items.STORAGE_BLOCKS_EMERALD, 1).addInput(Tags.Items.GEMS_EMERALD, 1).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).save(consumer, this.wrap((IdAwareObject)DreamtinkerModifiers.life_looting, abilityFolder, "_1"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.weapon_books).setTools(TinkerTags.Items.MELEE_PRIMARY)).addInput((ItemLike)EnigmaticItems.THE_ACKNOWLEDGMENT, 1).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.weapon_books, abilitySalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.weapon_books, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.weapon_books).setTools(TinkerTags.Items.MELEE_PRIMARY)).addInput((ItemLike)EnigmaticItems.THE_TWIST, 1).setLevelRange(2, 2)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.weapon_books, upgradeSalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.weapon_books, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.weapon_books).setTools(TinkerTags.Items.MELEE_PRIMARY)).addInput((ItemLike)EnigmaticItems.THE_INFINITUM, 1).setLevelRange(3, 3)).setSlots(SlotType.SOUL, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.weapon_books, soulSalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.weapon_books, soulFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.eldritch_pan).setTools(TinkerTags.Items.MELEE_PRIMARY)).addInput((ItemLike)EnigmaticItems.ELDRITCH_PAN, 1).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.eldritch_pan, abilitySalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.eldritch_pan, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.desolation_ring).setTools(TinkerTags.Items.MODIFIABLE)).addInput((ItemLike)EnigmaticItems.EVIL_ESSENCE, 2).addInput((ItemLike)Items.f_42716_, 2).addInput(Tags.Items.INGOTS_NETHERITE, 2).addInput((ItemLike)EnigmaticItems.ABYSSAL_HEART, 2).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.desolation_ring, abilitySalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.desolation_ring, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.soul_upgrade).setTools(TinkerTags.Items.MODIFIABLE)).addInput((ItemLike)DreamtinkerCommon.twist_obsidian_pane.get(), 1).setMaxLevel(3)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.soul_upgrade, upgradeSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.soul_upgrade, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.soul_core).setTools(TinkerTags.Items.MELEE_WEAPON)).addInput((ItemLike)DreamtinkerCommon.unborn_turtle_egg.get(), 1).setMaxLevel(1)).setSlots(SlotType.SOUL, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.soul_core, soulSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.soul_core, soulFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.soul_core).setTools(TinkerTags.Items.MELEE_WEAPON)).addInput((ItemLike)DreamtinkerCommon.unborn_turtle_egg.get(), 1).addInput((ItemLike)DreamtinkerCommon.unborn_sniffer_egg.get(), 1).setMaxLevel(3)).setSlots(SlotType.SOUL, 1)).save(consumer, this.wrap((ResourceLocation)DreamtinkerModifiers.Ids.soul_core, soulFolder, "_1"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.memory_base).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.narcissus_wing.get()}))).addInput(DreamtinkerTools.narcissus_wing).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.memory_base, abilitySalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.memory_base, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.icy_memory).setTools(TinkerTags.Items.MELEE_WEAPON)).addInput((ItemLike)DreamtinkerCommon.unborn_egg.get()).addInput((ItemLike)Items.f_151055_).setMaxLevel(2)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.icy_memory, upgradeSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.icy_memory, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.hate_memory).setTools(TinkerTags.Items.MELEE_WEAPON)).addInput((ItemLike)DreamtinkerCommon.unborn_egg.get()).addInput((ItemLike)Items.f_42660_).addInput((ItemLike)Items.f_42386_).addInput(Tags.Items.TOOLS_CROSSBOWS).setMaxLevel(3)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.hate_memory, upgradeSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.hate_memory, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.foundation_will).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.narcissus_wing}))).addInput((ItemLike)DreamtinkerCommon.unborn_turtle_egg.get()).addInput((ItemLike)DreamtinkerCommon.unborn_turtle_egg.get()).addInput(TinkerTags.Items.HARVEST_PRIMARY).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.foundation_will, upgradeSalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.foundation_will, upgradeFolder));
        ((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.huge_ego).addInput((ItemLike)DreamtinkerCommon.persona_cast.get()).addInput((ItemLike)DreamtinkerCommon.persona_cast.get()).setMaxLevel(3)).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.huge_ego, slotlessFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.malum_rebound).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTagRegistry.SCYTHE), Ingredient.m_204132_((TagKey)TinkerTags.Items.MELEE_WEAPON)}))).addInput((ItemLike)ItemRegistry.CRUDE_SCYTHE.get()).addInput((ItemLike)ItemRegistry.EARTHEN_SPIRIT.get()).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_rebound, abilitySalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.CRUDE_SCYTHE.get())))}), this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_rebound, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.malum_rebound).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTagRegistry.SCYTHE), Ingredient.m_204132_((TagKey)TinkerTags.Items.MELEE_WEAPON)}))).addInput((ItemLike)ItemRegistry.CRUDE_SCYTHE.get()).setLevelRange(2, 3)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_rebound, upgradeSalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.CRUDE_SCYTHE.get())))}), this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_rebound, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.malum_ascension).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTagRegistry.SCYTHE), Ingredient.m_204132_((TagKey)TinkerTags.Items.MELEE_WEAPON)}))).addInput((ItemLike)ItemRegistry.CRUDE_SCYTHE.get()).addInput((ItemLike)ItemRegistry.AERIAL_SPIRIT.get()).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_ascension, abilitySalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.CRUDE_SCYTHE.get())))}), this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_ascension, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.malum_ascension).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTagRegistry.SCYTHE), Ingredient.m_204132_((TagKey)TinkerTags.Items.MELEE_WEAPON)}))).addInput((ItemLike)ItemRegistry.CRUDE_SCYTHE.get()).setLevelRange(2, 3)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_ascension, upgradeSalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.CRUDE_SCYTHE.get())))}), this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_ascension, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.malum_animated).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTagRegistry.SCYTHE), Ingredient.m_204132_((TagKey)TinkerTags.Items.MELEE_WEAPON)}))).addInput((ItemLike)ItemRegistry.WICKED_SPIRIT.get()).addInput((ItemLike)ItemRegistry.AERIAL_SPIRIT.get()).setMaxLevel(2)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_animated, upgradeSalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.WICKED_SPIRIT.get())))}), this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_animated, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.malum_haunted).setTools(Ingredient.m_204132_((TagKey)TinkerTags.Items.MELEE_WEAPON))).addInput((ItemLike)ItemRegistry.WICKED_SPIRIT.get()).addInput((ItemLike)ItemRegistry.SACRED_SPIRIT.get()).setMaxLevel(2)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_haunted, upgradeSalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.WICKED_SPIRIT.get())))}), this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_haunted, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.malum_spirit_plunder).setTools(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTagRegistry.SOUL_HUNTER_WEAPON), Ingredient.m_204132_((TagKey)TinkerTags.Items.MELEE_WEAPON)}))).addInput((ItemLike)ItemRegistry.SACRED_SPIRIT.get()).addInput((ItemLike)ItemRegistry.SACRED_SPIRIT.get()).setMaxLevel(2)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_spirit_plunder, upgradeSalvage))).save(this.withCondition(consumer, new ICondition[]{new ItemExistsCondition(ForgeRegistries.ITEMS.getKey((Object)((Item)ItemRegistry.WICKED_SPIRIT.get())))}), this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.malum_spirit_plunder, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(DreamtinkerModifiers.flaming_memory).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.narcissus_wing}))).addInput((ItemLike)DreamtinkerToolParts.memoryOrthant.get(), 1).addInput((ItemLike)DreamtinkerCommon.nigrescence_antimony.get(), 6).setMaxLevel(1)).setSlots(SlotType.ABILITY, 2)).saveSalvage(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.flaming_memory, abilitySalvage))).save(consumer, this.prefix((IdAwareObject)DreamtinkerModifiers.flaming_memory, abilityFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.el_torrent).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.mashou}))).addInput(Tags.Items.DUSTS_PRISMARINE, 15).addInput(Tags.Items.GEMS_PRISMARINE, 15).setMaxLevel(5)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_torrent, upgradeSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_torrent, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.el_wrath).setTools(Ingredient.m_43929_((ItemLike[])new ItemLike[]{DreamtinkerTools.mashou}))).addInput((ItemLike)Items.f_42192_, 4).addInput(Tags.Items.GEMS_PRISMARINE, 15).setMaxLevel(4)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_wrath, upgradeSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_wrath, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.el_slayer).setTools(TinkerTags.Items.MELEE_PRIMARY)).addInput((ItemLike)Items.f_42383_).addInput((ItemLike)Items.f_42383_).addInput((ItemLike)Items.f_42430_).addInput((ItemLike)Items.f_42386_).addInput((ItemLike)Items.f_42386_).setMaxLevel(4)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_slayer, upgradeSalvage))).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_slayer, upgradeFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.el_eternal_binding).setTools(TinkerTags.Items.MODIFIABLE)).addInput((ItemLike)Items.f_42026_, 10).addInput((ItemLike)Items.f_42100_).setMaxLevel(1)).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_eternal_binding, slotlessFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.el_sorrow).setTools(TinkerTags.Items.ARMOR)).addInput((ItemLike)Items.f_41907_, 10).addInput((ItemLike)Items.f_42100_).setMaxLevel(1)).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_sorrow, slotlessFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)DreamtinkerModifiers.Ids.el_nemesis_curse).setTools(TinkerTags.Items.MELEE_PRIMARY)).addInput((ItemLike)Items.f_42740_).addInput((ItemLike)Items.f_42100_).setMaxLevel(1)).save(consumer, this.prefix((ResourceLocation)DreamtinkerModifiers.Ids.el_nemesis_curse, slotlessFolder));
    }

    private void addEntityMeltingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/entity_melting/";
        String headFolder = "smeltery/entity_melting/heads/";
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_217015_}), (FluidOutput)DreamtinkerFluids.molten_echo_shard.result(25), (int)5).save(consumer, this.location(folder + "molten_echo_shard"));
    }

    @NotNull
    public String getModId() {
        return "dreamtinker";
    }

    private static TagKey<Item> forgeItemTag(String name) {
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", name));
    }

    private static TagKey<Fluid> forgeFluidTag(String name) {
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", name));
    }

    private static TagKey<Item> tconItemTag(String name) {
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation("tconstruct", name));
    }

    private static TagKey<Fluid> tconfluidTag(String name) {
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation("tconstruct", name));
    }

    private void cast(Fluid fluid, ItemLike ingredient, int amount, Consumer<FinishedRecipe> consumer) {
        CastItemObject cast = 100 == amount ? TinkerSmeltery.gemCast : (90 == amount ? TinkerSmeltery.ingotCast : TinkerSmeltery.nuggetCast);
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)ingredient).setCoolingTime(IMeltingRecipe.getTemperature((Fluid)fluid), amount).setFluid(FluidIngredient.of((FluidStack)new FluidStack(fluid, amount))).setCast(cast.getSingleUseTag(), true).save(consumer, this.location("smeltery/casting/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ingredient.m_5456_())).m_135815_() + "/single"));
        ItemCastingRecipeBuilder.tableRecipe((ItemLike)ingredient).setCoolingTime(IMeltingRecipe.getTemperature((Fluid)fluid), amount).setFluid(FluidIngredient.of((FluidStack)new FluidStack(fluid, amount))).setCast(cast.getMultiUseTag(), false).save(consumer, this.location("smeltery/casting/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ingredient.m_5456_())).m_135815_() + "/multi"));
    }
}

