/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.common.data.model;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import org.dreamtinker.dreamtinker.Dreamtinker;
import org.dreamtinker.dreamtinker.common.DreamtinkerCommon;
import org.dreamtinker.dreamtinker.fluids.DreamtinkerFluids;
import org.dreamtinker.dreamtinker.tools.DreamtinkerToolParts;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.data.model.MaterialModelBuilder;
import slimeknights.tconstruct.library.tools.part.MaterialItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;

public class DreamtinkerItemModelProvider
extends ItemModelProvider {
    public static final String parent_item = "item/generated";
    public static final String parent_fluid = "forge:item/bucket_drip";

    public DreamtinkerItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "dreamtinker", existingFileHelper);
    }

    public void generateItemModel(RegistryObject<Item> object, String typePath) {
        ((ItemModelBuilder)this.withExistingParent(object.getId().m_135815_(), parent_item)).texture("layer0", this.getItemLocation(object.getId().m_135815_(), typePath));
    }

    public void generateBlockItemModel(ItemObject<Block> object) {
        this.withExistingParent(object.getId().m_135815_(), this.getBlockItemLocation(object.getId().m_135815_()));
    }

    public void generateBucketItemModel(FluidObject<ForgeFlowingFluid> object) {
        ((ItemModelBuilder)this.withExistingParent(object.getId().m_135815_() + "_bucket", parent_fluid)).customLoader((itemModelBuilder, existingFileHelper) -> DynamicFluidContainerModelBuilder.begin((ModelBuilder)itemModelBuilder, (ExistingFileHelper)existingFileHelper).fluid(object.get()));
    }

    public ResourceLocation getItemLocation(String path, String typePath) {
        return new ResourceLocation("dreamtinker", "item/" + (String)(typePath.isEmpty() ? typePath : typePath + "/") + path);
    }

    public ResourceLocation getBlockItemLocation(String path) {
        return new ResourceLocation("dreamtinker", "block/" + path);
    }

    protected void registerModels() {
        this.generateItemModel(DreamtinkerCommon.raw_stibnite, "materials");
        this.generateItemModel(DreamtinkerCommon.valentinite, "materials");
        this.generateItemModel(DreamtinkerCommon.nigrescence_antimony, "materials");
        this.generateItemModel(DreamtinkerCommon.metallivorous_stibium_lupus, "materials");
        this.generateItemModel(DreamtinkerCommon.regulus, "materials");
        this.generateItemModel(DreamtinkerCommon.void_pearl, "");
        this.generateItemModel(DreamtinkerCommon.soul_etherium, "materials");
        this.generateItemModel(DreamtinkerCommon.twist_obsidian_pane, "");
        this.generateItemModel(DreamtinkerCommon.memory_cast, "casts");
        this.generateItemModel(DreamtinkerCommon.wish_cast, "casts");
        this.generateItemModel(DreamtinkerCommon.soul_cast, "casts");
        this.generateItemModel(DreamtinkerCommon.persona_cast, "casts");
        this.generateItemModel(DreamtinkerCommon.reason_cast, "casts");
        this.generateItemModel(DreamtinkerCommon.white_peach, "");
        this.generateItemModel(DreamtinkerCommon.unborn_egg, "");
        this.generateItemModel(DreamtinkerCommon.unborn_turtle_egg, "");
        this.generateItemModel(DreamtinkerCommon.unborn_sniffer_egg, "");
        this.generateItemModel(DreamtinkerCommon.unborn_dragon_egg, "");
        this.generateItemModel(DreamtinkerCommon.unborn_spawn_egg, "");
        this.generateItemModel(DreamtinkerCommon.echo_alloy, "materials");
        this.generateItemModel(DreamtinkerCommon.malignant_gluttony, "materials");
        this.generateItemModel(DreamtinkerCommon.larimar, "materials");
        this.generateBucketItemModel((FluidObject<ForgeFlowingFluid>)DreamtinkerFluids.molten_echo_shard);
        this.generateBucketItemModel((FluidObject<ForgeFlowingFluid>)DreamtinkerFluids.molten_albedo_stibium);
        this.generateBucketItemModel((FluidObject<ForgeFlowingFluid>)DreamtinkerFluids.molten_lupi_antimony);
        this.generateBucketItemModel((FluidObject<ForgeFlowingFluid>)DreamtinkerFluids.molten_ascending_antimony);
        this.generateBucketItemModel((FluidObject<ForgeFlowingFluid>)DreamtinkerFluids.liquid_smoky_antimony);
        this.generateBucketItemModel((FluidObject<ForgeFlowingFluid>)DreamtinkerFluids.molten_crying_obsidian);
        this.part((ToolPartItem)DreamtinkerToolParts.explode_core.get());
        this.part((ToolPartItem)DreamtinkerToolParts.memoryOrthant.get());
        this.part((ToolPartItem)DreamtinkerToolParts.wishOrthant.get());
        this.part((ToolPartItem)DreamtinkerToolParts.soulOrthant.get());
        this.part((ToolPartItem)DreamtinkerToolParts.personaOrthant.get());
        this.part((ToolPartItem)DreamtinkerToolParts.reasonEmanation.get());
    }

    private MaterialModelBuilder<ItemModelBuilder> part(ResourceLocation part, String texture) {
        return (MaterialModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(part.m_135815_(), "forge:item/default")).texture("texture", Dreamtinker.getLocation("item/tool/" + texture))).customLoader(MaterialModelBuilder::new);
    }

    private MaterialModelBuilder<ItemModelBuilder> part(Item item, String texture) {
        return this.part(this.id((ItemLike)item), texture);
    }

    private MaterialModelBuilder<ItemModelBuilder> part(ItemObject<? extends MaterialItem> part, String texture) {
        return this.part(part.getId(), texture);
    }

    private void part(ToolPartItem part) {
        this.part((Item)part, "parts/" + this.id((ItemLike)part).m_135815_());
    }

    private ResourceLocation id(ItemLike item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
    }
}

