/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.common.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.dreamtinker.dreamtinker.library.client.PlayerKeyStateProvider;
import org.dreamtinker.dreamtinker.network.KeyStateMsg;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="dreamtinker")
public final class PlayerKeyBindingCap {
    @SubscribeEvent
    public static void onAttach(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player) {
            e.addCapability(PlayerKeyStateProvider.KEY, (ICapabilityProvider)new PlayerKeyStateProvider());
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone e) {
        e.getOriginal().reviveCaps();
        e.getOriginal().getCapability(PlayerKeyStateProvider.PlayerKeyState.CAP).ifPresent(oldCap -> e.getEntity().getCapability(PlayerKeyStateProvider.PlayerKeyState.CAP).ifPresent(newCap -> {
            CompoundTag nbt = (CompoundTag)oldCap.serializeNBT();
            newCap.deserializeNBT((Tag)nbt);
        }));
        e.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(PlayerKeyStateProvider.PlayerKeyState.CAP).ifPresent(cap -> {
                for (KeyStateMsg.KeyKind k : KeyStateMsg.KeyKind.values()) {
                    cap.set(k, false);
                }
            });
        }
    }
}

