/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;

@Mod.EventBusSubscriber(modid="dreamtinker", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DreamtinkerCachedConfig {
    public static final ConfigLazy<Integer> TNT_ARROW_GRAVITY = DreamtinkerCachedConfig.lazIntInSpec(DreamtinkerConfig.tnt_arrow_gravity);
    public static final ConfigLazy<Integer> TNT_ARROW_RADIUS = DreamtinkerCachedConfig.lazIntInSpec(DreamtinkerConfig.tnt_arrow_radius);
    public static final ConfigLazy<Integer> StrongExplodeDamageBoost = DreamtinkerCachedConfig.lazIntInSpec(DreamtinkerConfig.StrongExplodeDamageBoost);
    public static final ConfigLazy<Double> UnderPlateBoostMax = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.UnderPlateBoostMax);
    public static final ConfigLazy<Double> UnderPlateBoostArmorFactor = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.UnderPlateBoostArmorFactor);
    public static final ConfigLazy<Double> UnderPlateBoostToughnessFactor = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.UnderPlateBoostToughnessFactor);
    public static final ConfigLazy<Integer> StarRegulusMaxHP = DreamtinkerCachedConfig.lazIntInSpec(DreamtinkerConfig.StarRegulusMaxHP);
    public static final ConfigLazy<Boolean> StarRegulusAdvancement = DreamtinkerCachedConfig.lazBoolInSpec(DreamtinkerConfig.StarRegulusAdvancement);
    public static final ConfigLazy<Integer> SilverNameBeeNum = DreamtinkerCachedConfig.lazIntInSpec(DreamtinkerConfig.SilverNameBeeNum);
    public static final ConfigLazy<Double> AntimonyLootChance = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.AntimonyLootChance);
    public static final ConfigLazy<Double> voidPearlDropRate = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.voidPearlDropRate);
    public static final ConfigLazy<Double> voidPearlDamage = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.voidPearlDamage);
    public static final ConfigLazy<Double> WhitePeachLootChance = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.WhitePeachLootChance);
    public static final ConfigLazy<Double> SoulCastLoveLootChance = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.SoulCastLoveLootChance);
    public static final ConfigLazy<Double> glacialRiverPortion = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.glacialRiverPortion);
    public static final ConfigLazy<Integer> glacialRiverRange = DreamtinkerCachedConfig.lazIntInSpec(DreamtinkerConfig.glacialRiverRange);
    public static final ConfigLazy<Boolean> glacialRiverKillPlayer = DreamtinkerCachedConfig.lazBoolInSpec(DreamtinkerConfig.glacialRiverKillPlayer);
    public static final ConfigLazy<Integer> EchoAttackCharge = DreamtinkerCachedConfig.lazIntInSpec(DreamtinkerConfig.EchoAttackCharge);
    public static final ConfigLazy<Double> EchoAttackChargingChance = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.EchoAttackChargingChance);
    public static final ConfigLazy<Double> EchoDefenceRange = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.EchoDefenceRange);
    public static final ConfigLazy<Double> EchoDefenceSpeed = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.EchoDefenceSpeed);
    public static final ConfigLazy<Double> flamingMemoryStatusBoost = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.flamingMemoryStatusBoost);
    public static final ConfigLazy<Double> thunderCurse = DreamtinkerCachedConfig.lazDoubleInSpec(DreamtinkerConfig.thunderCurse);
    public static final ConfigLazy<List<Double>> TheSplendourHeart = DreamtinkerCachedConfig.lazDoubleList(DreamtinkerConfig.TheSplendourHeart, true, false, 0.0, 1.0, 5);

    @SubscribeEvent
    public static void onConfigLoading(ModConfigEvent.Loading e) {
        if (e.getConfig().getModId().equals("dreamtinker")) {
            ConfigLazy.invalidateAll();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading e) {
        if (e.getConfig().getModId().equals("dreamtinker")) {
            ConfigLazy.invalidateAll();
        }
    }

    public static ConfigLazy<Integer> lazIntInSpec(ForgeConfigSpec.IntValue v) {
        return ConfigLazy.of(v, () -> ((ForgeConfigSpec.IntValue)v).getDefault(), x -> true, x -> x);
    }

    public static ConfigLazy<Double> lazDoubleInSpec(ForgeConfigSpec.DoubleValue v) {
        return ConfigLazy.of(v, () -> ((ForgeConfigSpec.DoubleValue)v).getDefault(), x -> true, x -> x);
    }

    public static ConfigLazy<Boolean> lazBoolInSpec(ForgeConfigSpec.BooleanValue v) {
        return ConfigLazy.of(v, () -> ((ForgeConfigSpec.BooleanValue)v).getDefault(), x -> true, x -> x);
    }

    private static ConfigLazy<List<Double>> lazDoubleList(ForgeConfigSpec.ConfigValue<List<? extends Number>> cfg, boolean sortAscending, boolean distinct, double minInclusive, double maxInclusive, int requiredSizeOrMinusOne) {
        Function<List, List> mapToDoubles = xs -> {
            if (xs == null) {
                return List.of();
            }
            ArrayList<Double> out = new ArrayList<Double>(xs.size());
            for (Number n : xs) {
                if (n == null) continue;
                out.add(n.doubleValue());
            }
            return out;
        };
        Supplier<List> raw = () -> (List)mapToDoubles.apply((List)cfg.get());
        Supplier<List> defSup = () -> {
            List def = (List)cfg.getDefault();
            List mapped = (List)mapToDoubles.apply(def);
            return List.copyOf(mapped);
        };
        return ConfigLazy.of(raw, defSup, list -> {
            if (list == null) {
                return false;
            }
            if (requiredSizeOrMinusOne >= 0 && list.size() != requiredSizeOrMinusOne) {
                return false;
            }
            for (Double d : list) {
                if (d != null && !(d < minInclusive) && !(d > maxInclusive)) continue;
                return false;
            }
            return true;
        }, list -> {
            ArrayList out = new ArrayList(list);
            if (sortAscending) {
                out.sort(Comparator.naturalOrder());
            }
            if (distinct) {
                out = new ArrayList(new LinkedHashSet(out));
            }
            return Collections.unmodifiableList(out);
        });
    }

    private static ConfigLazy<List<String>> lazStringList(ForgeConfigSpec.ConfigValue<List<? extends String>> cfg, boolean sort, boolean distinct, boolean lowerCase) {
        Function<List, List> toStrings = xs -> {
            if (xs == null) {
                return List.of();
            }
            return List.copyOf(xs);
        };
        Supplier<List> raw = () -> (List)toStrings.apply((List)cfg.get());
        Supplier<List> defSup = () -> List.copyOf((Collection)toStrings.apply((List)cfg.getDefault()));
        return ConfigLazy.of(raw, defSup, xs -> xs != null, xs -> {
            ArrayList<String> out = new ArrayList<String>();
            for (String s : xs) {
                if (s == null) continue;
                String t = s.trim();
                if (lowerCase) {
                    t = t.toLowerCase(Locale.ROOT);
                }
                if (t.isEmpty()) continue;
                out.add(t);
            }
            if (sort) {
                out.sort(Comparator.naturalOrder());
            }
            if (distinct) {
                out = new ArrayList(new LinkedHashSet(out));
            }
            return Collections.unmodifiableList(out);
        });
    }

    public static final class ConfigLazy<T> {
        private static final ConcurrentLinkedQueue<ConfigLazy<?>> REGISTRY = new ConcurrentLinkedQueue();
        private final Supplier<T> rawSupplier;
        private final Supplier<T> defaultSupplier;
        private final Predicate<? super T> validator;
        private final Function<? super T, ? extends T> normalizer;
        private final AtomicReference<T> cache = new AtomicReference<Object>(null);

        private ConfigLazy(Supplier<T> rawSupplier, Supplier<T> defaultSupplier, Predicate<? super T> validator, Function<? super T, ? extends T> normalizer) {
            this.rawSupplier = Objects.requireNonNull(rawSupplier, "rawSupplier");
            this.defaultSupplier = Objects.requireNonNull(defaultSupplier, "defaultSupplier");
            this.validator = Objects.requireNonNull(validator, "validator");
            this.normalizer = Objects.requireNonNull(normalizer, "normalizer");
            REGISTRY.add(this);
        }

        public T get() {
            T v = this.cache.get();
            if (v != null) {
                return v;
            }
            T loaded = this.safeLoad();
            this.cache.compareAndSet(null, loaded);
            return this.cache.get();
        }

        public void invalidate() {
            this.cache.set(null);
        }

        private T safeLoad() {
            T norm;
            T raw;
            try {
                raw = this.rawSupplier.get();
            }
            catch (Throwable t) {
                return this.defaultSupplier.get();
            }
            if (raw == null) {
                return this.defaultSupplier.get();
            }
            try {
                norm = this.normalizer.apply(raw);
            }
            catch (Throwable t) {
                return this.defaultSupplier.get();
            }
            return this.validator.test(norm) ? norm : this.defaultSupplier.get();
        }

        public static <T> ConfigLazy<T> of(Supplier<T> rawSupplier, Supplier<T> defaultSupplier, Predicate<? super T> validator, Function<? super T, ? extends T> normalizer) {
            return new ConfigLazy<T>(rawSupplier, defaultSupplier, validator, normalizer);
        }

        public static <T> ConfigLazy<T> of(Supplier<T> rawSupplier, Supplier<T> defaultSupplier) {
            return ConfigLazy.of(rawSupplier, defaultSupplier, x -> true, Function.identity());
        }

        public static void invalidateAll() {
            REGISTRY.forEach((Consumer<ConfigLazy<?>>)((Consumer<ConfigLazy>)ConfigLazy::invalidate));
        }
    }
}

