/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.library.LootModifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.dreamtinker.dreamtinker.common.DreamtinkerCommon;
import org.dreamtinker.dreamtinker.config.DreamtinkerCachedConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ExtraDropLootModifier
extends LootModifier {
    private final Item result;
    private final List<TagKey<Block>> target_tags;
    private final Map<Item, Double> rates = Map.of((Item)DreamtinkerCommon.raw_stibnite.get(), DreamtinkerCachedConfig.AntimonyLootChance.get(), (Item)DreamtinkerCommon.white_peach.get(), DreamtinkerCachedConfig.WhitePeachLootChance.get());
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<ExtraDropLootModifier> CODEC = RecordCodecBuilder.create(inst -> ExtraDropLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("result").forGetter(m -> m.result)).and((App)ResourceLocation.f_135803_.listOf().optionalFieldOf("target_tags", List.of()).forGetter(m -> m.target_tags.stream().map(TagKey::f_203868_).toList())).apply((Applicative)inst, (conditions, item, tagLocs) -> {
        List<TagKey<Block>> tags = tagLocs.stream().map(loc -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)loc)).toList();
        return new ExtraDropLootModifier((LootItemCondition[])conditions, (Item)item, tags);
    }));

    public ExtraDropLootModifier(LootItemCondition[] conditions, Item result, List<TagKey<Block>> target_tags) {
        super(conditions);
        this.result = result;
        this.target_tags = List.copyOf(target_tags);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> objectArrayList, LootContext lootContext) {
        block7: {
            block6: {
                BlockState state = (BlockState)lootContext.m_78953_(LootContextParams.f_81461_);
                if (state == null) break block6;
                if (!this.target_tags.stream().noneMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) break block7;
            }
            return objectArrayList;
        }
        int fortune = 0;
        if (lootContext.m_78936_(LootContextParams.f_81463_)) {
            ItemStack tool = (ItemStack)lootContext.m_165124_(LootContextParams.f_81463_);
            fortune = tool.getEnchantmentLevel(Enchantments.f_44987_);
            if (tool.getEnchantmentLevel(Enchantments.f_44985_) > 0) {
                return objectArrayList;
            }
        }
        float chance = (float)((double)((float)(fortune + 1) + lootContext.m_78945_()) * this.rates.getOrDefault(this.result, 1.0));
        if (lootContext.m_230907_().m_188501_() < chance) {
            int amount = 1 + lootContext.m_230907_().m_188503_((int)((float)(1 + fortune) + lootContext.m_78945_()));
            objectArrayList.add((Object)new ItemStack((ItemLike)this.result, amount));
        }
        return objectArrayList;
    }

    public Codec<ExtraDropLootModifier> codec() {
        return CODEC;
    }
}

