/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.library.client;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.dreamtinker.dreamtinker.network.KeyStateMsg;
import org.jetbrains.annotations.NotNull;

public class PlayerKeyStateProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation KEY = new ResourceLocation("dreamtinker", "key_state");
    private final PlayerKeyState backend = new PlayerKeyState();
    private final LazyOptional<IPlayerKeyState> optional = LazyOptional.of(() -> this.backend);

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == PlayerKeyState.CAP ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.backend.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.backend.deserializeNBT(nbt);
    }

    public static class PlayerKeyState
    implements IPlayerKeyState {
        private final EnumMap<KeyStateMsg.KeyKind, Boolean> map = new EnumMap(KeyStateMsg.KeyKind.class);
        public static final Capability<IPlayerKeyState> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerKeyState>(){});

        public PlayerKeyState() {
            for (KeyStateMsg.KeyKind k : KeyStateMsg.KeyKind.values()) {
                this.map.put(k, false);
            }
        }

        @Override
        public boolean isDown(KeyStateMsg.KeyKind k) {
            return this.map.getOrDefault((Object)k, false);
        }

        @Override
        public void set(KeyStateMsg.KeyKind k, boolean down) {
            this.map.put(k, down);
        }

        public CompoundTag serializeNBT() {
            CompoundTag t = new CompoundTag();
            for (Map.Entry<KeyStateMsg.KeyKind, Boolean> e : this.map.entrySet()) {
                t.m_128379_(e.getKey().name(), e.getValue().booleanValue());
            }
            return t;
        }

        public void deserializeNBT(CompoundTag nbt) {
            for (KeyStateMsg.KeyKind k : KeyStateMsg.KeyKind.values()) {
                this.map.put(k, nbt.m_128471_(k.name()));
            }
        }
    }

    public static interface IPlayerKeyState
    extends INBTSerializable<CompoundTag> {
        public boolean isDown(KeyStateMsg.KeyKind var1);

        public void set(KeyStateMsg.KeyKind var1, boolean var2);
    }
}

