/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.library.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.dreamtinker.dreamtinker.Dreamtinker;
import org.dreamtinker.dreamtinker.tools.entity.SlashOrbitEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SlashOrbitRenderer
extends EntityRenderer<SlashOrbitEntity> {
    private static final ResourceLocation TEX = Dreamtinker.getLocation("textures/entity/slash_blade.png");
    private static final float DENSITY = 1.35f;
    private static final float MIN_ALPHA = 0.55f;
    private static final int U_SLICES = 48;
    private static final int V_SLICES = 16;
    private static final float R_MID_UV = 0.7f;
    private static final float R_HALF_T_UV = 0.11f;
    private static final float R_IN_UV = 0.59f;
    private static final float R_OUT_UV = 0.81f;
    private static final int MAX_INNER_LAYERS = 7;
    private static final float STEP_OVERLAP = 0.7f;
    private static final float MIN_STEP_WORLD = 0.01f;

    public SlashOrbitRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @NotNull
    public ResourceLocation getTextureLocation(SlashOrbitEntity e) {
        return TEX;
    }

    public void render(SlashOrbitEntity e, float yaw, float pt, PoseStack pose, MultiBufferSource buf, int packed) {
        float step;
        float age = (float)e.f_19797_ + pt;
        float life = Math.max(1.0f, (float)e.life());
        float fade = 1.0f - age / life;
        if (Float.isNaN(fade) || Float.isInfinite(fade)) {
            fade = 1.0f;
        }
        if ((fade = Mth.m_14036_((float)(fade * 1.35f), (float)0.55f, (float)1.0f)) <= 0.0f) {
            return;
        }
        float r = e.radius();
        float th = Math.max(0.02f, e.thickness());
        float phaseDeg = (float)Math.toDegrees(e.omega() * age);
        VertexConsumer vc = buf.m_6299_(RenderType.m_110473_((ResourceLocation)TEX));
        int light = 0xF000F0;
        int ov = OverlayTexture.f_118083_;
        pose.m_85836_();
        pose.m_252781_(Axis.f_252529_.m_252977_(-6.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(phaseDeg));
        float baseScale = r / 0.7f;
        pose.m_85841_(baseScale, 1.0f, baseScale);
        ArrayList<Float> centers = new ArrayList<Float>(7);
        for (float rc = r; rc >= r - th - 1.0E-4f && centers.size() < 7; rc -= step) {
            centers.add(Float.valueOf(rc));
            float layerScaleRatio = Math.max(0.05f, rc / Math.max(0.05f, r));
            float halfWorld = 0.11f * baseScale * layerScaleRatio;
            step = Math.max(0.01f, 0.7f * (2.0f * halfWorld));
        }
        if (centers.isEmpty() || ((Float)centers.get(centers.size() - 1)).floatValue() > r - th + 0.001f) {
            centers.add(Float.valueOf(Math.max(r - th, 0.05f)));
        }
        int colA = e.colorA();
        int colB = e.colorB();
        SlashOrbitEntity.GradMode mode = e.gradMode();
        boolean useHSV = e.useHSV();
        float hueRoll = e.hueShiftSpd() * ((float)e.f_19797_ + pt);
        Iterator iterator = centers.iterator();
        while (iterator.hasNext()) {
            float rCenter = ((Float)iterator.next()).floatValue();
            float layerScaleRatio = Math.max(0.05f, rCenter / 0.7f / baseScale);
            pose.m_85836_();
            pose.m_85841_(layerScaleRatio, 1.0f, layerScaleRatio);
            Matrix4f m = pose.m_85850_().m_252922_();
            Matrix3f n = pose.m_85850_().m_252943_();
            for (int iu = 0; iu < 48; ++iu) {
                float u0 = (float)iu / 48.0f;
                float u1 = (float)(iu + 1) / 48.0f;
                for (int iv = 0; iv < 16; ++iv) {
                    float v0 = (float)iv / 16.0f;
                    float v1 = (float)(iv + 1) / 16.0f;
                    float radial00 = SlashOrbitRenderer.radial01FromUV(u0, v1);
                    float radial10 = SlashOrbitRenderer.radial01FromUV(u1, v1);
                    float radial11 = SlashOrbitRenderer.radial01FromUV(u1, v0);
                    float radial01 = SlashOrbitRenderer.radial01FromUV(u0, v0);
                    int c00 = SlashOrbitRenderer.mix(colA, colB, SlashOrbitRenderer.gradT(mode, u0, radial00, hueRoll), useHSV);
                    int c10 = SlashOrbitRenderer.mix(colA, colB, SlashOrbitRenderer.gradT(mode, u1, radial10, hueRoll), useHSV);
                    int c11 = SlashOrbitRenderer.mix(colA, colB, SlashOrbitRenderer.gradT(mode, u1, radial11, hueRoll), useHSV);
                    int c01 = SlashOrbitRenderer.mix(colA, colB, SlashOrbitRenderer.gradT(mode, u0, radial01, hueRoll), useHSV);
                    float x0 = Mth.m_14179_((float)u0, (float)-1.0f, (float)1.0f);
                    float x1 = Mth.m_14179_((float)u1, (float)-1.0f, (float)1.0f);
                    float z0 = Mth.m_14179_((float)(1.0f - v1), (float)-1.0f, (float)1.0f);
                    float z1 = Mth.m_14179_((float)(1.0f - v0), (float)-1.0f, (float)1.0f);
                    SlashOrbitRenderer.putARGB(vc, m, n, x0, 0.0f, z0, u0, v1, c00, fade, light, ov);
                    SlashOrbitRenderer.putARGB(vc, m, n, x1, 0.0f, z0, u1, v1, c10, fade, light, ov);
                    SlashOrbitRenderer.putARGB(vc, m, n, x1, 0.0f, z1, u1, v0, c11, fade, light, ov);
                    SlashOrbitRenderer.putARGB(vc, m, n, x0, 0.0f, z0, u0, v1, c00, fade, light, ov);
                    SlashOrbitRenderer.putARGB(vc, m, n, x1, 0.0f, z1, u1, v0, c11, fade, light, ov);
                    SlashOrbitRenderer.putARGB(vc, m, n, x0, 0.0f, z1, u0, v0, c01, fade, light, ov);
                }
            }
            pose.m_85849_();
        }
        pose.m_85849_();
    }

    private static void putARGB(VertexConsumer vc, Matrix4f m, Matrix3f n, float x, float y, float z, float u, float v, int argb, float mulA, int light, int ov) {
        float a = (float)(argb >>> 24 & 0xFF) / 255.0f * mulA;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        vc.m_252986_(m, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(ov).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static float radial01FromUV(float u, float v) {
        float du = u - 0.5f;
        float dv = v - 0.5f;
        float rad = Mth.m_14036_((float)((float)Math.sqrt(du * du + dv * dv) / 0.5f), (float)0.0f, (float)1.0f);
        return Mth.m_14036_((float)((rad - 0.59f) / 0.22000003f), (float)0.0f, (float)1.0f);
    }

    private static float gradT(SlashOrbitEntity.GradMode mode, float alongArc01, float radial01, float hueRoll) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case SlashOrbitEntity.GradMode.SOLID -> SlashOrbitRenderer.wrap01(hueRoll);
            case SlashOrbitEntity.GradMode.ANGULAR -> SlashOrbitRenderer.wrap01(alongArc01 + hueRoll);
            case SlashOrbitEntity.GradMode.LENGTH -> SlashOrbitRenderer.wrap01(alongArc01);
            case SlashOrbitEntity.GradMode.RADIAL -> SlashOrbitRenderer.wrap01(radial01 + hueRoll);
            case SlashOrbitEntity.GradMode.TIME_RAINBOW -> SlashOrbitRenderer.wrap01(hueRoll);
        };
    }

    private static float wrap01(float v) {
        if ((v %= 1.0f) < 0.0f) {
            v += 1.0f;
        }
        return v;
    }

    private static int mix(int a, int b, float t, boolean hsv) {
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        return hsv ? SlashOrbitRenderer.lerpHSV_ARGB(a, b, t) : SlashOrbitRenderer.lerpRGB_ARGB(a, b, t);
    }

    private static int lerpRGB_ARGB(int a, int b, float t) {
        int aa = (int)Mth.m_14179_((float)t, (float)(a >>> 24 & 0xFF), (float)(b >>> 24 & 0xFF));
        int rr = (int)Mth.m_14179_((float)t, (float)(a >> 16 & 0xFF), (float)(b >> 16 & 0xFF));
        int gg = (int)Mth.m_14179_((float)t, (float)(a >> 8 & 0xFF), (float)(b >> 8 & 0xFF));
        int bb = (int)Mth.m_14179_((float)t, (float)(a & 0xFF), (float)(b & 0xFF));
        return aa << 24 | rr << 16 | gg << 8 | bb;
    }

    private static int lerpHSV_ARGB(int a, int b, float t) {
        float[] ah = SlashOrbitRenderer.rgbToHsv((float)(a >> 16 & 0xFF) / 255.0f, (float)(a >> 8 & 0xFF) / 255.0f, (float)(a & 0xFF) / 255.0f);
        float[] bh = SlashOrbitRenderer.rgbToHsv((float)(b >> 16 & 0xFF) / 255.0f, (float)(b >> 8 & 0xFF) / 255.0f, (float)(b & 0xFF) / 255.0f);
        float dh = (bh[0] - ah[0] + 1.0f + 0.5f) % 1.0f - 0.5f;
        float h = (ah[0] + dh * t + 1.0f) % 1.0f;
        float s = Mth.m_14179_((float)t, (float)ah[1], (float)bh[1]);
        float v = Mth.m_14179_((float)t, (float)ah[2], (float)bh[2]);
        int rgb = SlashOrbitRenderer.hsvToRgb(h, s, v);
        int aa = (int)Mth.m_14179_((float)t, (float)(a >>> 24 & 0xFF), (float)(b >>> 24 & 0xFF));
        return aa << 24 | rgb;
    }

    private static float[] rgbToHsv(float r, float g, float b) {
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float d = max - min;
        float h = 0.0f;
        if ((double)d > 1.0E-6) {
            h = max == r ? (g - b) / d % 6.0f : (max == g ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        float s = max == 0.0f ? 0.0f : d / max;
        return new float[]{h, s, max};
    }

    private static int hsvToRgb(float h, float s, float v) {
        float G;
        float R;
        float i = (float)Math.floor(h * 6.0f);
        float f = h * 6.0f - i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        return (int)((double)(R * 255.0f) + 0.5) << 16 | (int)((double)(G * 255.0f) + 0.5) << 8 | (int)((double)((switch ((int)i % 6) {
            case 0 -> {
                R = v;
                G = t;
                yield p;
            }
            case 1 -> {
                R = q;
                G = v;
                yield p;
            }
            case 2 -> {
                R = p;
                G = v;
                yield t;
            }
            case 3 -> {
                R = p;
                G = q;
                yield v;
            }
            case 4 -> {
                R = t;
                G = p;
                yield v;
            }
            default -> {
                R = v;
                G = p;
                yield q;
            }
        }) * 255.0f) + 0.5);
    }
}

