/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.dreamtinker.dreamtinker.library.client.PlayerKeyStateProvider;

public record KeyStateMsg(KeyKind kind, boolean down) {
    public static void encode(KeyStateMsg m, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)m.kind);
        buf.writeBoolean(m.down);
    }

    public static KeyStateMsg decode(FriendlyByteBuf buf) {
        return new KeyStateMsg((KeyKind)buf.m_130066_(KeyKind.class), buf.readBoolean());
    }

    public static void handle(KeyStateMsg m, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        if (!c.getDirection().getReceptionSide().isServer()) {
            c.setPacketHandled(true);
            return;
        }
        c.enqueueWork(() -> {
            ServerPlayer sp = c.getSender();
            if (sp == null) {
                return;
            }
            sp.getCapability(PlayerKeyStateProvider.PlayerKeyState.CAP).ifPresent(cap -> cap.set(m.kind(), m.down()));
        });
        c.setPacketHandled(true);
    }

    public static enum KeyKind {
        TOOL_INTERACT,
        MODE;

    }
}

