/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.dreamtinker.dreamtinker.library.client.Overlay.PerfectOverlay;

public record PerfectOverlayMsg(ResourceLocation icon, int durationTicks) {
    public static void encode(PerfectOverlayMsg m, FriendlyByteBuf buf) {
        buf.m_130085_(m.icon);
        buf.m_130130_(m.durationTicks);
    }

    public static PerfectOverlayMsg decode(FriendlyByteBuf buf) {
        return new PerfectOverlayMsg(buf.m_130281_(), buf.m_130242_());
    }

    public static void handle(final PerfectOverlayMsg m, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){

            public void run() {
                ClientOnly.apply(m);
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class ClientOnly {
        private ClientOnly() {
        }

        static void apply(PerfectOverlayMsg m) {
            PerfectOverlay.INSTANCE.trigger(m.icon(), m.durationTicks());
        }
    }
}

