/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.plugin.JEI;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.dreamtinker.dreamtinker.common.DreamtinkerCommon;
import org.dreamtinker.dreamtinker.common.DreamtinkerTagkeys;
import org.dreamtinker.dreamtinker.config.DreamtinkerCachedConfig;
import org.dreamtinker.dreamtinker.library.recipe.virtual.WorldRitualEntry;
import org.dreamtinker.dreamtinker.plugin.JEI.WorldRitualCategory;
import org.dreamtinker.dreamtinker.tools.data.DreamtinkerMaterialIds;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

@JeiPlugin
public final class DTJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return WorldRitualCategory.UID;
    }

    public void registerIngredients(IModIngredientRegistration reg) {
        ArrayList<WorldRitualCategory.CelestialTypes.CelestialIcon> samples = new ArrayList<WorldRitualCategory.CelestialTypes.CelestialIcon>();
        samples.add(WorldRitualCategory.CelestialTypes.CelestialIcon.sun());
        for (int i = 0; i < 8; ++i) {
            samples.add(WorldRitualCategory.CelestialTypes.CelestialIcon.moon(i));
        }
        reg.register(WorldRitualCategory.CelestialTypes.CELESTIAL, samples, (IIngredientHelper)new WorldRitualCategory.CelestialTypes.CelestialHelper(), (IIngredientRenderer)new WorldRitualCategory.CelestialTypes.CelestialRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper g = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new WorldRitualCategory(g)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        ArrayList<WorldRitualEntry> list = new ArrayList<WorldRitualEntry>();
        List<ToolPartItem> headParts = ForgeRegistries.ITEMS.getValues().stream().filter(item -> {
            ToolPartItem part;
            return item instanceof ToolPartItem && (part = (ToolPartItem)item).getStatType() == HeadMaterialStats.ID;
        }).map(item -> (ToolPartItem)item).toList();
        MaterialId mli = MaterialRegistry.getMaterial((MaterialId)DreamtinkerMaterialIds.moonlight_ice.getId()).getIdentifier();
        for (ToolPartItem item2 : headParts) {
            list.add(new WorldRitualEntry(WorldRitualEntry.Trigger.ITEM_IN_FLUID, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42363_}), new FluidStack((Fluid)Fluids.f_76193_, 1000), null, item2.withMaterial((MaterialVariantId)mli), null, null, List.of(Integer.valueOf(0), Integer.valueOf(4)), null, null, null, null, null, null));
        }
        ItemStack hate = new ItemStack((ItemLike)DreamtinkerCommon.soul_cast.get(), 1);
        hate.m_41784_().m_128379_("desire", true);
        list.add(new WorldRitualEntry(WorldRitualEntry.Trigger.KILL_ENTITY, null, null, Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerCommons.soulGlass}), hate, null, EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20497_, EntityType.f_20532_, EntityType.f_20496_, EntityType.f_20509_}), null, true, 320, 6, null, null, null));
        ItemStack love = new ItemStack((ItemLike)DreamtinkerCommon.soul_cast.get(), 1);
        love.m_41784_().m_128379_("love", true);
        list.add(new WorldRitualEntry(WorldRitualEntry.Trigger.BREED_ENTITY, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42402_}), null, null, love, null, EntityIngredient.of((EntityType[])new EntityType[]{EntityType.f_20555_, EntityType.f_20557_, EntityType.f_20504_, EntityType.f_20510_, EntityType.f_20517_, EntityType.f_20520_, EntityType.f_147035_, EntityType.f_20456_, EntityType.f_20507_, EntityType.f_20457_, EntityType.f_20560_, EntityType.f_20452_, EntityType.f_20490_, EntityType.f_20553_, EntityType.f_20499_, EntityType.f_20550_, EntityType.f_147039_}), null, null, null, 6, DreamtinkerCachedConfig.SoulCastLoveLootChance.get(), null, null));
        list.add(new WorldRitualEntry(WorldRitualEntry.Trigger.ITEM_OUT_OF_WORLD, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42584_}), null, null, new ItemStack((ItemLike)DreamtinkerCommon.void_pearl.get()), null, null, null, null, null, null, DreamtinkerCachedConfig.voidPearlDropRate.get(), null, null));
        list.add(new WorldRitualEntry(WorldRitualEntry.Trigger.USE_ITEM_UNDERWATER, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42409_}), null, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_}), new ItemStack((ItemLike)DreamtinkerCommon.memory_cast.get()), null, null, null, null, null, null, null, true, true));
        list.add(new WorldRitualEntry(WorldRitualEntry.Trigger.FORTUNE_LOOTING, null, null, DTJeiPlugin.anyOfBlockTags(Tags.Blocks.ORES_COPPER, Tags.Blocks.ORES_GOLD, DTJeiPlugin.forgeBlockTag("ores/lead"), DTJeiPlugin.forgeBlockTag("ores/silver")), new ItemStack((ItemLike)DreamtinkerCommon.raw_stibnite.get()), null, null, null, null, null, null, DreamtinkerCachedConfig.AntimonyLootChance.get(), false, false));
        list.add(new WorldRitualEntry(WorldRitualEntry.Trigger.FORTUNE_LOOTING, null, null, DTJeiPlugin.anyOfBlockTags(DreamtinkerTagkeys.Blocks.drop_peach), new ItemStack((ItemLike)DreamtinkerCommon.white_peach.get()), null, null, null, null, null, null, DreamtinkerCachedConfig.WhitePeachLootChance.get(), false, false));
        reg.addRecipes(WorldRitualCategory.WORLD_RITUAL, list);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42363_), new RecipeType[]{WorldRitualCategory.WORLD_RITUAL});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42402_), new RecipeType[]{WorldRitualCategory.WORLD_RITUAL});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42584_), new RecipeType[]{WorldRitualCategory.WORLD_RITUAL});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42409_), new RecipeType[]{WorldRitualCategory.WORLD_RITUAL});
    }

    @SafeVarargs
    public static Ingredient anyOfTags(TagKey<Item> ... tags) {
        if (tags == null || tags.length == 0) {
            return Ingredient.f_43901_;
        }
        return Ingredient.merge((Collection)Arrays.stream(tags).filter(Objects::nonNull).map(Ingredient::m_204132_).collect(Collectors.toList()));
    }

    private static TagKey<Item> forgeTag(String name) {
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", name));
    }

    private static TagKey<Block> forgeBlockTag(String name) {
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("forge", name));
    }

    @SafeVarargs
    public static Ingredient anyOfBlockTags(TagKey<Block> ... blockTags) {
        if (blockTags == null || blockTags.length == 0) {
            return Ingredient.f_43901_;
        }
        LinkedHashSet items = new LinkedHashSet();
        for (TagKey<Block> tag : blockTags) {
            if (tag == null) continue;
            Stream<Item> s = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(tag).stream().map(Block::m_5456_).filter(i -> i != Items.f_41852_);
            s.forEach(items::add);
        }
        if (items.isEmpty()) {
            return Ingredient.f_43901_;
        }
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])items.toArray(Item[]::new)));
    }
}

