/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.plugin.JEI;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.dreamtinker.dreamtinker.Dreamtinker;
import org.dreamtinker.dreamtinker.library.recipe.virtual.WorldRitualEntry;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.plugin.jei.MantleJEIConstants;
import slimeknights.mantle.plugin.jei.entity.EntityIngredientRenderer;

public final class WorldRitualCategory
implements IRecipeCategory<WorldRitualEntry> {
    public static final ResourceLocation UID = new ResourceLocation("dreamtinker", "jei");
    public static final RecipeType<WorldRitualEntry> WORLD_RITUAL = RecipeType.create((String)"dreamtinker", (String)"world_ritual", WorldRitualEntry.class);
    private final IDrawable bg;
    private final IDrawable icon;
    private final Component title = Component.m_237115_((String)"jei.dreamtinker.category");
    private final EntityIngredientRenderer entityRenderer = new EntityIngredientRenderer(32);
    private final CelestialTypes.CelestialRenderer celestialRenderer;

    public WorldRitualCategory(IGuiHelper g) {
        this.bg = g.createBlankDrawable(170, 90);
        this.icon = g.createDrawableItemLike((ItemLike)Items.f_42276_);
        this.celestialRenderer = new CelestialTypes.CelestialRenderer();
    }

    @NotNull
    public RecipeType<WorldRitualEntry> getRecipeType() {
        return WORLD_RITUAL;
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder b, WorldRitualEntry r, @NotNull IFocusGroup foci) {
        int x = 8;
        int y = 40;
        if (r.catalyst() != null && !r.catalyst().m_43947_()) {
            b.addSlot(RecipeIngredientRole.CATALYST, x, y).addIngredients(r.catalyst());
            x += 33;
        }
        if (r.fluid() != null && !r.fluid().isEmpty()) {
            ((IRecipeSlotBuilder)b.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(r.fluid()))).setFluidRenderer((long)Math.max(1000, r.fluid().getAmount()), false, 16, 16);
            x += 33;
        }
        ArrayList<CelestialTypes.CelestialIcon> icons = new ArrayList<CelestialTypes.CelestialIcon>();
        if (Boolean.TRUE.equals(r.daytime())) {
            icons.add(CelestialTypes.CelestialIcon.sun());
        }
        if (r.moonPhases() != null && !r.moonPhases().isEmpty()) {
            for (int p : r.moonPhases()) {
                icons.add(CelestialTypes.CelestialIcon.moon(p));
            }
        }
        if (!icons.isEmpty()) {
            b.addSlot(RecipeIngredientRole.RENDER_ONLY, 82, y - 20).setCustomRenderer(CelestialTypes.CELESTIAL, (IIngredientRenderer)this.celestialRenderer).addIngredients(CelestialTypes.CELESTIAL, icons);
        }
        if (r.entityIngredient() != null) {
            IIngredientAcceptor ent = b.addSlot(RecipeIngredientRole.INPUT, x, y - 5).setCustomRenderer(MantleJEIConstants.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredients(MantleJEIConstants.ENTITY_TYPE, r.entityIngredient().getDisplay());
            IIngredientAcceptor eggs = b.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(r.entityIngredient().getEggs());
            b.createFocusLink(new IIngredientAcceptor[]{ent, eggs});
            x += 43;
        }
        if (r.needBlocksAsItems() != null && !r.needBlocksAsItems().m_43947_()) {
            b.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(r.needBlocksAsItems());
            x += 33;
        }
        if (r.resultItem() != null && !r.resultItem().m_41619_()) {
            b.addSlot(RecipeIngredientRole.OUTPUT, 140, y).addItemStack(r.resultItem());
        } else if (r.resultBlockIcon() != null && !r.resultBlockIcon().m_41619_()) {
            b.addSlot(RecipeIngredientRole.OUTPUT, 140, y).addItemStack(r.resultBlockIcon());
        }
    }

    public void draw(WorldRitualEntry recipe, @NotNull IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280614_(font, (Component)Component.m_237115_((String)("jei.dreamtinker.category." + recipe.trigger().name().toLowerCase())), 40, 8, 0xFFFFFF, false);
        int y = 70;
        if (recipe.minY() != null) {
            graphics.m_280056_(font, "Min Y: " + recipe.minY(), 8, y, 0xAAFFAA, false);
            y += 10;
        }
        if (recipe.chance() != null) {
            graphics.m_280614_(font, (Component)Component.m_237115_((String)"jei.dreamtinker.chance").m_130946_(String.format(": %.1f%%", recipe.chance() * 100.0)), 8, y, 43775, false);
            y += 10;
        }
        if (Boolean.TRUE.equals(recipe.drowning())) {
            graphics.m_280056_(font, "Drowning", 8, y, 0xFF6666, false);
        }
    }

    public static final class CelestialTypes {
        public static final IIngredientType<CelestialIcon> CELESTIAL = new IIngredientType<CelestialIcon>(){

            public Class<? extends CelestialIcon> getIngredientClass() {
                return CelestialIcon.class;
            }
        };

        private CelestialTypes() {
        }

        public static final class CelestialHelper
        implements IIngredientHelper<CelestialIcon> {
            private static final String UID_NS = "dreamtinker:celestial";

            public IIngredientType<CelestialIcon> getIngredientType() {
                return null;
            }

            @NotNull
            public String getDisplayName(CelestialIcon ingredient) {
                return ingredient.kind == CelestialIcon.Kind.sun ? Component.m_237115_((String)"jei.dreamtinker.celestial_type.sun").toString() : Component.m_237115_((String)"jei.dreamtinker.celestial_type.moon_phase").toString() + ingredient.phase;
            }

            @NotNull
            public String getUniqueId(@NotNull CelestialIcon celestialIcon, UidContext uidContext) {
                return "dreamtinker:celestial_" + uidContext.toString().toLowerCase();
            }

            @NotNull
            public CelestialIcon copyIngredient(CelestialIcon ingredient) {
                return ingredient.kind == CelestialIcon.Kind.sun ? CelestialIcon.sun() : CelestialIcon.moon(ingredient.phase);
            }

            @NotNull
            public String getErrorInfo(CelestialIcon ingredient) {
                return ingredient == null ? "null celestial icon" : ingredient.toString();
            }

            public ResourceLocation getResourceLocation(CelestialIcon ingredient) {
                return Dreamtinker.getLocation(ingredient.kind.name());
            }

            public String getDisplayModId(CelestialIcon ingredient) {
                return "dreamtinker";
            }

            @NotNull
            public Iterable<Integer> getColors(@NotNull CelestialIcon ingredient) {
                return List.of();
            }

            public boolean isValidIngredient(CelestialIcon ingredient) {
                return true;
            }

            public boolean isIngredientOnServer(CelestialIcon ingredient) {
                return true;
            }
        }

        public static final class CelestialRenderer
        implements IIngredientRenderer<CelestialIcon> {
            private static final ResourceLocation SUN = new ResourceLocation("minecraft", "textures/environment/sun.png");
            private static final ResourceLocation MOON = new ResourceLocation("minecraft", "textures/environment/moon_phases.png");
            private static final int TEX_CELL = 16;
            private static final int CROP = 1;
            private static final int SRC = 14;
            private static final float SCALE = 1.5f;
            private static final int DRAW = Math.round(21.0f);
            private static final int SLOT_W = 24;
            private static final int SLOT_H = 24;

            public void render(GuiGraphics g, CelestialIcon icon) {
                this.render(g, icon, 0, 0);
            }

            public void render(GuiGraphics g, CelestialIcon icon, int x, int y) {
                int dx = x + (24 - DRAW) / 2;
                int dy = y + (24 - DRAW) / 2;
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (icon.kind == CelestialIcon.Kind.sun) {
                    g.m_280163_(SUN, dx, dy, 1.0f, 1.0f, DRAW, DRAW, 16, 16);
                } else {
                    int p = Mth.m_14045_((int)icon.phase, (int)0, (int)7);
                    int u = p % 4 * 16;
                    int v = p / 4 * 16;
                    g.m_280163_(MOON, dx, dy, (float)(u + 1), (float)(v + 1), DRAW, DRAW, 64, 32);
                }
            }

            public List<Component> getTooltip(CelestialIcon celestialIcon, TooltipFlag tooltipFlag) {
                return List.of();
            }

            public void getTooltip(ITooltipBuilder tooltip, CelestialIcon icon, TooltipFlag flag) {
                if (icon.kind == CelestialIcon.Kind.sun) {
                    tooltip.add((FormattedText)Component.m_237115_((String)"jei.dreamtinker.celestial_type.sun"));
                } else {
                    tooltip.add((FormattedText)Component.m_237115_((String)"jei.dreamtinker.celestial_type.moon_phase").m_130946_(String.valueOf(icon.phase)));
                }
            }
        }

        public static final class CelestialIcon {
            public final Kind kind;
            public final int phase;

            private CelestialIcon(Kind k, int p) {
                this.kind = k;
                this.phase = p;
            }

            public static CelestialIcon sun() {
                return new CelestialIcon(Kind.sun, 0);
            }

            public static CelestialIcon moon(int phase) {
                return new CelestialIcon(Kind.moon, phase);
            }

            public String toString() {
                return this.kind == Kind.sun ? "sun" : "moon:" + this.phase;
            }

            public static enum Kind {
                sun,
                moon;

            }
        }
    }
}

