/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dreamtinker.dreamtinker.tools.entity.NarcissusFluidProjectile;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class NarcissusFluidProjectileRenderer<T extends NarcissusFluidProjectile>
extends EntityRenderer<T> {
    private TextureAtlasSprite s0;
    private TextureAtlasSprite s1;

    public NarcissusFluidProjectileRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        this.s0 = atlas.m_118316_(new ResourceLocation("block/soul_fire_0"));
        this.s1 = atlas.m_118316_(new ResourceLocation("block/soul_fire_1"));
    }

    private void ensureSprites() {
        if (this.s0 == null || this.s1 == null) {
            Function getter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
            this.s0 = (TextureAtlasSprite)getter.apply(new ResourceLocation("minecraft", "block/soul_fire_0"));
            this.s1 = (TextureAtlasSprite)getter.apply(new ResourceLocation("minecraft", "block/soul_fire_1"));
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T e) {
        return InventoryMenu.f_39692_;
    }

    public void render(T e, float yaw, float pt, PoseStack pose, MultiBufferSource buf, int light) {
        this.ensureSprites();
        pose.m_85836_();
        float s = 0.9f;
        pose.m_85841_(s, s, s);
        Vec3 d = e.m_20184_();
        if (d.m_82556_() > 1.0E-4) {
            float yRot = (float)(Mth.m_14136_((double)d.f_82481_, (double)d.f_82479_) * 57.29577951308232) - 90.0f;
            pose.m_252781_(Axis.f_252436_.m_252977_(yRot));
        }
        float spin = ((float)((NarcissusFluidProjectile)((Object)e)).f_19797_ + pt) * 6.0f;
        pose.m_252781_(Axis.f_252436_.m_252977_(spin));
        VertexConsumer vc = buf.m_6299_(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_));
        int overlay = OverlayTexture.f_118083_;
        int packed = 0xF000F0;
        this.drawBillboard(pose, vc, this.s0, packed, overlay, 0.55f, 0.75f);
        this.drawBillboard(pose, vc, this.s1, packed, overlay, 0.5f, 0.68f);
        pose.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.drawBillboard(pose, vc, this.s0, packed, overlay, 0.55f, 0.75f);
        this.drawBillboard(pose, vc, this.s1, packed, overlay, 0.5f, 0.68f);
        pose.m_85849_();
    }

    private void drawBillboard(PoseStack pose, VertexConsumer vc, TextureAtlasSprite sp, int light, int overlay, float w, float h) {
        Matrix4f m = pose.m_85850_().m_252922_();
        Matrix3f n = pose.m_85850_().m_252943_();
        float u0 = sp.m_118409_();
        float v0 = sp.m_118411_();
        float u1 = sp.m_118410_();
        float v1 = sp.m_118412_();
        vc.m_252986_(m, -w, -h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(m, w, -h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(m, w, h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(m, -w, h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, 1.0f).m_5752_();
        vc.m_252986_(m, -w, h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v0).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        vc.m_252986_(m, w, h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v0).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        vc.m_252986_(m, w, -h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
        vc.m_252986_(m, -w, -h, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(u0, v1).m_86008_(overlay).m_85969_(light).m_252939_(n, 0.0f, 0.0f, -1.0f).m_5752_();
    }
}

