/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.entity;

import java.util.Comparator;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.dreamtinker.dreamtinker.tools.DreamtinkerModifiers;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public class NarcissusFluidProjectile
extends Projectile {
    private IToolStackView toolStackView;
    private static final EntityDataAccessor<FluidStack> FLUID = SynchedEntityData.m_135353_(NarcissusFluidProjectile.class, (EntityDataSerializer)TinkerFluids.FLUID_DATA_SERIALIZER);
    private static final EntityDataAccessor<Integer> CHASE_LIVING = SynchedEntityData.m_135353_(NarcissusFluidProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float power = 2.0f;
    private int life = 600;
    private int knock_back = 1;

    public NarcissusFluidProjectile(EntityType<? extends NarcissusFluidProjectile> type, Level level) {
        super(type, level);
    }

    public NarcissusFluidProjectile(Level level) {
        this((EntityType<? extends NarcissusFluidProjectile>)((EntityType)DreamtinkerModifiers.NarcissusSpitEntity.get()), level);
    }

    public NarcissusFluidProjectile(Level level, LivingEntity owner, FluidStack fluid, float power, IToolStackView tool) {
        this(level);
        this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
        this.m_5602_((Entity)owner);
        this.setFluid(fluid);
        this.setPower(power);
        this.setTool(tool);
    }

    private FluidEffectContext.Builder buildContext() {
        Level level = this.m_9236_();
        FluidEffectContext.Builder builder = FluidEffectContext.builder((Level)level).projectile((Projectile)this);
        Entity owner = this.m_19749_();
        if (owner != null) {
            builder.user(owner);
        }
        return builder;
    }

    protected boolean m_5603_(@NotNull Entity p_36743_) {
        LivingEntity entity;
        return (this.getChaseLiving() < 1 || p_36743_ instanceof LivingEntity && (entity = (LivingEntity)p_36743_).m_6084_() && !(p_36743_ instanceof ArmorStand)) && (super.m_5603_(p_36743_) || !p_36743_.m_271807_());
    }

    public void m_8119_() {
        List candidates;
        super.m_8119_();
        if (this.m_213877_()) {
            return;
        }
        this.m_37283_();
        Vec3 vel = this.m_20184_();
        if (this.getChaseLiving() > 1 && !this.m_20096_() && !(candidates = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(12.0), t -> t.m_6084_() && t != this.m_19749_() && (this.m_19749_() == null || !t.m_7307_(this.m_19749_())) && !(t instanceof ArmorStand))).isEmpty()) {
            LivingEntity nearest = candidates.stream().min(Comparator.comparingDouble(e -> e.m_20280_((Entity)this))).get();
            Vec3 aim = nearest.m_20182_().m_82520_(0.0, (double)nearest.m_20206_() * 0.5, 0.0).m_82546_(this.m_20182_());
            vel = this.m_20184_().m_82549_(aim.m_82541_()).m_82490_(0.75 * (double)Math.max(1, this.getChaseLiving() - 1));
        }
        Vec3 from = this.m_20182_();
        ResultTOI toi = this.sweepToFirstEntityHit(from, vel);
        boolean impacted = false;
        if (toi.hit != null && toi.hit.m_6662_() != HitResult.Type.MISS) {
            double t2 = Math.max(0.0, Math.min(1.0, toi.t));
            Vec3 hitPos = from.m_82549_(vel.m_82490_(t2));
            this.m_6034_(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_);
            if (!ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)toi.hit)) {
                this.m_6532_((HitResult)toi.hit);
            }
            impacted = true;
        }
        if (!this.m_213877_() && !impacted) {
            Vec3 to = from.m_82549_(vel);
            this.m_6034_(to.f_82479_, to.f_82480_, to.f_82481_);
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.m_213877_()) {
            Vec3 v2 = this.m_20184_();
            if (!impacted) {
                v2 = vel;
            }
            v2 = v2.m_82490_((double)0.99f);
            if (!this.m_20068_()) {
                FluidStack fluid = this.getFluid();
                v2 = v2.m_82520_(0.0, fluid.getFluid().getFluidType().isLighterThanAir() ? 0.06 : -0.06, 0.0);
            }
            this.m_20256_(v2);
            --this.life;
        }
        if (this.m_20186_() > (double)(this.m_9236_().m_151558_() + 64) || this.m_20186_() < (double)(this.m_9236_().m_141937_() - 64) || this.life <= 0) {
            this.m_146870_();
        }
    }

    private ResultTOI sweepToFirstEntityHit(Vec3 from, Vec3 vel) {
        int SAMPLES = 6;
        double inflate = 1.0;
        double EPS = 1.0E-4;
        int MAX_BISECT = 12;
        double tLo = 0.0;
        EntityHitResult hitAt = null;
        for (int i = 1; i <= 6; ++i) {
            double t = (double)i / 6.0;
            Vec3 midFrom = from.m_82549_(vel.m_82490_(tLo));
            Vec3 midTo = from.m_82549_(vel.m_82490_(t));
            Vec3 seg = midTo.m_82546_(midFrom);
            EntityHitResult hr = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)midFrom, (Vec3)midTo, (AABB)this.m_20191_().m_82369_(seg).m_82400_(1.0), this::m_5603_);
            if (hr != null && hr.m_6662_() != HitResult.Type.MISS) {
                double lo = tLo;
                double hi = t;
                EntityHitResult best = hr;
                for (int k = 0; k < 12 && hi - lo > 1.0E-4; ++k) {
                    double midT = (lo + hi) * 0.5;
                    Vec3 a = from.m_82549_(vel.m_82490_(lo));
                    Vec3 b = from.m_82549_(vel.m_82490_(midT));
                    Vec3 d = b.m_82546_(a);
                    EntityHitResult test = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)a, (Vec3)b, (AABB)this.m_20191_().m_82369_(d).m_82400_(1.0), this::m_5603_);
                    if (test != null && test.m_6662_() != HitResult.Type.MISS) {
                        best = test;
                        hi = midT;
                        continue;
                    }
                    lo = midT;
                }
                hitAt = best;
                return new ResultTOI(hitAt, hi);
            }
            tLo = t;
        }
        return new ResultTOI(null, 1.0);
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        Entity entity1;
        Entity target = result.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * (double)this.power), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long j = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if (null != (entity1 = this.m_19749_())) {
            DamageSource damagesource;
            DamageSource damageSource = null != this.toolStackView && 1 < this.toolStackView.getModifierLevel(DreamtinkerModifiers.Ids.icy_memory) ? this.m_269291_().m_269285_(entity1) : (damagesource = null != this.toolStackView && 0 < this.toolStackView.getModifierLevel(DreamtinkerModifiers.Ids.icy_memory) ? this.m_269291_().m_269104_((Entity)this, entity1) : this.m_269291_().m_269299_((Entity)this, (LivingEntity)entity1));
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(target);
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                if (target.m_6469_(damagesource, (float)i)) {
                    if (this.knock_back > 0) {
                        double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                        Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knock_back * 0.6 * d0);
                        if (vec3.m_82556_() > 0.0) {
                            livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                        }
                    }
                    if (!this.m_9236_().f_46443_ && entity1 instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                        EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                    }
                    if (!this.m_9236_().f_46443_ && this.m_6060_()) {
                        target.m_20254_(5 * Math.max(1, this.m_9236_().f_46441_.m_188503_(3)));
                    }
                }
            }
        }
        FluidStack fluid = this.getFluid();
        Level level = this.m_9236_();
        if (!level.f_46443_ && !fluid.isEmpty()) {
            FluidEffects recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid());
            if (null != this.m_19749_() && recipe.hasEntityEffects()) {
                FluidEffectContext.Entity context = this.buildContext().location(result.m_82450_()).target(this.m_19749_());
                int consumed = recipe.applyToEntity(fluid, this.power, context, IFluidHandler.FluidAction.EXECUTE);
                int hate = 1;
                if (null != this.toolStackView) {
                    hate = Math.max(1, this.toolStackView.getModifierLevel(DreamtinkerModifiers.Ids.hate_memory) + 1);
                }
                fluid.shrink(consumed / hate);
                if (fluid.isEmpty()) {
                    this.m_146870_();
                } else {
                    this.setFluid(fluid);
                }
                target.f_19802_ = 0;
                ToolAttackUtil.attackEntity((IToolStackView)this.toolStackView, (LivingEntity)((LivingEntity)this.m_19749_()), (InteractionHand)InteractionHand.MAIN_HAND, (Entity)target, (DoubleSupplier)ToolAttackUtil.NO_COOLDOWN, (boolean)false, (EquipmentSlot)Util.getSlotType((InteractionHand)InteractionHand.MAIN_HAND));
            }
        }
    }

    private boolean isCritArrow() {
        return false;
    }

    protected void m_6532_(HitResult p_37260_) {
        HitResult.Type hitresult$type = p_37260_.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)p_37260_);
            this.m_9236_().m_214171_(GameEvent.f_157777_, p_37260_.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FLUID, (Object)FluidStack.EMPTY);
        this.f_19804_.m_135372_(CHASE_LIVING, (Object)0);
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        double x = packet.m_131503_();
        double y = packet.m_131504_();
        double z = packet.m_131505_();
        for (int i = 0; i < 7; ++i) {
            double offset = 0.4 + 0.1 * (double)i;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20185_(), this.m_20186_() * 0.4 - 1.0, this.m_20189_(), x * offset, y, z * offset);
        }
        this.m_20334_(x, y, z);
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("power", this.power);
        nbt.m_128405_("knock_back", this.knock_back);
        FluidStack fluid = this.getFluid();
        if (!fluid.isEmpty()) {
            nbt.m_128365_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.power = nbt.m_128457_("power");
        this.knock_back = nbt.m_128451_("knock_back");
        this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
    }

    public FluidStack getFluid() {
        return (FluidStack)this.f_19804_.m_135370_(FLUID);
    }

    public int getChaseLiving() {
        return (Integer)this.f_19804_.m_135370_(CHASE_LIVING);
    }

    public void setFluid(FluidStack fluid) {
        this.f_19804_.m_135381_(FLUID, (Object)fluid);
    }

    public void setPower(float power) {
        this.power = power;
    }

    @NotNull
    protected Component m_5677_() {
        return this.getFluid().getDisplayName();
    }

    public void setTool(@NotNull IToolStackView tool) {
        this.toolStackView = tool;
        this.f_19804_.m_135381_(CHASE_LIVING, (Object)tool.getModifierLevel(DreamtinkerModifiers.Ids.soul_core));
    }

    public IToolStackView getTool() {
        return this.toolStackView;
    }

    private record ResultTOI(EntityHitResult hit, double t) {
    }
}

