/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.entity;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.dreamtinker.dreamtinker.tools.DreamtinkerModifiers;
import org.jetbrains.annotations.NotNull;

public class SlashOrbitEntity
extends Entity {
    @Nullable
    private LivingEntity owner;
    public int blades = 6;
    public float bladeHalfAngle = 10.0f;
    public float damage = 0.0f;
    public int hitCooldown = 4;
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> THICKNESS = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE_TICKS = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> OMEGA = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> COL_A = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COL_B = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MODE = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> USE_HSV = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> HUE_SHIFT_SPD = SynchedEntityData.m_135353_(SlashOrbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final Int2IntOpenHashMap lastHitAge = new Int2IntOpenHashMap();

    public SlashOrbitEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.f_19811_ = true;
    }

    public SlashOrbitEntity(ServerLevel s, LivingEntity owner, float radius, int life, float omega, int blades, float damage) {
        this(s, owner, radius, life, omega, blades, damage, 0.0f);
    }

    public SlashOrbitEntity(ServerLevel s, LivingEntity owner, float radius, int life, float omega, int blades, float damage, float thickness) {
        this((EntityType)DreamtinkerModifiers.SLASH_ORBIT.get(), (Level)s);
        this.owner = owner;
        this.setRadius(radius);
        this.setLife(life);
        this.setOmega(omega);
        this.blades = blades;
        this.damage = damage;
        this.setThickness(thickness);
        this.m_6034_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20206_() * 0.5, owner.m_20189_());
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= this.life()) {
            this.m_146870_();
            return;
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.owner != null && this.owner.m_6084_()) {
            this.m_6034_(this.owner.m_20185_(), this.owner.m_20186_() + (double)this.owner.m_20206_() * 0.5, this.owner.m_20189_());
        }
        if (!this.m_9236_().f_46443_ && this.damage > 0.0f) {
            this.doHits();
        }
    }

    private void doHits() {
        double y0 = this.m_20186_() - 0.6;
        double y1 = this.m_20186_() + 0.6;
        AABB box = new AABB(this.m_20185_() - (double)this.radius() - 0.8, y0, this.m_20189_() - (double)this.radius() - 0.8, this.m_20185_() + (double)this.radius() + 0.8, y1, this.m_20189_() + (double)this.radius() + 0.8);
        float phase = this.omega() * (float)this.f_19797_;
        float step = (float)(Math.PI * 2 / (double)this.blades);
        float half = (float)Math.toRadians(this.bladeHalfAngle);
        for (LivingEntity t : this.m_9236_().m_6443_(LivingEntity.class, box, e -> e != this.owner && e.m_6084_() && !e.m_5833_())) {
            int id;
            int last;
            float ang;
            float local;
            float mod;
            float distToBladeCenter;
            double dz;
            double dx = t.m_20185_() - this.m_20185_();
            double d = Math.sqrt(dx * dx + (dz = t.m_20189_() - this.m_20189_()) * dz);
            if (d < (double)this.radius() - 0.5 || d > (double)this.radius() + 0.5 || !((distToBladeCenter = Math.abs(mod = (float)Math.IEEEremainder(local = SlashOrbitEntity.wrapToPi((ang = (float)Math.atan2(dz, dx)) - phase), step))) <= half) || this.f_19797_ - (last = this.lastHitAge.getOrDefault(id = t.m_19879_(), -999)) < this.hitCooldown || !(0.0f < this.damage)) continue;
            t.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, (Entity)this.owner), this.damage);
            this.lastHitAge.put(id, this.f_19797_);
        }
    }

    private static float wrapToPi(float a) {
        while ((double)a < -Math.PI) {
            a += (float)Math.PI * 2;
        }
        while ((double)a > Math.PI) {
            a -= (float)Math.PI * 2;
        }
        return a;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COL_A, (Object)-1);
        this.f_19804_.m_135372_(COL_B, (Object)-1);
        this.f_19804_.m_135372_(MODE, (Object)GradMode.SOLID.ordinal());
        this.f_19804_.m_135372_(USE_HSV, (Object)true);
        this.f_19804_.m_135372_(HUE_SHIFT_SPD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(2.6f));
        this.f_19804_.m_135372_(THICKNESS, (Object)Float.valueOf(0.35f));
        this.f_19804_.m_135372_(LIFE_TICKS, (Object)20);
        this.f_19804_.m_135372_(OMEGA, (Object)Float.valueOf(0.35f));
    }

    public SlashOrbitEntity setSolidColor(int argb) {
        this.f_19804_.m_135381_(COL_A, (Object)argb);
        this.f_19804_.m_135381_(COL_B, (Object)argb);
        this.f_19804_.m_135381_(MODE, (Object)GradMode.SOLID.ordinal());
        return this;
    }

    public SlashOrbitEntity setGradient(int colA, int colB, GradMode m, boolean hsv) {
        this.f_19804_.m_135381_(COL_A, (Object)colA);
        this.f_19804_.m_135381_(COL_B, (Object)colB);
        this.f_19804_.m_135381_(MODE, (Object)m.ordinal());
        this.f_19804_.m_135381_(USE_HSV, (Object)hsv);
        return this;
    }

    public void setHueShift(float speed) {
        this.f_19804_.m_135381_(HUE_SHIFT_SPD, (Object)Float.valueOf(speed));
    }

    protected void m_7378_(@NotNull CompoundTag nbt) {
    }

    protected void m_7380_(@NotNull CompoundTag nbt) {
    }

    public int colorA() {
        return (Integer)this.f_19804_.m_135370_(COL_A);
    }

    public int colorB() {
        return (Integer)this.f_19804_.m_135370_(COL_B);
    }

    public GradMode gradMode() {
        return GradMode.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(MODE)), (int)0, (int)(GradMode.values().length - 1))];
    }

    public boolean useHSV() {
        return (Boolean)this.f_19804_.m_135370_(USE_HSV);
    }

    public float hueShiftSpd() {
        return ((Float)this.f_19804_.m_135370_(HUE_SHIFT_SPD)).floatValue();
    }

    public float radius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public float thickness() {
        return ((Float)this.f_19804_.m_135370_(THICKNESS)).floatValue();
    }

    public int life() {
        return (Integer)this.f_19804_.m_135370_(LIFE_TICKS);
    }

    public float omega() {
        return ((Float)this.f_19804_.m_135370_(OMEGA)).floatValue();
    }

    public void setRadius(float v) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(v));
    }

    public void setThickness(float v) {
        this.f_19804_.m_135381_(THICKNESS, (Object)Float.valueOf(v));
    }

    public void setLife(int t) {
        this.f_19804_.m_135381_(LIFE_TICKS, (Object)t);
    }

    public void setOmega(float v) {
        this.f_19804_.m_135381_(OMEGA, (Object)Float.valueOf(v));
    }

    public static enum GradMode {
        SOLID,
        ANGULAR,
        RADIAL,
        LENGTH,
        TIME_RAINBOW;

    }
}

