/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.items.TNTarrow;

import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.dreamtinker.dreamtinker.config.DreamtinkerCachedConfig;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.tools.DreamtinkerModifiers;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;

public class TNTarrow
extends ModifiableItem {
    public static final ResourceLocation TAG_CONTINUOUS = new ResourceLocation("dreamtinker", "continuous_explode");

    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        int timeAllows = ModifierUtil.getModifierLevel((ItemStack)stack, (ModifierId)DreamtinkerModifiers.Ids.continuous_explode) * (Integer)DreamtinkerConfig.ContinuousExplodeTimes.get();
        int currentTime = ModifierUtil.getPersistentInt((ItemStack)stack, (ResourceLocation)TAG_CONTINUOUS, (int)0);
        if (currentTime < timeAllows) {
            tooltip.add((Component)Component.m_237115_((String)"modifier.dreamtinker.tooltip.continuous_explode").m_130946_(String.valueOf(timeAllows - currentTime)).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    public TNTarrow(Item.Properties properties, ToolDefinition toolDefinition, int maxStackSize) {
        super(properties, toolDefinition, maxStackSize);
    }

    @NotNull
    public AbstractArrow createArrow(Level world, ItemStack stack, LivingEntity shooter) {
        return new TNTArrowEntity(world, shooter, stack);
    }

    public static class TNTArrowEntity
    extends AbstractArrow
    implements IEntityAdditionalSpawnData {
        public ItemStack tntarrow = ItemStack.f_41583_;
        private static final EntityDataAccessor<ItemStack> DATA_TOOL = SynchedEntityData.m_135353_(TNTArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

        public TNTArrowEntity(EntityType<? extends AbstractArrow> type, Level world) {
            super(type, world);
        }

        public TNTArrowEntity(Level world, LivingEntity shooter, ItemStack stack) {
            super((EntityType)DreamtinkerModifiers.TNTARROW.get(), shooter, world);
            this.tntarrow = stack;
            this.setToolStack(stack.m_41777_());
        }

        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(DATA_TOOL, (Object)ItemStack.f_41583_);
        }

        public void setToolStack(ItemStack stack) {
            this.f_19804_.m_135381_(DATA_TOOL, (Object)stack.m_41777_());
        }

        public ItemStack getToolStackSynced() {
            return (ItemStack)this.f_19804_.m_135370_(DATA_TOOL);
        }

        public void m_7380_(CompoundTag tag) {
            super.m_7380_(tag);
            ItemStack s = this.getToolStackSynced();
            if (!s.m_41619_()) {
                tag.m_128365_("Tool", (Tag)s.m_41739_(new CompoundTag()));
            }
        }

        public void m_7378_(CompoundTag tag) {
            super.m_7378_(tag);
            if (tag.m_128441_("Tool")) {
                this.setToolStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Tool")));
            }
        }

        public void writeSpawnData(FriendlyByteBuf buf) {
            buf.m_130055_(this.getToolStackSynced());
        }

        public void readSpawnData(FriendlyByteBuf buf) {
            this.setToolStack(buf.m_130267_());
        }

        public @NotNull Packet<ClientGamePacketListener> m_5654_() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void hitEntity(Entity entity) {
            if (null == this.m_19749_() || !(this.m_19749_() instanceof LivingEntity) || null == entity) {
                return;
            }
            entity.m_20331_(false);
            entity.f_19802_ = 0;
            if (entity.m_20148_() != this.m_19749_().m_20148_()) {
                ToolAttackUtil.attackEntity((IToolStackView)ToolStack.from((ItemStack)this.tntarrow), (LivingEntity)((LivingEntity)this.m_19749_()), (InteractionHand)InteractionHand.OFF_HAND, (Entity)entity, (DoubleSupplier)ToolAttackUtil.NO_COOLDOWN, (boolean)false, (EquipmentSlot)Util.getSlotType((InteractionHand)InteractionHand.OFF_HAND));
            } else {
                try {
                    ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                    FakePlayer fakeAttacker = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
                    ToolAttackUtil.attackEntity((IToolStackView)ToolStack.from((ItemStack)this.tntarrow), (LivingEntity)fakeAttacker, (InteractionHand)InteractionHand.MAIN_HAND, (Entity)entity, (DoubleSupplier)ToolAttackUtil.NO_COOLDOWN, (boolean)false, (EquipmentSlot)Util.getSlotType((InteractionHand)InteractionHand.OFF_HAND));
                }
                catch (SecurityException e) {
                    ToolAttackUtil.attackEntity((IToolStackView)ToolStack.from((ItemStack)this.tntarrow), (LivingEntity)((LivingEntity)this.m_19749_()), (InteractionHand)InteractionHand.MAIN_HAND, (Entity)entity, (DoubleSupplier)ToolAttackUtil.NO_COOLDOWN, (boolean)false, (EquipmentSlot)Util.getSlotType((InteractionHand)InteractionHand.OFF_HAND));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void m_6532_(@NotNull HitResult result) {
            super.m_6532_(result);
            if (!this.m_9236_().f_46443_) {
                float sound = 2.0f;
                Vec3 hitPos = result.m_82450_();
                int hitRadius = DreamtinkerCachedConfig.TNT_ARROW_RADIUS.get();
                List nearbyEntities = this.m_9236_().m_45933_(null, new AABB(hitPos.m_82492_((double)hitRadius, (double)hitRadius, (double)hitRadius), hitPos.m_82520_((double)hitRadius, (double)hitRadius, (double)hitRadius)));
                for (Entity entity : nearbyEntities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    this.hitEntity((Entity)livingEntity);
                    sound += 1.0f;
                }
                if (this.m_19749_() != null && this.m_19749_().m_20182_().m_82554_(hitPos) <= (double)hitRadius) {
                    this.hitEntity(this.m_19749_());
                    sound += 1.0f;
                }
                this.m_5496_(SoundEvents.f_11913_, sound, (1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f) * 0.7f);
                int timeAllows = ModifierUtil.getModifierLevel((ItemStack)this.tntarrow, (ModifierId)DreamtinkerModifiers.Ids.continuous_explode) * (Integer)DreamtinkerConfig.ContinuousExplodeTimes.get();
                int currentTime = ModifierUtil.getPersistentInt((ItemStack)this.tntarrow, (ResourceLocation)TAG_CONTINUOUS, (int)0);
                if (currentTime < timeAllows) {
                    ToolStack ts = ToolStack.from((ItemStack)this.tntarrow);
                    ts.getPersistentData().putInt(TAG_CONTINUOUS, ++currentTime);
                    ts.updateStack(this.tntarrow);
                } else {
                    this.m_146870_();
                }
            }
        }

        @NotNull
        protected ItemStack m_7941_() {
            return this.tntarrow;
        }

        public void m_8119_() {
            super.m_8119_();
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)DreamtinkerCachedConfig.TNT_ARROW_GRAVITY.get().intValue(), 0.0));
            }
        }
    }
}

