/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.events;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="dreamtinker")
public final class AdvCountEvents {
    private AdvCountEvents() {
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent e) {
        AdvCountService.rebuildForServer(e.getServer());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent e) {
        MinecraftServer server;
        MinecraftServer minecraftServer = server = e.getPlayer() == null ? e.getPlayerList().m_7873_() : e.getPlayer().m_20194_();
        if (server != null) {
            AdvCountService.rebuildForServer(server);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            AdvCountService.DONE_BY_PLAYER.remove(sp.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onAdvEarn(AdvancementEvent.AdvancementEarnEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Advancement adv = e.getAdvancement();
            AdvCountService.onPlayerEarned(sp, adv);
        }
    }

    public static final class AdvCountService {
        public static boolean ONLY_DISPLAY = true;
        public static String NAMESPACE_FILTER = null;
        private static volatile List<Advancement> COUNTED_LIST = List.of();
        private static volatile Set<Advancement> COUNTED_SET = Set.of();
        private static final AtomicInteger TOTAL = new AtomicInteger(0);
        private static final Map<UUID, AtomicInteger> DONE_BY_PLAYER = new ConcurrentHashMap<UUID, AtomicInteger>();

        private AdvCountService() {
        }

        public static Counts getCounts(ServerPlayer sp) {
            AtomicInteger done = DONE_BY_PLAYER.computeIfAbsent(sp.m_20148_(), id -> new AtomicInteger(AdvCountService.initDoneFor(sp)));
            return new Counts(done.get(), TOTAL.get());
        }

        public static void rebuildForServer(MinecraftServer server) {
            List<Advancement> all = server.m_129889_().m_136028_().stream().filter(adv -> !ONLY_DISPLAY || adv.m_138320_() != null).filter(adv -> NAMESPACE_FILTER == null || adv.m_138327_().m_135827_().equals(NAMESPACE_FILTER)).toList();
            COUNTED_LIST = List.copyOf(all);
            COUNTED_SET = Set.copyOf(all);
            TOTAL.set(COUNTED_LIST.size());
            DONE_BY_PLAYER.clear();
        }

        private static int initDoneFor(ServerPlayer sp) {
            int done = 0;
            for (Advancement adv : COUNTED_LIST) {
                AdvancementProgress p = sp.m_8960_().m_135996_(adv);
                if (!p.m_8193_()) continue;
                ++done;
            }
            return done;
        }

        public static void warmup(ServerPlayer sp) {
            DONE_BY_PLAYER.computeIfAbsent(sp.m_20148_(), id -> new AtomicInteger(AdvCountService.initDoneFor(sp)));
        }

        public static void onPlayerEarned(ServerPlayer sp, Advancement adv) {
            if (!COUNTED_SET.isEmpty() && COUNTED_SET.contains(adv)) {
                DONE_BY_PLAYER.computeIfAbsent(sp.m_20148_(), id -> new AtomicInteger(AdvCountService.initDoneFor(sp))).incrementAndGet();
            }
        }

        public record Counts(int done, int total) {
        }
    }
}

