/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.events;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.dreamtinker.dreamtinker.common.DreamtinkerEffects;
import org.dreamtinker.dreamtinker.config.DreamtinkerCachedConfig;
import org.dreamtinker.dreamtinker.utils.LootEntryInspector;

@Mod.EventBusSubscriber(modid="dreamtinker")
public class SilverNameBeeDrop {
    @SubscribeEvent
    public static void onSilverNameBeeDrops(LivingDropsEvent event) {
        LivingEntity livingAttacker;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        Level level = entity2.m_9236_();
        DamageSource source = event.getSource();
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity attacker = source.m_7639_();
        if (attacker == null && (entity = source.m_7640_()) instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            attacker = projectile.m_19749_();
        }
        if (!(attacker instanceof LivingEntity) || !(livingAttacker = (LivingEntity)attacker).m_21023_((MobEffect)DreamtinkerEffects.SilverNameBee.get())) {
            return;
        }
        LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)entity2).m_287286_(LootContextParams.f_81460_, (Object)entity2.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)event.getSource()).m_287289_(LootContextParams.f_81458_, (Object)attacker).m_287289_(LootContextParams.f_81459_, (Object)event.getSource().m_7640_()).m_287289_(LootContextParams.f_81456_, (Object)(attacker instanceof ServerPlayer ? (ServerPlayer)attacker : null));
        ItemStack originalTool = livingAttacker.m_21205_();
        ItemStack lootingTool = originalTool.m_41777_();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)lootingTool);
        enchantments.put(Enchantments.f_44982_, 1000);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)lootingTool);
        builder.m_287289_(LootContextParams.f_81463_, (Object)lootingTool);
        MinecraftServer server = serverLevel.m_7654_();
        LootParams params = builder.m_287235_(LootContextParamSets.f_81415_);
        ResourceLocation tableId = entity2.m_5743_();
        LootTable table = server.m_278653_().m_278676_(tableId);
        try {
            SilverNameBeeDrop.rollRareEntries(table, entity2, params, serverLevel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void rollRareEntries(LootTable table, LivingEntity entity, LootParams params, ServerLevel level) {
        RandomSource rng = level.m_213780_();
        ArrayList<LootPoolEntryContainer> rareEntries = new ArrayList<LootPoolEntryContainer>();
        List<LootPool> pools = LootEntryInspector.get(table, "pools");
        if (pools != null) {
            for (LootPool pool : pools) {
                List<LootPoolEntryContainer> entries = LootEntryInspector.get(pool, "entries");
                if (entries == null) continue;
                for (LootPoolEntryContainer entry : entries) {
                    if (!SilverNameBeeDrop.isRare(entry)) continue;
                    rareEntries.add(entry);
                }
            }
        }
        if (!rareEntries.isEmpty()) {
            LootPoolEntryContainer chosen = (LootPoolEntryContainer)rareEntries.get(rng.m_188503_(rareEntries.size()));
            entity.m_19983_(LootEntryInspector.getItemStack(chosen));
        } else {
            Map.Entry smallestEntry;
            HashMap<Item, Integer> totals = new HashMap<Item, Integer>();
            for (int i = 0; i < 100; ++i) {
                ObjectArrayList round = table.m_287195_(params);
                for (ItemStack stack : round) {
                    if (stack.m_41619_() || stack.m_41720_() == Items.f_41852_) continue;
                    totals.merge(stack.m_41720_(), stack.m_41613_(), Integer::sum);
                }
            }
            if (!totals.isEmpty() && (smallestEntry = (Map.Entry)totals.entrySet().stream().min(Map.Entry.comparingByValue()).orElse(null)) != null) {
                ItemStack smallest = new ItemStack((ItemLike)smallestEntry.getKey(), DreamtinkerCachedConfig.SilverNameBeeNum.get().intValue());
                entity.m_19983_(smallest);
            }
        }
    }

    private static boolean isRare(LootPoolEntryContainer entry) {
        LootItemCondition[] conditions = LootEntryInspector.getConditions(entry);
        if (conditions != null) {
            for (LootItemCondition c : conditions) {
                if (c == null || !LootEntryInspector.isLowChanceCondition(c) && !LootEntryInspector.matchRareKeys(c)) continue;
                return true;
            }
        }
        return LootEntryInspector.hasRareFunctionCondition(entry) || LootEntryInspector.rarityfromitem(entry);
    }
}

