/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.Combat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.BattleModifier;
import org.dreamtinker.dreamtinker.utils.MaskService;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RomanNumeralHelper;

public class mei
extends BattleModifier {
    private final String mei_key_2 = "modifier.dreamtinker.mei_2";
    private final String mei_key_3 = "modifier.dreamtinker.mei_3";
    private final int max_level_second = (Integer)DreamtinkerConfig.RedTime.get();
    private static final ResourceLocation TAG_MLT = new ResourceLocation("dreamtinker", "mei_level_time");
    private static final ResourceLocation TAG_MLL = new ResourceLocation("dreamtinker", "mei_level");
    private final String tool_attribute_uuid = "1cbcb2dd-4df1-4fcf-a072-301ab051378d";
    private final String player_attribute_uuid = "548eef8b-d4db-44cc-9854-0063e4d2affb";

    @Override
    @NotNull
    public Component getDisplayName(int level) {
        if (level <= 9) {
            return ModifierLevelDisplay.DEFAULT.nameForLevel((Modifier)this, level);
        }
        if (level < 50) {
            return ModifierLevelDisplay.DEFAULT.nameForLevel((Modifier)this, 9);
        }
        if (level <= 100) {
            return Component.m_237115_((String)this.getTranslationKey()).m_130946_(" ").m_7220_(RomanNumeralHelper.getNumeral((int)9)).m_130938_(style -> style.m_131148_(ResourceColorManager.getTextColor((String)"modifier.dreamtinker.mei_2")));
        }
        if (level <= 130) {
            return Component.m_237115_((String)this.getTranslationKey()).m_130938_(style -> style.m_131148_(ResourceColorManager.getTextColor((String)"modifier.dreamtinker.mei_2")));
        }
        return Component.m_237115_((String)"modifier.dreamtinker.mei_3").m_130938_(style -> style.m_131148_(ResourceColorManager.getTextColor((String)"modifier.dreamtinker.mei_3")));
    }

    @NotNull
    public List<Component> getDescriptionList(int level) {
        if (level < 130) {
            return this.getDescriptionList();
        }
        if (level <= 150) {
            return Arrays.asList(Component.m_237115_((String)"modifier.dreamtinker.mei_2.flavor").m_130940_(ChatFormatting.ITALIC), Component.m_237115_((String)"modifier.dreamtinker.mei_2.description").m_130940_(ChatFormatting.GRAY));
        }
        return Arrays.asList(Component.m_237115_((String)"modifier.dreamtinker.mei_3.flavor").m_130940_(ChatFormatting.ITALIC), Component.m_237115_((String)"modifier.dreamtinker.mei_3.description").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public Component onModifierRemoved(IToolStackView tool, Modifier modifier) {
        if (modifier.getId().equals((Object)this.getId())) {
            return this.refuseRemoveMessage(tool);
        }
        return null;
    }

    @Override
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        if (modifier.getId().equals((Object)this.getId()) && modifier.getLevel() < tool.getPersistentData().getInt(TAG_MLL)) {
            return this.refuseRemoveMessage(tool);
        }
        return null;
    }

    private Component refuseRemoveMessage(IToolStackView tool) {
        int level = tool.getModifierLevel((Modifier)this);
        if (level < 100) {
            return Component.m_237115_((String)(this.getTranslationKey() + ".salvage"));
        }
        if (level < 130) {
            return Component.m_237115_((String)"modifier.dreamtinker.mei_2.salvage").m_130938_(style -> style.m_131148_(ResourceColorManager.getTextColor((String)"modifier.dreamtinker.mei_2")));
        }
        return Component.m_237115_((String)"modifier.dreamtinker.mei_3.salvage").m_130938_(style -> style.m_131148_(ResourceColorManager.getTextColor((String)"modifier.dreamtinker.mei_3")));
    }

    @Override
    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        int level = context.getModifierLevel((Modifier)this);
        ToolStats.ATTACK_DAMAGE.add(builder, (double)level * 1.3);
        ToolStats.ATTACK_SPEED.add(builder, (double)level * 0.3);
    }

    @Override
    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        if (tool.isBroken() || slot != EquipmentSlot.MAINHAND) {
            return;
        }
        int level = modifier.getLevel();
        double mod = 200 <= level ? Math.pow(level - 200, 2.0) / 100.0 + 4.2 : (100 <= level ? 4.0 * (double)(level - 100) / 100.0 + 0.2 : 0.2 * (double)level / 100.0);
        consumer.accept(Attributes.f_22281_, new AttributeModifier(UUID.fromString("1cbcb2dd-4df1-4fcf-a072-301ab051378d"), Attributes.f_22281_.m_22087_(), mod, AttributeModifier.Operation.MULTIPLY_BASE));
        consumer.accept(Attributes.f_22283_, new AttributeModifier(UUID.fromString("1cbcb2dd-4df1-4fcf-a072-301ab051378d"), Attributes.f_22283_.m_22087_(), mod, AttributeModifier.Operation.MULTIPLY_BASE));
        if (100 <= level) {
            consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("1cbcb2dd-4df1-4fcf-a072-301ab051378d"), Attributes.f_22284_.m_22087_(), mod, AttributeModifier.Operation.MULTIPLY_BASE));
            consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("1cbcb2dd-4df1-4fcf-a072-301ab051378d"), Attributes.f_22285_.m_22087_(), mod, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (130 <= level) {
            consumer.accept(Attributes.f_22279_, new AttributeModifier(UUID.fromString("1cbcb2dd-4df1-4fcf-a072-301ab051378d"), Attributes.f_22279_.m_22087_(), 2.0 * (double)(level - 100) / 100.0 + 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    @Override
    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (world.m_46467_() % 20L == 0L) {
            int level = tool.getModifierLevel((Modifier)this);
            ModDataNBT toolData = tool.getPersistentData();
            int last_second = toolData.getInt(TAG_MLT);
            int cur_exp_cap = (int)Math.ceil(Math.max(1.0, (double)this.max_level_second / Math.max(1.0, (double)level / 100.0)));
            if (cur_exp_cap <= last_second + 1) {
                ToolStack ts = ToolStack.from((ItemStack)stack);
                ts.addModifier(this.getId(), 1);
                ts.getPersistentData().putInt(TAG_MLT, last_second + 1 - cur_exp_cap);
                ts.getPersistentData().putInt(TAG_MLL, level + 1);
                ts.updateStack(stack);
            } else {
                toolData.putInt(TAG_MLT, last_second + 1);
                if (tool.getPersistentData().getInt(TAG_MLL) < level) {
                    tool.getPersistentData().putInt(TAG_MLL, level);
                }
            }
            if (holder instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)holder;
                ArrayList<Attribute> attributes = new ArrayList<Attribute>(Arrays.asList(Attributes.f_22281_, Attributes.f_22283_));
                double mod = 100 <= level ? -2.0 * (double)(level - 100) / 100.0 - 0.1 : -0.1 * (double)level / 100.0;
                if (100 <= level) {
                    attributes.addAll(Arrays.asList(Attributes.f_22284_, Attributes.f_22285_));
                }
                if (130 <= level) {
                    attributes.add(Attributes.f_22279_);
                }
                for (Attribute attr : attributes) {
                    AttributeModifier cur;
                    AttributeInstance attr_instance = player.m_21051_(attr);
                    if (null == attr_instance || (cur = attr_instance.m_22111_(UUID.fromString("548eef8b-d4db-44cc-9854-0063e4d2affb"))) != null && !(mod < cur.m_22218_())) continue;
                    attr_instance.m_22120_(UUID.fromString("548eef8b-d4db-44cc-9854-0063e4d2affb"));
                    attr_instance.m_22125_(new AttributeModifier(UUID.fromString("548eef8b-d4db-44cc-9854-0063e4d2affb"), attr.m_22087_(), mod, AttributeModifier.Operation.MULTIPLY_BASE));
                }
                if (250 <= level) {
                    MaskService.ensureOn(player, -599967174, -1);
                } else if (200 <= level) {
                    MaskService.ensureOn(player, -1400233444, -1);
                }
            }
        }
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity attacker = context.getAttacker();
        LivingEntity target = context.getLivingTarget();
        if (attacker.m_9236_().f_46443_ || null == target) {
            return knockback;
        }
        int level = tool.getModifierLevel(this.getId());
        if (150 <= level) {
            DamageSource dam = new DamageSource((Holder)attacker.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_286979_), (Entity)attacker, (Entity)attacker);
            target.m_6469_(dam, 200 <= level ? 2.1474836E9f : damage);
        }
        return knockback;
    }

    @Override
    public float onGetMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        if (170 <= tool.getModifierLevel(this.getId())) {
            return 2.1474836E9f;
        }
        return damage;
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }
}

