/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.Combat;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.BattleModifier;
import org.dreamtinker.dreamtinker.utils.DTModiferCheck;
import org.dreamtinker.dreamtinker.utils.DThelper;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class open_soul
extends BattleModifier {
    private static final ResourceLocation TAG_SOUL = new ResourceLocation("dreamtinker", "open_soul");

    public open_soul() {
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDeath);
    }

    @Override
    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (!isSelected && !isCorrectSlot) {
            return;
        }
        ModDataNBT nbt = tool.getPersistentData();
        if (tool.isBroken() && (Double)DreamtinkerConfig.OpenSoulRepairCount.get() <= (double)nbt.getFloat(TAG_SOUL)) {
            nbt.putFloat(TAG_SOUL, (float)((double)nbt.getFloat(TAG_SOUL) - (Double)DreamtinkerConfig.OpenSoulRepairCount.get()));
            tool.setDamage(0);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (!context.getAttacker().m_9236_().f_46443_) {
            ModDataNBT nbt = tool.getPersistentData();
            nbt.putFloat(TAG_SOUL, nbt.getFloat(TAG_SOUL) + damageDealt);
        }
    }

    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        ToolStack tool = DTModiferCheck.getToolWithModifier(entity, this.getId());
        if (null != tool) {
            ToolDataNBT tooldata = tool.getPersistentData();
            float count = tooldata.getFloat(TAG_SOUL);
            if ((Double)DreamtinkerConfig.OpenSoulDeathCount.get() <= (double)count) {
                tooldata.putFloat(TAG_SOUL, (float)((double)count - (Double)DreamtinkerConfig.OpenSoulDeathCount.get()));
                event.setCanceled(true);
                entity.f_20919_ = -10;
                entity.m_21153_(1.0f);
                entity.f_19802_ = 1000;
                entity.m_7911_(entity.m_6103_() + entity.m_21233_() * 0.5f);
            }
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, @NotNull ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ModDataNBT nbt;
        if (tool instanceof ToolStack && tooltipKey.isShiftOrUnknown() && (nbt = tool.getPersistentData()).contains(TAG_SOUL, 5)) {
            float count = nbt.getFloat(TAG_SOUL);
            tooltip.add((Component)Component.m_237115_((String)"modifier.dreamtinker.tooltip.open_soul").m_130946_(String.valueOf(count)).m_130948_(this.getDisplayName().m_7383_()));
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        ItemStack item;
        if (null != attacker && null != (item = DThelper.findItemByModifierNBT(attacker, modifiers, false))) {
            double d;
            double d2 = projectile.m_20184_().m_82553_();
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                d = arrow.m_36789_();
            } else {
                d = 1.0;
            }
            float data = (float)(d2 * d);
            ToolStack ts = ToolStack.from((ItemStack)item);
            ToolDataNBT nbt = ts.getPersistentData();
            nbt.putFloat(TAG_SOUL, (float)((double)nbt.getFloat(TAG_SOUL) + (double)data * (Double)DreamtinkerConfig.OpenSoulRangedGet.get()));
        }
        return false;
    }
}

