/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.Compact.enigmaticLegacy;

import com.aizistral.enigmaticlegacy.effects.GrowingBloodlustEffect;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.items.EldritchPan;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.BattleModifier;
import org.dreamtinker.dreamtinker.tools.DreamtinkerModifiers;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class eldritch_pan
extends BattleModifier {
    public static final ResourceLocation BLOODLUST_ID = new ResourceLocation("enigmaticlegacy", "growing_bloodlust");
    public static final ResourceLocation HUNGER_ID = new ResourceLocation("enigmaticlegacy", "growing_hunger");
    public static final ResourceLocation TAG_PAN = new ResourceLocation("dreamtinker", "eldritch_pan");
    private static final ResourceLocation TAG_PAN_TICKS = new ResourceLocation("dreamtinker", "eldritch_tick");

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void addTraits(IToolContext var1, ModifierEntry var2, ModifierTraitHook.TraitBuilder var3, boolean var4) {
        if (var4 && 1 == var2.getLevel() && var1.getModifierLevel(DreamtinkerModifiers.cursed_ring_bound.getId()) < 20) {
            var3.add(DreamtinkerModifiers.cursed_ring_bound.getId(), 20);
        }
    }

    public static MobEffect getBloodlust() {
        if (!ModList.get().isLoaded("enigmaticlegacy")) {
            return null;
        }
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(BLOODLUST_ID);
    }

    public static MobEffect getHunger() {
        if (!ModList.get().isLoaded("enigmaticlegacy")) {
            return null;
        }
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(HUNGER_ID);
    }

    @Override
    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (holder instanceof Player) {
            Player player = (Player)holder;
            if (isSelected) {
                int currentTicks = tool.getPersistentData().getInt(TAG_PAN_TICKS);
                if (SuperpositionHandler.cannotHunger((Player)player)) {
                    int bloodlustAmplifier = currentTicks / GrowingBloodlustEffect.ticksPerLevel.getValue();
                    bloodlustAmplifier = Math.min(bloodlustAmplifier, 9);
                    if (null != eldritch_pan.getBloodlust()) {
                        player.m_7292_(new MobEffectInstance(eldritch_pan.getBloodlust(), -1, bloodlustAmplifier, true, true));
                    }
                } else {
                    int hungerAmplifier = currentTicks / GrowingBloodlustEffect.ticksPerLevel.getValue();
                    hungerAmplifier = Math.min(hungerAmplifier, 9);
                    if (null != eldritch_pan.getHunger()) {
                        player.m_7292_(new MobEffectInstance(eldritch_pan.getHunger(), -1, hungerAmplifier, true, true));
                    }
                }
                EldritchPan.HOLDING_DURATIONS.put(player, ++currentTicks);
                tool.getPersistentData().putInt(TAG_PAN_TICKS, ++currentTicks);
            } else {
                tool.getPersistentData().putInt(TAG_PAN_TICKS, 0);
                if (null != eldritch_pan.getHunger()) {
                    player.m_21195_(eldritch_pan.getHunger());
                }
                if (null != eldritch_pan.getBloodlust()) {
                    player.m_21195_(eldritch_pan.getBloodlust());
                }
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity livingEntity = context.getAttacker();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && SuperpositionHandler.isTheWorthyOne((Player)player)) {
                float lifesteal = (float)((double)damageDealt * EldritchPan.lifeSteal.getValue());
                if (null != eldritch_pan.getBloodlust() && player.m_21023_(eldritch_pan.getBloodlust())) {
                    int amplifier = 1 + player.m_21124_(eldritch_pan.getBloodlust()).m_19564_();
                    lifesteal += (float)((double)damageDealt * (GrowingBloodlustEffect.lifestealBoost.getValue() * (double)amplifier));
                }
                player.m_5634_(lifesteal);
                float hungersteal = (float)EldritchPan.hungerSteal.getValue();
                boolean noHunger = SuperpositionHandler.cannotHunger((Player)player);
                Entity entity = context.getTarget();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer victim = (ServerPlayer)entity;
                    FoodData victimFood = victim.m_36324_();
                    FoodData attackerFood = player.m_36324_();
                    int foodSteal = Math.min((int)Math.ceil(hungersteal), victimFood.m_38702_());
                    float saturationSteal = Math.min(hungersteal / 5.0f, victimFood.m_38722_());
                    victimFood.m_38717_(victimFood.m_38722_() - saturationSteal);
                    victimFood.m_38705_(victimFood.m_38702_() - foodSteal);
                    if (noHunger) {
                        player.m_5634_((float)foodSteal / 2.0f);
                    } else {
                        attackerFood.m_38707_(foodSteal, saturationSteal);
                    }
                } else if (noHunger) {
                    player.m_5634_(hungersteal / 2.0f);
                } else {
                    player.m_36324_().m_38707_((int)Math.ceil(hungersteal), hungersteal / 5.0f);
                }
            }
        }
    }

    @Override
    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        ModDataNBT nbt;
        int kills;
        if (!tool.isBroken() && modifier.getLevel() > 0 && EquipmentSlot.MAINHAND == slot && (kills = (nbt = tool.getPersistentData()).getInt(TAG_PAN)) > 0) {
            String tool_attribute_uuid = "50c030b6-e8ef-4a99-9a6a-9c231b2365a8";
            consumer.accept(Attributes.f_22281_, new AttributeModifier(UUID.fromString(tool_attribute_uuid), Attributes.f_22281_.m_22087_(), EldritchPan.uniqueDamageGain.getValue() * (double)kills, AttributeModifier.Operation.ADDITION));
            consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString(tool_attribute_uuid), Attributes.f_22282_.m_22087_(), EldritchPan.uniqueArmorGain.getValue() * (double)kills, AttributeModifier.Operation.ADDITION));
        }
    }
}

