/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.Compact.malum;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.item.curiosities.armor.MalignantStrongholdArmorItem;
import com.sammy.malum.common.item.curiosities.armor.SoulHunterArmorItem;
import com.sammy.malum.common.item.curiosities.armor.SoulStainedSteelArmorItem;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class malum_attributes
extends Modifier
implements AttributesModifierHook,
ToolStatsModifierHook {
    private final int tier;
    private final SoulHunterArmorItem soulHunterArmorItem = (SoulHunterArmorItem)ItemRegistry.SOUL_HUNTER_CLOAK.get();
    private final SoulStainedSteelArmorItem soulStainedSteelArmorItem = (SoulStainedSteelArmorItem)ItemRegistry.SOUL_STAINED_STEEL_LEGGINGS.get();
    private final MalignantStrongholdArmorItem malignantStrongholdArmorItem = (MalignantStrongholdArmorItem)ItemRegistry.MALIGNANT_STRONGHOLD_BOOTS.get();

    public malum_attributes(int tier) {
        this.tier = tier;
    }

    protected void registerHooks(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.ATTRIBUTES, ModifierHooks.TOOL_STATS);
        super.registerHooks(hookBuilder);
    }

    public void addAttributes(IToolStackView iToolStackView, ModifierEntry modifierEntry, EquipmentSlot equipmentSlot, BiConsumer<Attribute, AttributeModifier> biConsumer) {
        ArmorItem.Type type = malum_attributes.armorTypeFromSlot(equipmentSlot);
        if (null != type) {
            for (Map.Entry e : this.createExtraAttributes(type).entries()) {
                Attribute attr = (Attribute)e.getKey();
                AttributeModifier mod = (AttributeModifier)e.getValue();
                AttributeModifier scaled = new AttributeModifier(mod.m_22209_(), mod.m_22214_(), mod.m_22218_() * (double)modifierEntry.getLevel(), mod.m_22217_());
                biConsumer.accept(attr, scaled);
            }
        }
    }

    private Multimap<Attribute, AttributeModifier> createExtraAttributes(ArmorItem.Type type) {
        switch (this.tier) {
            case 2: {
                return this.soulStainedSteelArmorItem.createExtraAttributes(type);
            }
            case 3: {
                return this.malignantStrongholdArmorItem.createExtraAttributes(type);
            }
        }
        return this.soulHunterArmorItem.createExtraAttributes(type);
    }

    @Nullable
    public static ArmorItem.Type armorTypeFromSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> ArmorItem.Type.HELMET;
            case EquipmentSlot.CHEST -> ArmorItem.Type.CHESTPLATE;
            case EquipmentSlot.LEGS -> ArmorItem.Type.LEGGINGS;
            case EquipmentSlot.FEET -> ArmorItem.Type.BOOTS;
            default -> null;
        };
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        ToolStats.ARMOR.add(modifierStatsBuilder, -0.1 * (double)((Float)modifierStatsBuilder.getStat((IToolStat)ToolStats.ARMOR)).floatValue() * (double)(modifierEntry.getLevel() - 1));
    }
}

