/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.material.echo_shard;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.dreamtinker.dreamtinker.config.DreamtinkerCachedConfig;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.BattleModifier;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.Util;

public class echoed_attack
extends BattleModifier {
    private static final ResourceLocation TAG_ECHO_ENERGY = new ResourceLocation("dreamtinker", "echo_energy");
    private static final int E_C = DreamtinkerCachedConfig.EchoAttackCharge.get();
    private static final double ChargingChance = DreamtinkerCachedConfig.EchoAttackChargingChance.get();

    @Override
    public Component onModifierRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(TAG_ECHO_ENERGY);
        return null;
    }

    @Override
    public void addTooltip(IToolStackView tool, @NotNull ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ModDataNBT nbt;
        if (tooltipKey.isShiftOrUnknown() && (nbt = tool.getPersistentData()).contains(TAG_ECHO_ENERGY, 3)) {
            int count = nbt.getInt(TAG_ECHO_ENERGY);
            tooltip.add((Component)Component.m_237115_((String)"modifier.dreamtinker.tooltip.echo_energy").m_130946_(String.valueOf(count)).m_130948_(this.getDisplayName().m_7383_()));
        }
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, @NotNull ModifierEntry modifier, @NotNull ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        ModDataNBT nbt = tool.getPersistentData();
        int count = nbt.getInt(TAG_ECHO_ENERGY);
        if (E_C <= count) {
            echoed_attack.performSonicBoomSweep(tool, (ServerLevel)context.getAttacker().m_9236_(), context.getAttacker());
            nbt.putInt(TAG_ECHO_ENERGY, count -= E_C);
        }
        return knockback;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (!(shooter.m_9236_() instanceof ServerLevel)) {
            return;
        }
        ModDataNBT nbt = tool.getPersistentData();
        int count = nbt.getInt(TAG_ECHO_ENERGY) + 1;
        if (projectile instanceof AbstractArrow && null != arrow && Math.random() < ChargingChance) {
            ((AbstractArrow)projectile).m_36781_(((AbstractArrow)projectile).m_36789_() * 1.5);
            ++count;
        }
        if (E_C <= count) {
            nbt.putInt(TAG_ECHO_ENERGY, count -= E_C);
            echoed_attack.performSonicBoomSweep(tool, (ServerLevel)shooter.m_9236_(), shooter);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.hitEntity(tool, context.getAttacker(), context.getLivingTarget(), context);
    }

    public int getPriority() {
        return 10;
    }

    private void hitEntity(IToolStackView tool, LivingEntity attacker, LivingEntity target, ToolAttackContext context) {
        int echo_energy = 1;
        if (null != target && Math.random() < ChargingChance) {
            this.shortCutDamage(tool, context);
            for (LivingEntity entity : new LivingEntity[]{attacker, target}) {
                if (entity == null) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 60));
            }
            ++echo_energy;
        }
        ModDataNBT nbt = tool.getPersistentData();
        int count = nbt.getInt(TAG_ECHO_ENERGY);
        nbt.putInt(TAG_ECHO_ENERGY, count + echo_energy);
    }

    private void shortCutDamage(IToolStackView tool, ToolAttackContext context) {
        float damage;
        float baseDamage = damage = ToolAttackUtil.getAttributeAttackDamage((IToolStackView)tool, (LivingEntity)context.getAttacker(), (EquipmentSlot)Util.getSlotType((InteractionHand)context.getHand()));
        List modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            damage = ((MeleeDamageModifierHook)entry.getHook(ModifierHooks.MELEE_DAMAGE)).getMeleeDamage(tool, entry, context, baseDamage, damage);
        }
        if (null != context.getLivingTarget()) {
            DamageSource dam;
            context.getLivingTarget().m_20331_(false);
            context.getLivingTarget().f_19802_ = 9;
            LivingEntity livingEntity = context.getAttacker();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                dam = context.getLivingTarget().m_9236_().m_269111_().m_269075_(player);
            } else {
                dam = context.getLivingTarget().m_9236_().m_269111_().m_269333_(context.getAttacker());
            }
            context.getLivingTarget().m_6469_(dam, damage);
        }
    }

    public static void performSonicBoomSweep(IToolStackView tool, ServerLevel level, LivingEntity attacker) {
        if (level.f_46443_) {
            return;
        }
        List modifiers = tool.getModifierList();
        Arrow arrow = new Arrow((Level)level, attacker);
        ModDataNBT persistentData = ModDataNBT.readFromNBT((CompoundTag)arrow.getPersistentData());
        ModDataNBT nbt = tool.getPersistentData();
        int count = nbt.getInt(TAG_ECHO_ENERGY);
        for (ModifierEntry entry : modifiers) {
            ((ProjectileLaunchModifierHook)entry.getHook(ModifierHooks.PROJECTILE_LAUNCH)).onProjectileLaunch(tool, entry, attacker, (Projectile)arrow, (AbstractArrow)arrow, persistentData, true);
        }
        float damage = (float)(arrow.m_20184_().m_82553_() * arrow.m_36789_());
        nbt.putInt(TAG_ECHO_ENERGY, count);
        Vec3 start = attacker.m_20182_().m_82520_(0.0, (double)attacker.m_20192_(), 0.0);
        Vec3 direction = attacker.m_20154_();
        double maxDistance = 20.0;
        HashSet<LivingEntity> hitEntities = new HashSet<LivingEntity>();
        int i = 1;
        while ((double)i <= maxDistance) {
            Vec3 pos = start.m_82549_(direction.m_82490_((double)i));
            level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            List entities = level.m_6443_(LivingEntity.class, new AABB(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5, pos.f_82479_ + 0.5, pos.f_82480_ + 0.5, pos.f_82481_ + 0.5), e -> e != attacker && e.m_6084_() && attacker.m_6779_(e));
            for (LivingEntity target : entities) {
                if (hitEntities.contains(target)) continue;
                hitEntities.add(target);
                target.m_6469_(target.m_9236_().m_269111_().m_269285_((Entity)attacker), damage);
                double resist = target.m_21133_(Attributes.f_22278_);
                double knockY = 0.5 * (1.0 - resist);
                double knockXZ = 2.5 * (1.0 - resist);
                target.m_5997_(direction.f_82479_ * knockXZ, direction.f_82480_ * knockY, direction.f_82481_ * knockXZ);
            }
            ++i;
        }
        attacker.m_9236_().m_5594_(null, attacker.m_20097_(), SoundEvents.f_215771_, SoundSource.NEUTRAL, 3.0f, 1.0f);
    }
}

