/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.material.lupus_antimony;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.BattleModifier;
import org.dreamtinker.dreamtinker.tools.data.DreamtinkerMaterialIds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class the_wolf_was
extends BattleModifier {
    private static final ResourceLocation TAG_WOLF = new ResourceLocation("dreamtinker", "twwc");

    @Override
    public int modifierDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        if (!((Boolean)DreamtinkerConfig.TheWolfWasEnable.get()).booleanValue()) {
            return amount;
        }
        if (holder == null) {
            return amount;
        }
        ModDataNBT nbt = tool.getPersistentData();
        int count = nbt.getInt(TAG_WOLF);
        nbt.putInt(TAG_WOLF, count + amount);
        return amount;
    }

    @Override
    public void addTooltip(IToolStackView tool, @NotNull ModifierEntry modifier, @javax.annotation.Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ModDataNBT nbt;
        int count;
        if (tool instanceof ToolStack && tooltipKey.isShiftOrUnknown() && (count = (nbt = tool.getPersistentData()).getInt(TAG_WOLF)) > 0) {
            tooltip.add((Component)Component.m_237115_((String)"modifier.dreamtinker.tooltip.the_wolf_was").m_130946_(String.valueOf(count)).m_130946_(" / " + DreamtinkerConfig.TheWolfWasDamage.get()).m_130948_(this.getDisplayName().m_7383_()));
        }
    }

    @Override
    public Component onModifierRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(TAG_WOLF);
        return null;
    }

    @Override
    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!(tool instanceof ToolStack)) {
            return;
        }
        ToolStack toolstack = (ToolStack)tool;
        if (holder == null) {
            return;
        }
        if (stack.m_41619_()) {
            return;
        }
        ToolDataNBT nbt = toolstack.getPersistentData();
        int count = nbt.getInt(TAG_WOLF);
        if (count < (Integer)DreamtinkerConfig.TheWolfWasDamage.get()) {
            return;
        }
        MaterialNBT mats = tool.getMaterials();
        int slots = mats.size();
        if (slots == 0) {
            return;
        }
        ArrayList<Integer> eligibleSlots = new ArrayList<Integer>();
        boolean keep1lupus = false;
        for (int i = 0; i < slots; ++i) {
            MaterialVariant originalId = mats.get(i);
            IMaterial origMat = MaterialRegistry.getInstance().getMaterial(originalId.getId());
            if (DreamtinkerMaterialIds.metallivorous_stibium_lupus.matches(origMat) && !keep1lupus) {
                keep1lupus = true;
                continue;
            }
            if (origMat.getTier() > (Integer)DreamtinkerConfig.TheWolfWasMaxTier.get()) continue;
            eligibleSlots.add(i);
        }
        if (eligibleSlots.isEmpty()) {
            return;
        }
        RandomSource rand = holder.m_217043_();
        int slot = (Integer)eligibleSlots.get(rand.m_188503_(eligibleSlots.size()));
        ToolMaterialHook materialsHook = (ToolMaterialHook)tool.getDefinition().getHook(ToolHooks.TOOL_MATERIALS);
        List statList = materialsHook.getStatTypes(tool.getDefinition());
        MaterialStatsId statsId = (MaterialStatsId)statList.get(slot);
        MaterialVariant original = mats.get(slot);
        IMaterial mat = MaterialRegistry.getMaterial((MaterialId)original.getId());
        int tier = mat.getTier();
        int possible_tier = Math.min(Math.min(tier + 1, (Integer)DreamtinkerConfig.TheWolfWasMaxTier.get()), 4);
        List candidates = MaterialRegistry.getInstance().getAllMaterials().stream().filter(m -> possible_tier <= m.getTier()).map(IMaterial::getIdentifier).filter(arg_0 -> ((MaterialStatsId)statsId).canUseMaterial(arg_0)).filter(id -> !id.equals((Object)mat.getIdentifier())).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            return;
        }
        MaterialVariantId choice = (MaterialVariantId)candidates.get(rand.m_188503_(candidates.size()));
        nbt.putInt(TAG_WOLF, count - (Integer)DreamtinkerConfig.TheWolfWasDamage.get());
        MaterialNBT newMats = mats.replaceMaterial(slot, choice);
        toolstack.setMaterials(newMats);
        toolstack.updateStack(stack);
    }
}

