/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.material.lupus_antimony;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.BattleModifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class the_wolf_wonder
extends BattleModifier {
    private static final int minDuration = (Integer)DreamtinkerConfig.TheWolfWonderEffectMinTime.get() * 20;
    private static final int maxDuration = (Integer)DreamtinkerConfig.TheWolfWonderEffectMaxTime.get() * 20;
    private static final Set<ResourceLocation> BAD_CACHE = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CONFIG_BLACKLIST = new HashSet<ResourceLocation>();
    private boolean Blacklist_inited = false;
    private static final Set<MobEffect> BrewAble = ForgeRegistries.POTIONS.getValues().stream().flatMap(p -> p.m_43488_().stream()).map(MobEffectInstance::m_19544_).collect(Collectors.toUnmodifiableSet());

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity target = context.getLivingTarget();
        if (target == null) {
            return knockback;
        }
        this.applyRandomEffects(target, context.getAttacker());
        return knockback;
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        this.applyRandomEffects(target, attacker);
        return false;
    }

    private void applyRandomEffects(LivingEntity target, LivingEntity attacker) {
        RandomSource rand = target.m_217043_();
        List negatives = ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(this::filterMobEffects).collect(Collectors.toList());
        if (negatives.isEmpty()) {
            return;
        }
        for (int i = negatives.size() - 1; i > 0; --i) {
            int j = rand.m_188503_(i + 1);
            Collections.swap(negatives, i, j);
        }
        ArrayList<MobEffectInstance> selected_effects = new ArrayList<MobEffectInstance>();
        for (MobEffect effect : negatives) {
            if ((Integer)DreamtinkerConfig.TheWolfWonderEffectNum.get() <= selected_effects.size()) break;
            int duration = minDuration + rand.m_188503_(Math.max(1, maxDuration - minDuration + 1));
            int amplifier = rand.m_188503_(((Integer)DreamtinkerConfig.TheWolfWonderEffectAmplifier.get()).intValue());
            try {
                MobEffectInstance inst = new MobEffectInstance(effect, duration, amplifier, false, true);
                target.m_147215_(inst, (Entity)target);
                selected_effects.add(inst);
            }
            catch (Throwable t) {
                BAD_CACHE.add(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect));
                LogUtils.getLogger().warn("Random harmful effect {} failed on {} ({}). Blacklisting for this session.", new Object[]{ForgeRegistries.MOB_EFFECTS.getKey((Object)effect), target.m_6095_(), target.m_9236_().m_46472_().m_135782_(), t});
            }
        }
        if (attacker != null && rand.m_188503_(6666) < (Integer)DreamtinkerConfig.TheWolfWonderSurpriseNumber.get()) {
            for (MobEffectInstance inst : selected_effects) {
                attacker.m_7292_(new MobEffectInstance(inst.m_19544_(), inst.m_19557_(), inst.m_19564_(), inst.m_19571_(), inst.m_19572_()));
            }
        }
    }

    public static void loadConfigBlacklist(List<? extends String> ids) {
        CONFIG_BLACKLIST.clear();
        for (String string : ids) {
            try {
                CONFIG_BLACKLIST.add(new ResourceLocation(string));
            }
            catch (Exception exception) {}
        }
    }

    private boolean filterMobEffects(MobEffect effect) {
        if (!this.Blacklist_inited) {
            this.Blacklist_inited = true;
            the_wolf_wonder.loadConfigBlacklist((List)DreamtinkerConfig.TheWolfBlackList.get());
        }
        if (effect.m_19483_() != MobEffectCategory.HARMFUL) {
            return false;
        }
        if (((Boolean)DreamtinkerConfig.TheWolfWonderPotionEffectOnly.get()).booleanValue() && !the_wolf_wonder.isPotionEffectCached(effect)) {
            return false;
        }
        ResourceLocation key = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
        return null != key && !BAD_CACHE.contains(key) && !CONFIG_BLACKLIST.contains(key) && !key.m_135815_().contains("test") && !key.m_135815_().contains("ceshi");
    }

    public static boolean isPotionEffectCached(MobEffect effect) {
        return BrewAble.contains(effect);
    }
}

