/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.material.nigrescence_antimony;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.ArmorModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class broken_vessel
extends ArmorModifier {
    private static final String TAG_BASE_HEALTH = "broken_vessel";
    private static final UUID HEALTH_BOOST_ID = UUID.fromString("c8b28a17-d5ec-4fa4-b555-bb1e8f7de4c8");
    private static final int MAX_HEALTH_MULTIPLIER = (Integer)DreamtinkerConfig.BrokenVesselBoost.get();

    public broken_vessel() {
        MinecraftForge.EVENT_BUS.addListener(this::LivingHealEvent);
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (context.getChangedSlot() == EquipmentSlot.MAINHAND || context.getChangedSlot() == EquipmentSlot.OFFHAND) {
            return;
        }
        LivingEntity entity = context.getEntity();
        AttributeInstance attr = entity.m_21051_(Attributes.f_22276_);
        if (attr == null) {
            return;
        }
        CompoundTag data = entity.getPersistentData();
        if (!data.m_128441_(TAG_BASE_HEALTH)) {
            data.m_128350_(TAG_BASE_HEALTH, (float)attr.m_22115_());
            attr.m_22120_(HEALTH_BOOST_ID);
            attr.m_22125_(new AttributeModifier(HEALTH_BOOST_ID, TAG_BASE_HEALTH, attr.m_22115_() * (double)MAX_HEALTH_MULTIPLIER, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        if (this.hasOtherPiece(entity)) {
            return;
        }
        AttributeInstance attr = entity.m_21051_(Attributes.f_22276_);
        if (attr == null) {
            return;
        }
        CompoundTag data = entity.getPersistentData();
        if (!data.m_128441_(TAG_BASE_HEALTH)) {
            return;
        }
        if (attr.m_22111_(HEALTH_BOOST_ID) != null) {
            attr.m_22120_(HEALTH_BOOST_ID);
        }
        float original = data.m_128457_(TAG_BASE_HEALTH);
        attr.m_22100_((double)original);
        data.m_128473_(TAG_BASE_HEALTH);
        if (entity.m_21223_() > entity.m_21233_()) {
            entity.m_21153_(entity.m_21233_());
        }
    }

    private boolean hasOtherPiece(LivingEntity entity) {
        for (ItemStack stack : entity.m_6168_()) {
            ToolStack tool;
            if (stack.m_41720_().equals(Items.f_41852_) || (tool = ToolStack.from((ItemStack)stack)).getModifierLevel((Modifier)this) <= 0) continue;
            return true;
        }
        return false;
    }

    private void LivingHealEvent(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        CompoundTag data = entity.getPersistentData();
        if (!data.m_128441_(TAG_BASE_HEALTH)) {
            return;
        }
        float baseHealth = data.m_128457_(TAG_BASE_HEALTH);
        float cap = baseHealth / (float)(1 + MAX_HEALTH_MULTIPLIER);
        float current = entity.m_21223_();
        float heal = event.getAmount();
        if (cap <= current) {
            event.setAmount(0.0f);
            entity.m_21153_(cap);
        } else if (cap < current + heal) {
            event.setAmount(cap - current);
            entity.m_21153_(cap);
        }
        float currentAbs = entity.m_6103_();
        if (currentAbs < cap) {
            float toAbsorb = Math.min(cap - currentAbs, heal);
            entity.m_7911_(currentAbs + toAbsorb);
        }
    }
}

