/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.tools.modifiers.traits.material.nigrescence_antimony;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.library.modifiers.base.baseclass.BattleModifier;
import org.dreamtinker.dreamtinker.utils.DThelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class burning_in_vain
extends BattleModifier {
    Double maxInaccuracy = (Double)DreamtinkerConfig.BurnInVainInAccuracy.get();
    private static final List<EntityType<? extends Projectile>> PROJECTILE_TYPES = new ArrayList<EntityType<? extends Projectile>>();

    @Override
    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        float current_damage = ((Float)builder.getStat((IToolStat)ToolStats.PROJECTILE_DAMAGE)).floatValue();
        float current_speed = ((Float)builder.getStat((IToolStat)ToolStats.VELOCITY)).floatValue();
        float current_accuracy = ((Float)builder.getStat((IToolStat)ToolStats.ACCURACY)).floatValue();
        float max = Math.max(Math.max(current_accuracy, current_damage), current_speed);
        ToolStats.PROJECTILE_DAMAGE.add(builder, (double)(max - current_damage));
        ToolStats.VELOCITY.add(builder, (double)(max - current_speed));
        ToolStats.ACCURACY.add(builder, (double)(max - current_accuracy));
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (shooter.m_9236_().f_46443_) {
            return;
        }
        ServerLevel world = (ServerLevel)shooter.m_9236_();
        double px = shooter.m_20185_();
        double pz = shooter.m_20189_();
        DThelper.clearProjectile(world, px, pz);
        if (!((Boolean)DreamtinkerConfig.BurnInVainRandomProj.get()).booleanValue()) {
            return;
        }
        Vec3 motion = projectile.m_20184_();
        Projectile newProj = this.createRandomProjectile(world, shooter, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), motion);
        if (newProj != null) {
            world.m_7967_((Entity)newProj);
        }
    }

    @Override
    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (!isCorrectSlot && !isSelected) {
            return;
        }
        holder.m_20254_(20);
    }

    private Projectile createRandomProjectile(ServerLevel level, LivingEntity shooter, double px, double py, double pz, Vec3 motion) {
        if (PROJECTILE_TYPES.isEmpty()) {
            for (EntityType type : ForgeRegistries.ENTITY_TYPES.getValues()) {
                try {
                    Entity test = type.m_20615_((Level)level);
                    if (!(test instanceof Projectile)) continue;
                    PROJECTILE_TYPES.add((EntityType<? extends Projectile>)type);
                }
                catch (Exception test) {}
            }
        }
        if (PROJECTILE_TYPES.isEmpty()) {
            return null;
        }
        EntityType<? extends Projectile> chosenType = PROJECTILE_TYPES.get(level.m_213780_().m_188503_(PROJECTILE_TYPES.size()));
        Projectile newProj = (Projectile)chosenType.m_20615_((Level)level);
        if (newProj == null) {
            return null;
        }
        newProj.m_5602_((Entity)shooter);
        newProj.m_6034_(px, py, pz);
        float speed = (float)Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82480_ * motion.f_82480_ + motion.f_82481_ * motion.f_82481_);
        float inaccuracy = (float)((double)level.f_46441_.m_188501_() * this.maxInaccuracy);
        newProj.m_6686_(motion.f_82479_, motion.f_82480_, motion.f_82481_, speed, inaccuracy);
        if (newProj instanceof AbstractArrow) {
            ((AbstractArrow)newProj).f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        }
        if (newProj instanceof WitherSkull) {
            ((WitherSkull)newProj).m_37629_((double)level.f_46441_.m_188501_() < 0.15);
        }
        return newProj;
    }
}

