/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;

public final class CastLookup {
    public static final String SUFFIX_CAST = "_cast";
    public static final String SUFFIX_SAND = "_sand_cast";
    public static final String SUFFIX_RED_SAND = "_red_sand_cast";

    public static CastTriple findCastsForPart(ToolPartItem part) {
        ResourceLocation pid = ForgeRegistries.ITEMS.getKey((Object)part);
        if (pid == null) {
            return new CastTriple(null, null, null);
        }
        String baseName = pid.m_135815_();
        Item cast = CastLookup.getItem(new ResourceLocation("tconstruct", baseName + SUFFIX_CAST));
        Item sandCast = CastLookup.getItem(new ResourceLocation("tconstruct", baseName + SUFFIX_SAND));
        Item redCast = CastLookup.getItem(new ResourceLocation("tconstruct", baseName + SUFFIX_RED_SAND));
        if (cast == null) {
            cast = CastLookup.getItem(new ResourceLocation(pid.m_135827_(), baseName + SUFFIX_CAST));
        }
        if (sandCast == null) {
            sandCast = CastLookup.getItem(new ResourceLocation(pid.m_135827_(), baseName + SUFFIX_SAND));
        }
        if (redCast == null) {
            redCast = CastLookup.getItem(new ResourceLocation(pid.m_135827_(), baseName + SUFFIX_RED_SAND));
        }
        if (cast == null || sandCast == null || redCast == null) {
            for (Item it : ForgeRegistries.ITEMS.getValues()) {
                ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)it);
                if (id == null) continue;
                String p = id.m_135815_();
                if (cast == null && p.equals(baseName + SUFFIX_CAST)) {
                    cast = it;
                }
                if (sandCast == null && p.equals(baseName + SUFFIX_SAND)) {
                    sandCast = it;
                }
                if (redCast != null || !p.equals(baseName + SUFFIX_RED_SAND)) continue;
                redCast = it;
            }
        }
        return new CastTriple(cast, sandCast, redCast);
    }

    public static Map<ToolPartItem, CastTriple> findCastsForParts(List<ToolPartItem> parts) {
        LinkedHashMap<ToolPartItem, CastTriple> out = new LinkedHashMap<ToolPartItem, CastTriple>();
        for (ToolPartItem part : parts) {
            out.put(part, CastLookup.findCastsForPart(part));
        }
        return out;
    }

    private static Item getItem(ResourceLocation id) {
        return (Item)ForgeRegistries.ITEMS.getValue(id);
    }

    public static List<ItemStack> makeCastStacks(CastTriple triple) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>(3);
        if (triple.cast() != null) {
            out.add(new ItemStack((ItemLike)triple.cast()));
        }
        if (triple.sandCast() != null) {
            out.add(new ItemStack((ItemLike)triple.sandCast()));
        }
        if (triple.redSandCast() != null) {
            out.add(new ItemStack((ItemLike)triple.redSandCast()));
        }
        return out;
    }

    public record CastTriple(@Nullable Item cast, @Nullable Item sandCast, @Nullable Item redSandCast) {
        public List<Item> asListPresent() {
            ArrayList<Item> out = new ArrayList<Item>(3);
            if (this.cast != null) {
                out.add(this.cast);
            }
            if (this.sandCast != null) {
                out.add(this.sandCast);
            }
            if (this.redSandCast != null) {
                out.add(this.redSandCast);
            }
            return out;
        }
    }
}

