/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.utils;

import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class DTModiferCheck {
    public static final EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD, EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND};

    public static int getModifierlevel(LivingEntity entity, ModifierId id, EquipmentSlot slot) {
        if (entity != null) {
            if (!entity.m_6844_(slot).m_204117_(TinkerTags.Items.MODIFIABLE)) {
                return 0;
            }
            ToolStack toolStack = ToolStack.from((ItemStack)entity.m_6844_(slot));
            if (!toolStack.isBroken()) {
                return ModifierUtil.getModifierLevel((ItemStack)entity.m_6844_(slot), (ModifierId)id);
            }
        }
        return 0;
    }

    public static int getMainhandModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return DTModiferCheck.getModifierlevel(entity, modifierId, EquipmentSlot.MAINHAND);
    }

    public static int getOffhandModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return DTModiferCheck.getModifierlevel(entity, modifierId, EquipmentSlot.OFFHAND);
    }

    public static boolean ModifierInHand(LivingEntity entity, ModifierId modifierId) {
        return 0 < DTModiferCheck.getMainhandModifierlevel(entity, modifierId) || 0 < DTModiferCheck.getOffhandModifierlevel(entity, modifierId);
    }

    public static int getHeadModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return DTModiferCheck.getModifierlevel(entity, modifierId, EquipmentSlot.HEAD);
    }

    public static int getChestModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return DTModiferCheck.getModifierlevel(entity, modifierId, EquipmentSlot.CHEST);
    }

    public static int getLegModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return DTModiferCheck.getModifierlevel(entity, modifierId, EquipmentSlot.LEGS);
    }

    public static int getFeetModifierlevel(LivingEntity entity, ModifierId modifierId) {
        return DTModiferCheck.getModifierlevel(entity, modifierId, EquipmentSlot.FEET);
    }

    public static boolean ModifierInBody(LivingEntity entity, ModifierId modifierId) {
        return 0 < DTModiferCheck.getHeadModifierlevel(entity, modifierId) || 0 < DTModiferCheck.getChestModifierlevel(entity, modifierId) || 0 < DTModiferCheck.getLegModifierlevel(entity, modifierId) || 0 < DTModiferCheck.getFeetModifierlevel(entity, modifierId);
    }

    public static boolean ModifierALLBody(LivingEntity entity, ModifierId modifierId) {
        return 0 < DTModiferCheck.getHeadModifierlevel(entity, modifierId) && 0 < DTModiferCheck.getChestModifierlevel(entity, modifierId) && 0 < DTModiferCheck.getLegModifierlevel(entity, modifierId) && 0 < DTModiferCheck.getFeetModifierlevel(entity, modifierId);
    }

    public static boolean haveModifierIn(LivingEntity entity, ModifierId modifierId) {
        return DTModiferCheck.ModifierInBody(entity, modifierId) || DTModiferCheck.ModifierInHand(entity, modifierId);
    }

    @Nullable
    public static ToolStack getToolWithModifier(LivingEntity entity, ModifierId modifierId) {
        for (EquipmentSlot slot : slots) {
            if (0 >= DTModiferCheck.getModifierlevel(entity, modifierId, slot)) continue;
            return ToolStack.from((ItemStack)entity.m_6844_(slot));
        }
        return null;
    }

    public static int getItemModifierNum(ItemStack stack, TagKey<Modifier> tag) {
        int matched = 0;
        if (null != stack && !stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            for (ModifierEntry modifier : toolStack.getModifiers()) {
                matched += modifier.getModifier().is(tag) ? 1 : 0;
            }
        }
        return matched;
    }

    public static int getItemModifierNum(ItemStack stack, ModifierId id) {
        int matched = 0;
        if (null != stack && !stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            ToolStack toolStack = ToolStack.from((ItemStack)stack);
            matched += toolStack.getModifier(id).getLevel();
        }
        return matched;
    }

    public static int getEntityModifierNum(LivingEntity entity, ModifierId id) {
        int matched = 0;
        matched += DTModiferCheck.getHeadModifierlevel(entity, id);
        matched += DTModiferCheck.getChestModifierlevel(entity, id);
        matched += DTModiferCheck.getLegModifierlevel(entity, id);
        matched += DTModiferCheck.getFeetModifierlevel(entity, id);
        matched += DTModiferCheck.getMainhandModifierlevel(entity, id);
        return matched += DTModiferCheck.getOffhandModifierlevel(entity, id);
    }
}

