/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.utils;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;

public class DThelper {
    public static void clearProjectile(ServerLevel level, double px, double pz) {
        int viewDist = level.m_7654_().m_6846_().m_11312_();
        double radius = (double)viewDist * 16.0;
        AABB box = new AABB(px - radius, (double)level.m_141937_(), pz - radius, px + radius, (double)level.m_151558_(), pz + radius);
        Predicate<Projectile> all = p -> true;
        List list = level.m_6443_(Projectile.class, box, all);
        if ((Integer)DreamtinkerConfig.ProjLimit.get() <= list.size()) {
            for (Projectile old : list) {
                old.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private static boolean isMatch(ItemStack stack, ModifierNBT target, boolean compareUpgrades) {
        if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModifierNBT mine = compareUpgrades ? tool.getUpgrades() : tool.getModifiers();
        return mine.equals((Object)target);
    }

    public static ItemStack findItemByModifierNBT(LivingEntity entity, ModifierNBT target, boolean compareUpgrades) {
        ItemStack main = entity.m_21205_();
        if (DThelper.isMatch(main, target, compareUpgrades)) {
            return main;
        }
        ItemStack off = entity.m_21206_();
        if (DThelper.isMatch(off, target, compareUpgrades)) {
            return off;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (int i = 0; i < 9; ++i) {
                ItemStack hot = player.m_150109_().m_8020_(i);
                if (!DThelper.isMatch(hot, target, compareUpgrades)) continue;
                return hot;
            }
        }
        return null;
    }

    public static void debugEffects(List<MobEffect> effects) {
        for (MobEffect effect : effects) {
            ResourceLocation id = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
            String key = effect.m_19481_();
            System.out.println("Random effect \u2192 {" + id + "} ({" + key + "})");
        }
    }

    public static boolean teleport(LivingEntity entity) {
        if (!entity.m_9236_().m_5776_() && entity.m_6084_()) {
            double d0 = entity.m_20185_() + (entity.m_9236_().f_46441_.m_188500_() - 0.5) * 64.0;
            double d1 = entity.m_20186_() + (double)(entity.m_9236_().f_46441_.m_188503_(64) - 32);
            double d2 = entity.m_20189_() + (entity.m_9236_().f_46441_.m_188500_() - 0.5) * 64.0;
            return DThelper.teleport(entity, d0, d1, d2);
        }
        return false;
    }

    private static boolean teleport(LivingEntity entity, double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > entity.m_9236_().m_141937_() && !entity.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = entity.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)entity, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = entity.m_20182_();
            boolean flag2 = entity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                entity.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)entity));
                if (!entity.m_20067_()) {
                    entity.m_9236_().m_6263_((Player)null, entity.f_19854_, entity.f_19855_, entity.f_19856_, SoundEvents.f_11852_, entity.m_5720_(), 1.0f, 1.0f);
                    entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public static List<ToolPartItem> getPartList(MaterialStatsId statsId) {
        return ForgeRegistries.ITEMS.getValues().stream().filter(item -> {
            ToolPartItem part;
            return item instanceof ToolPartItem && (part = (ToolPartItem)item).getStatType() == statsId;
        }).map(item -> (ToolPartItem)item).toList();
    }

    public static ItemStack getPart(MaterialId id, MaterialStatsId statsId, @Nullable RandomSource rdm) {
        MaterialId mli = MaterialRegistry.getMaterial((MaterialId)id).getIdentifier();
        List<ToolPartItem> Parts = DThelper.getPartList(statsId);
        if (Parts.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ToolPartItem part = Parts.get(0);
        if (rdm != null) {
            part = Parts.get(rdm.m_188503_(Parts.size()));
        }
        return part.withMaterial((MaterialVariantId)mli);
    }
}

