/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootEntryInspector {
    private static Field conditionsField;
    private static final ConcurrentMap<String, Field> FIELDS;
    private static final float RARE_CHANCE_THRESHOLD = 0.1f;

    public static <T> List<T> get(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        Class<?> c = obj.getClass();
        String key = c.getName() + "#" + name;
        try {
            Field f = FIELDS.computeIfAbsent(key, k -> {
                try {
                    Field x = c.getDeclaredField(name);
                    x.setAccessible(true);
                    return x;
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            });
            if (f == null) {
                return null;
            }
            Object val = f.get(obj);
            if (val == null) {
                return null;
            }
            if (val instanceof List) {
                List list = (List)val;
                return list;
            }
            if (val.getClass().isArray()) {
                int n = Array.getLength(val);
                ArrayList<Object> out = new ArrayList<Object>(n);
                for (int i = 0; i < n; ++i) {
                    out.add(Array.get(val, i));
                }
                return out;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static LootItemCondition[] getConditions(LootPoolEntryContainer entry) {
        try {
            return (LootItemCondition[])conditionsField.get(entry);
        }
        catch (Exception e) {
            return new LootItemCondition[0];
        }
    }

    public static ItemStack getItemStack(LootPoolEntryContainer entry) {
        if (entry instanceof LootItem) {
            LootItem lootItem = (LootItem)entry;
            try {
                Field itemField = LootItem.class.getDeclaredField("item");
                itemField.setAccessible(true);
                Item item = (Item)itemField.get(lootItem);
                return new ItemStack((ItemLike)item);
            }
            catch (Exception e) {
                return ItemStack.f_41583_;
            }
        }
        return ItemStack.f_41583_;
    }

    private static Float readChance(LootItemCondition condition) {
        Class<?> cls = condition.getClass();
        String key = cls.getName() + "#chance";
        Field f = FIELDS.computeIfAbsent(key, k -> {
            try {
                Field x = cls.getDeclaredField("chance");
                x.setAccessible(true);
                return x;
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        });
        if (f == null) {
            return null;
        }
        try {
            return Float.valueOf(f.getFloat(condition));
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static boolean isLowChanceCondition(LootItemCondition condition) {
        ResourceLocation typeId = BuiltInRegistries.f_256991_.m_7981_((Object)condition.m_7940_());
        if (typeId == null) {
            return false;
        }
        String path = typeId.m_135815_();
        if ("random_chance".equals(path) || "random_chance_with_looting".equals(path)) {
            Float chance = LootEntryInspector.readChance(condition);
            return chance != null && chance.floatValue() < 0.1f;
        }
        return false;
    }

    public static boolean matchRareKeys(LootItemCondition condition) {
        ResourceLocation typeId = BuiltInRegistries.f_256991_.m_7981_((Object)condition.m_7940_());
        String key = typeId != null ? typeId.m_135815_() : condition.getClass().getName().toLowerCase(Locale.ROOT);
        return key.contains("match_tool") || key.contains("entity") || key.contains("damage_source") || key.contains("survives_explosion") || key.contains("location") || key.contains("time") || key.contains("weather") || key.contains("value_check");
    }

    public static boolean hasRareFunctionCondition(LootPoolEntryContainer entry) {
        List<LootItemCondition> entryConds = LootEntryInspector.get(entry, "conditions");
        if (LootEntryInspector.anyRare(entryConds)) {
            return true;
        }
        List<LootItemFunction> funcs = LootEntryInspector.get(entry, "functions");
        if (LootEntryInspector.functionsHaveRare(funcs)) {
            return true;
        }
        List<LootPoolEntryContainer> children = LootEntryInspector.get(entry, "children");
        if (children != null) {
            for (LootPoolEntryContainer child : children) {
                if (!LootEntryInspector.hasRareFunctionCondition(child)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean functionsHaveRare(List<LootItemFunction> funcs) {
        if (funcs == null) {
            return false;
        }
        for (LootItemFunction fn : funcs) {
            List<LootItemCondition> conds = LootEntryInspector.getFunctionConds(fn);
            if (!LootEntryInspector.anyRare(conds)) continue;
            return true;
        }
        return false;
    }

    private static List<LootItemCondition> getFunctionConds(LootItemFunction fn) {
        List<Object> c = LootEntryInspector.get(fn, "predicates");
        if (c != null) {
            return c;
        }
        c = LootEntryInspector.get(fn, "conditions");
        if (c != null) {
            return c;
        }
        c = LootEntryInspector.get(fn, "terms");
        if (c != null) {
            return c;
        }
        return null;
    }

    private static boolean anyRare(List<LootItemCondition> conds) {
        if (conds == null) {
            return false;
        }
        for (LootItemCondition c : conds) {
            if (c == null || !LootEntryInspector.isLowChanceCondition(c) && !LootEntryInspector.matchRareKeys(c)) continue;
            return true;
        }
        return false;
    }

    public static String describeLootEntry(LootPoolEntryContainer entry) {
        if (entry instanceof LootItem) {
            LootItem lootItem = (LootItem)entry;
            try {
                Field itemField = LootItem.class.getDeclaredField("item");
                itemField.setAccessible(true);
                Item item = (Item)itemField.get(lootItem);
                return "LootItem \u2192 " + item.m_5524_();
            }
            catch (Exception e) {
                return "LootItem(\u672a\u77e5\u7269\u54c1)";
            }
        }
        if (entry instanceof LootTableReference) {
            LootTableReference tableRef = (LootTableReference)entry;
            try {
                Field tableField = LootTableReference.class.getDeclaredField("name");
                tableField.setAccessible(true);
                ResourceLocation ref = (ResourceLocation)tableField.get(tableRef);
                return "LootTableReference \u2192 " + ref.toString();
            }
            catch (Exception e) {
                return "LootTableReference(\u672a\u77e5\u8868)";
            }
        }
        if (entry.getClass().getSimpleName().toLowerCase().contains("tag")) {
            return "TagEntry\uff08\u6807\u7b7e\u6761\u76ee\uff09";
        }
        return entry.getClass().getSimpleName() + "\uff08\u672a\u77e5\u7c7b\u578b\uff09";
    }

    public static boolean rarityfromitem(LootPoolEntryContainer entry) {
        if (entry instanceof LootItem) {
            LootItem lootItem = (LootItem)entry;
            try {
                Field itemField = LootItem.class.getDeclaredField("item");
                itemField.setAccessible(true);
                Item item = (Item)itemField.get(lootItem);
                return Rarity.RARE == item.m_41460_(item.m_7968_()) || Rarity.RARE == item.m_41460_(item.m_7968_());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    static {
        FIELDS = new ConcurrentHashMap<String, Field>();
        try {
            conditionsField = LootPoolEntryContainer.class.getDeclaredField("conditions");
            conditionsField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

