/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import org.dreamtinker.dreamtinker.network.Dnetwork;
import org.dreamtinker.dreamtinker.network.S2CColorMaskToggle;

public final class MaskService {
    private static final Map<UUID, State> STATES = new HashMap<UUID, State>();

    private static long now(ServerPlayer sp) {
        return sp.m_284548_().m_46467_();
    }

    public static void ensureOn(ServerPlayer sp, int argb, int fadeIn) {
        State s = STATES.get(sp.m_20148_());
        if (s != null && s.enabled && s.argb == argb) {
            return;
        }
        MaskService.sendMaskOn(sp, argb, fadeIn);
        STATES.put(sp.m_20148_(), new State(true, argb, MaskService.now(sp)));
    }

    public static void ensureOff(ServerPlayer sp, int fadeOut) {
        State s = STATES.get(sp.m_20148_());
        if (s == null || !s.enabled) {
            return;
        }
        MaskService.sendMaskOff(sp, fadeOut);
        STATES.put(sp.m_20148_(), new State(false, 0, MaskService.now(sp)));
    }

    public static void ensureOnThrottled(ServerPlayer sp, int argb, int fadeIn, int throttleTicks) {
        long t = MaskService.now(sp);
        State s = STATES.get(sp.m_20148_());
        if (s != null && s.enabled && s.argb == argb && t - s.lastSent < (long)throttleTicks) {
            return;
        }
        MaskService.sendMaskOn(sp, argb, fadeIn);
        STATES.put(sp.m_20148_(), new State(true, argb, t));
    }

    public static void clear(ServerPlayer sp) {
        STATES.remove(sp.m_20148_());
    }

    public static void clearAll() {
        STATES.clear();
    }

    public static void sendMaskOn(ServerPlayer sp, int argb, int fadeIn) {
        Dnetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CColorMaskToggle(true, argb, fadeIn, 0));
    }

    public static void sendMaskOff(ServerPlayer sp, int fadeOut) {
        Dnetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CColorMaskToggle(false, 0, 0, fadeOut));
    }

    private static final class State {
        boolean enabled;
        int argb;
        long lastSent;

        State(boolean e, int c, long t) {
            this.enabled = e;
            this.argb = c;
            this.lastSent = t;
        }
    }
}

