/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.utils.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.armor.MultilayerArmorModel;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;

public class SideAwareArmorModel
extends MultilayerArmorModel {
    public static final SideAwareArmorModel INSTANCE = new SideAwareArmorModel();
    private EquipmentSlot currentSlot = EquipmentSlot.CHEST;
    private SideMaskConfig mask = SideMaskConfig.defaults();
    private List<LayerKind> kinds = List.of();

    private static List<LayerKind> classify(List<ArmorTextureSupplier> layers) {
        ArrayList<LayerKind> out = new ArrayList<LayerKind>(layers.size());
        for (int i = 0; i < layers.size(); ++i) {
            out.add(i == 0 ? LayerKind.PLATING : (i == 1 ? LayerKind.MAILLE : LayerKind.OTHER));
        }
        return out;
    }

    public Model setup(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> base, ArmorModelManager.ArmorModel model) {
        this.currentSlot = slot;
        this.mask = SideMaskConfig.fromStack(stack);
        this.kinds = SideAwareArmorModel.classify(model.layers());
        return super.setup(living, stack, slot, base, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7695_(PoseStack pose, VertexConsumer vc, int light, int overlay, float r, float g, float b, float a) {
        if (this.base == null || buffer == null) {
            return;
        }
        boolean armorGlint = this.hasGlint;
        boolean wingGlint = this.hasGlint;
        boolean isLegSlot = this.currentSlot == EquipmentSlot.LEGS && this.textureType == ArmorTextureSupplier.TextureType.LEGGINGS;
        boolean isFeetSlot = this.currentSlot == EquipmentSlot.FEET && this.textureType == ArmorTextureSupplier.TextureType.ARMOR;
        HumanoidModel hmodel = this.base;
        for (int i = 0; i < this.model.layers().size(); ++i) {
            ArmorTextureSupplier.ArmorTexture wing;
            ArmorTextureSupplier sup = (ArmorTextureSupplier)this.model.layers().get(i);
            ArmorTextureSupplier.ArmorTexture tex = sup.getArmorTexture(this.armorStack, this.textureType, this.registryAccess);
            if (tex != ArmorTextureSupplier.ArmorTexture.EMPTY) {
                HumanoidModel target = hmodel;
                boolean oldL = hmodel.f_102814_.f_104207_;
                boolean oldR = hmodel.f_102813_.f_104207_;
                if (isLegSlot || isFeetSlot) {
                    LayerKind kind = i < this.kinds.size() ? this.kinds.get(i) : LayerKind.OTHER;
                    boolean showL = true;
                    boolean showR = true;
                    if (kind == LayerKind.PLATING) {
                        showL = isLegSlot ? this.mask.platingLeftLeg() : this.mask.platingLeftBoot();
                        showR = isLegSlot ? this.mask.platingRightLeg() : this.mask.platingRightBoot();
                    } else if (kind == LayerKind.MAILLE) {
                        showL = isLegSlot ? this.mask.mailleLeftLeg() : this.mask.mailleLeftBoot();
                        showR = isLegSlot ? this.mask.mailleRightLeg() : this.mask.mailleRightBoot();
                    }
                    hmodel.f_102814_.f_104207_ = showL;
                    hmodel.f_102813_.f_104207_ = showR;
                    try {
                        tex.renderTexture((Model)target, pose, buffer, light, overlay, r, g, b, a, armorGlint);
                    }
                    finally {
                        hmodel.f_102814_.f_104207_ = oldL;
                        hmodel.f_102813_.f_104207_ = oldR;
                    }
                } else if (this.currentSlot == EquipmentSlot.HEAD && this.textureType == ArmorTextureSupplier.TextureType.ARMOR) {
                    ModelPart head = target.f_102808_;
                    float ox = head.f_104200_;
                    float oy = head.f_104201_;
                    float oz = head.f_104202_;
                    float sx = head.f_233553_;
                    float sy = head.f_233554_;
                    float sz = head.f_233555_;
                    head.f_104202_ += 5.0f;
                    head.f_104201_ -= 3.0f;
                    float k = 1.22f;
                    head.f_233553_ *= k;
                    head.f_233554_ *= k;
                    head.f_233555_ *= k;
                    tex.renderTexture((Model)target, pose, buffer, 0xF000F0, overlay, r, g, b, a, armorGlint);
                    head.f_104200_ = ox;
                    head.f_104201_ = oy;
                    head.f_104202_ = oz;
                    head.f_233553_ = sx;
                    head.f_233554_ = sy;
                    head.f_233555_ = sz;
                } else {
                    tex.renderTexture((Model)target, pose, buffer, light, overlay, r, g, b, a, armorGlint);
                }
                armorGlint = false;
            }
            if (!this.hasWings || (wing = sup.getArmorTexture(this.armorStack, ArmorTextureSupplier.TextureType.WINGS, this.registryAccess)) == ArmorTextureSupplier.ArmorTexture.EMPTY) continue;
            this.renderWings(pose, light, overlay, wing, r, g, b, a, wingGlint);
            wingGlint = false;
        }
    }

    public record SideMaskConfig(boolean platingLeftLeg, boolean platingRightLeg, boolean platingLeftBoot, boolean platingRightBoot, boolean mailleLeftLeg, boolean mailleRightLeg, boolean mailleLeftBoot, boolean mailleRightBoot) {
        public static SideMaskConfig defaults() {
            return new SideMaskConfig(false, true, true, true, false, true, true, false);
        }

        public static SideMaskConfig fromStack(ItemStack stack) {
            return SideMaskConfig.defaults();
        }
    }

    private static enum LayerKind {
        PLATING,
        MAILLE,
        OTHER;

    }
}

