/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker.world.worldgen;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.dreamtinker.dreamtinker.Dreamtinker;
import org.dreamtinker.dreamtinker.common.DreamtinkerCommon;

public class ModWorldGen {
    public static final ResourceKey<ConfiguredFeature<?, ?>> NARCISSUS_PATCH = ModWorldGen.key(Registries.f_256911_, "narcissus_patch");
    public static final ResourceKey<PlacedFeature> NARCISSUS_PATCH_PLACED = ModWorldGen.key(Registries.f_256988_, "narcissus_patch");
    public static ResourceKey<ConfiguredFeature<?, ?>> configuredSmallLarimarOre = ModWorldGen.key(Registries.f_256911_, "larimar_ore_small");
    public static ResourceKey<PlacedFeature> placedSmallLarimarOre = ModWorldGen.key(Registries.f_256988_, "larimar_ore_small");
    public static ResourceKey<ConfiguredFeature<?, ?>> configuredLargeLarimarOre = ModWorldGen.key(Registries.f_256911_, "larimar_ore_large");
    public static ResourceKey<PlacedFeature> placedLargeLarimarOre = ModWorldGen.key(Registries.f_256988_, "larimar_ore_large");

    public static void bootstrapConfigured(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        BlockState flowerState = ((FlowerBlock)DreamtinkerCommon.narcissus.get()).m_49966_();
        Holder inner = PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)flowerState)), (BlockPredicate)BlockPredicate.m_190404_((BlockPredicate)BlockPredicate.m_190419_(), (BlockPredicate)BlockPredicate.m_190399_((BlockState)flowerState, (Vec3i)BlockPos.f_121853_)));
        RandomPatchConfiguration patchCfg = new RandomPatchConfiguration(24, 6, 2, inner);
        ctx.m_255272_(NARCISSUS_PATCH, (Object)new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)patchCfg));
        BlockMatchTest sandstone = new BlockMatchTest(Blocks.f_50062_);
        BlockState larimarOre = ((Block)DreamtinkerCommon.larimarOre.get()).m_49966_();
        ModWorldGen.register(ctx, configuredSmallLarimarOre, Feature.f_65731_, new OreConfiguration((RuleTest)sandstone, larimarOre, 4));
        ModWorldGen.register(ctx, configuredLargeLarimarOre, Feature.f_65731_, new OreConfiguration((RuleTest)sandstone, larimarOre, 6));
    }

    public static void bootstrapPlaced(BootstapContext<PlacedFeature> ctx) {
        HolderGetter conf = ctx.m_255420_(Registries.f_256911_);
        Holder.Reference cf = conf.m_255043_(NARCISSUS_PATCH);
        ctx.m_255272_(NARCISSUS_PATCH_PLACED, (Object)new PlacedFeature((Holder)cf, List.of(RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        ModWorldGen.register(ctx, placedSmallLarimarOre, configuredSmallLarimarOre, new PlacementModifier[]{CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)45), (VerticalAnchor)VerticalAnchor.m_158922_((int)70)), BiomeFilter.m_191561_()});
        ModWorldGen.register(ctx, placedLargeLarimarOre, configuredLargeLarimarOre, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)45), (VerticalAnchor)VerticalAnchor.m_158922_((int)70)), BiomeFilter.m_191561_()});
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<F> feature, FC config) {
        ModWorldGen.register(context, key, (Feature)feature.get(), config);
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configured, PlacementModifier ... placement) {
        context.m_255272_(key, (Object)new PlacedFeature((Holder)context.m_255420_(Registries.f_256911_).m_255043_(configured), List.of(placement)));
    }

    protected static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> registry, String name) {
        return ResourceKey.m_135785_(registry, (ResourceLocation)Dreamtinker.getLocation(name));
    }
}

