/*
 * Decompiled with CFR 0.152.
 */
package net.derfruhling.minecraft.golem;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.derfruhling.minecraft.golem.Golem;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CopperMemoryBlockEntity
extends class_2586 {
    private final Hashtable<Integer, List<class_2338>> items = new Hashtable();
    private final Hashtable<class_2338, Set<Integer>> containers = new Hashtable();
    private static final Codec<Map<class_2960, List<class_2338>>> MAP_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.list((Codec)class_2338.field_25064));

    public CopperMemoryBlockEntity(class_2338 pos, class_2680 state) {
        super(Golem.MEMORY_BLOCK_ENTITY, pos, state);
    }

    protected synchronized void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71468("items", MAP_CODEC, (Object)ImmutableMap.copyOf(this.items.entrySet().stream().map(e -> new Map.Entry<class_2960, List<class_2338>>(){

            @Override
            public class_2960 getKey() {
                return class_7923.field_41178.method_10221((Object)((class_1792)class_7923.field_41178.method_10200(((Integer)e.getKey()).intValue())));
            }

            @Override
            public List<class_2338> getValue() {
                return (List)e.getValue();
            }

            @Override
            public List<class_2338> setValue(List<class_2338> value) {
                return e.setValue(value);
            }
        }).toList()));
    }

    private void addContainer(int item, class_2338 pos) {
        this.containers.compute(pos, (k, v) -> {
            if (v == null) {
                return new TreeSet<Integer>(List.of(Integer.valueOf(item)));
            }
            v.add(item);
            return v;
        });
    }

    private void removeContainer(int item, class_2338 pos) {
        this.containers.computeIfPresent(pos, (k, v) -> {
            v.remove(item);
            return v;
        });
    }

    protected synchronized void method_11014(class_11368 view) {
        super.method_11014(view);
        this.items.clear();
        Optional map = view.method_71426("items", MAP_CODEC);
        if (map.isPresent()) {
            for (Map.Entry e : ((Map)map.get()).entrySet()) {
                if (!class_7923.field_41178.method_10250((class_2960)e.getKey())) continue;
                int item = class_7923.field_41178.method_10206((Object)((class_1792)class_7923.field_41178.method_63535((class_2960)e.getKey())));
                this.items.put(item, (List)e.getValue());
                for (class_2338 pos : (List)e.getValue()) {
                    this.addContainer(item, pos);
                }
            }
        }
    }

    private List<class_2338> get(int item) {
        return this.items.get(item);
    }

    @Nullable
    public synchronized List<class_2338> get(class_1792 item) {
        return this.get(class_7923.field_41178.method_10206((Object)item));
    }

    public synchronized void found(class_1792 item, class_2338 pos) {
        int itemId = class_7923.field_41178.method_10206((Object)item);
        List<class_2338> loc = this.get(itemId);
        if (loc != null) {
            if (!loc.contains(pos)) {
                loc.add(pos);
            }
            while (loc.size() > 10) {
                this.removeContainer(itemId, loc.removeFirst());
            }
        } else {
            this.items.put(itemId, new ArrayList<class_2338>(List.of(pos)));
        }
        this.addContainer(itemId, pos);
        this.method_5431();
    }

    public synchronized void dead(class_1792 item, class_2338 pos) {
        int itemId = class_7923.field_41178.method_10206((Object)item);
        List<class_2338> loc = this.get(itemId);
        if (loc != null) {
            loc.remove(pos);
            if (loc.isEmpty()) {
                this.items.remove(itemId);
            }
        }
        this.removeContainer(itemId, pos);
        this.method_5431();
    }
}

