/*
 * Decompiled with CFR 0.152.
 */
package net.derfruhling.minecraft.golem.mixin;

import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.derfruhling.minecraft.golem.CopperMemoryBlockEntity;
import net.derfruhling.minecraft.golem.EmptyIterator;
import net.derfruhling.minecraft.golem.Golem;
import net.minecraft.class_11568;
import net.minecraft.class_1263;
import net.minecraft.class_1314;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_11568.class})
public abstract class MoveItemsTaskMixin
extends class_4097<class_1314> {
    @Shadow
    private static boolean method_72448(class_1314 entity) {
        return false;
    }

    private MoveItemsTaskMixin(Map<class_4140<?>, class_4141> requiredMemoryState) {
        super(requiredMemoryState);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", remap=false, target="Lcom/google/common/collect/ImmutableMap;of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableMap;"))
    private static ImmutableMap<?, ?> addMemoryStates(Object k1, Object v1, Object k2, Object v2, Object k3, Object v3, Object k4, Object v4) {
        return ImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4, (Object)v4, Golem.SHARED_MEMORY, (Object)class_4141.field_18458, Golem.TRIED_SHARED_MEMORY, (Object)class_4141.field_18458, Golem.REMAINING_MEMORY_HITS, (Object)class_4141.field_18458);
    }

    @Unique
    private Iterator<class_2338> getTryNext(class_1314 entity) {
        return entity.method_18868().method_18904(Golem.REMAINING_MEMORY_HITS).orElse(EmptyIterator.INSTANCE);
    }

    @Unique
    private boolean getTriedMemoryBlock(class_1314 entity) {
        return entity.method_18868().method_18904(Golem.TRIED_SHARED_MEMORY).orElse(false);
    }

    @Unique
    @Nullable
    private CopperMemoryBlockEntity getMemory(class_3218 world, class_1314 entity) {
        class_2586 e = entity.method_18868().method_18904(Golem.SHARED_MEMORY).map(arg_0 -> ((class_3218)world).method_8321(arg_0)).orElse(null);
        if (e instanceof CopperMemoryBlockEntity) {
            CopperMemoryBlockEntity c = (CopperMemoryBlockEntity)e;
            return c;
        }
        return null;
    }

    @ModifyArg(method={"transitionToInteracting", "tickInteracting"}, index=4, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/task/MoveItemsTask;selectInteractionState(Lnet/minecraft/entity/mob/PathAwareEntity;Lnet/minecraft/inventory/Inventory;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;)V"))
    private BiConsumer<class_1314, class_1263> markFound(BiConsumer<class_1314, class_1263> pickupItemCallback, @Local(argsOnly=true) class_11568.class_11572 storage) {
        return (entity, inv) -> {
            CopperMemoryBlockEntity memory = this.getMemory((class_3218)entity.method_73183(), (class_1314)entity);
            if (memory != null) {
                memory.found(entity.method_6047().method_7909(), storage.comp_4427());
            }
            pickupItemCallback.accept((class_1314)entity, (class_1263)inv);
        };
    }

    @ModifyArg(method={"transitionToInteracting", "tickInteracting"}, index=5, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/task/MoveItemsTask;selectInteractionState(Lnet/minecraft/entity/mob/PathAwareEntity;Lnet/minecraft/inventory/Inventory;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;)V"))
    private BiConsumer<class_1314, class_1263> markNotFound(BiConsumer<class_1314, class_1263> pickupNoItemCallback, @Local(argsOnly=true) class_11568.class_11572 storage) {
        return (entity, inv) -> {
            CopperMemoryBlockEntity memory = this.getMemory((class_3218)entity.method_73183(), (class_1314)entity);
            class_1792 item = entity.method_6047().method_7909();
            if (memory != null && !inv.method_43256(s -> s.method_7909() == item)) {
                memory.dead(item, storage.comp_4427());
            }
            pickupNoItemCallback.accept((class_1314)entity, (class_1263)inv);
        };
    }

    @Inject(method={"findStorage"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=0)}, cancellable=true)
    private void findStorage(class_3218 world, class_1314 entity, CallbackInfoReturnable<Optional<class_11568.class_11572>> cir) {
        CopperMemoryBlockEntity memory = this.getMemory(world, entity);
        if (memory != null && !MoveItemsTaskMixin.method_72448(entity)) {
            Iterator<class_2338> tryNext = this.getTryNext(entity);
            class_1799 stack = entity.method_6047();
            if (!this.getTriedMemoryBlock(entity) && !tryNext.hasNext()) {
                List<class_2338> loc = memory.get(stack.method_7909());
                if (loc != null) {
                    tryNext = loc.iterator();
                    entity.method_18868().method_18878(Golem.REMAINING_MEMORY_HITS, tryNext);
                    entity.method_18868().method_18878(Golem.TRIED_SHARED_MEMORY, (Object)true);
                } else {
                    return;
                }
            }
            while (tryNext.hasNext()) {
                class_2338 pos = tryNext.next();
                class_2586 newBlockEntity = world.method_8321(pos);
                if (newBlockEntity instanceof class_2595) {
                    cir.setReturnValue(Optional.ofNullable(class_11568.class_11572.method_72455((class_2586)newBlockEntity, (class_1937)world)));
                    return;
                }
                memory.dead(stack.method_7909(), pos);
            }
        }
    }

    @Unique
    private double dist(class_2338 pos1, class_2338 pos2) {
        class_243 a = pos2.method_46558().method_1020(pos1.method_46558());
        return Math.sqrt((double)(a.method_10216() * a.method_10216() + a.method_10214() * a.method_10214() + a.method_10215() * a.method_10215()));
    }

    @WrapOperation(method={"findStorage"}, at={@At(value="INVOKE", remap=false, target="Ljava/util/Iterator;next()Ljava/lang/Object;", ordinal=1)})
    Object findStorageNext(Iterator<?> instance, Operation<Object> original, class_3218 world, class_1314 entity) {
        Object obj = original.call(new Object[]{instance});
        if (obj instanceof CopperMemoryBlockEntity) {
            CopperMemoryBlockEntity e = (CopperMemoryBlockEntity)((Object)obj);
            CopperMemoryBlockEntity mem = this.getMemory(world, entity);
            if (mem == null || this.dist(entity.method_24515(), mem.method_11016()) > this.dist(entity.method_24515(), entity.method_24515())) {
                entity.method_18868().method_18878(Golem.SHARED_MEMORY, (Object)e.method_11016());
            }
        }
        return obj;
    }

    @Inject(method={"resetVisitedPositions", "cooldown"}, at={@At(value="TAIL")})
    void resetMemoryState(class_1314 entity, CallbackInfo ci) {
        entity.method_18868().method_18875(Golem.SHARED_MEMORY);
        entity.method_18868().method_18875(Golem.TRIED_SHARED_MEMORY);
        entity.method_18868().method_18875(Golem.REMAINING_MEMORY_HITS);
    }
}

