/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.scsupercraft.mc.libraries.corelib.api.data.AutoSaveData;
import dev.scsupercraft.mc.libraries.corelib.api.data.Data;
import dev.scsupercraft.mc.libraries.corelib.api.data.WorldSaveData;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="1.0.0")
public sealed class SaveData<T>
implements Data<T>
permits AutoSaveData, WorldSaveData {
    private static final Gson GSON = new GsonBuilder().create();
    private final Supplier<File> fileGetter;
    private final CodecHolder<T> codecHolder;
    private boolean dirty = false;
    private final Type type;
    private final Supplier<T> defaultValue;
    @NotNull
    private T value;

    @ApiStatus.AvailableSince(value="1.0.0")
    public SaveData(Supplier<@NotNull T> defaultValue, CodecHolder<T> codecHolder, Supplier<File> fileGetter, Type type) {
        this.defaultValue = defaultValue;
        this.value = defaultValue.get();
        this.codecHolder = codecHolder;
        this.fileGetter = fileGetter;
        this.type = type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.AvailableSince(value="1.0.0")
    public void load() {
        File file = this.fileGetter.get();
        if (!file.exists()) {
            this.value = this.defaultValue.get();
            this.save();
            return;
        }
        try (FileReader fileReader = new FileReader(file);){
            switch (this.type.ordinal()) {
                case 0: {
                    JsonObject object = (JsonObject)GSON.fromJson((Reader)fileReader, JsonObject.class);
                    DataResult result = this.codecHolder.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)object.get("data"));
                    this.value = ((Pair)result.getOrThrow()).getFirst();
                    return;
                }
                case 1: {
                    CompoundTag compound = NbtIo.readCompressed((Path)file.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                    DataResult result = this.codecHolder.codec().decode((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("data"));
                    this.value = ((Pair)result.getOrThrow()).getFirst();
                    return;
                }
            }
            return;
        }
        catch (IOException | IllegalStateException e) {
            throw new RuntimeException("Error loading data", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.AvailableSince(value="1.0.0")
    public void save() {
        File file = this.fileGetter.get();
        if (!this.dirty && file.exists()) {
            return;
        }
        this.dirty = false;
        if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            return;
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            switch (this.type.ordinal()) {
                case 0: {
                    JsonObject object = new JsonObject();
                    JsonElement element = (JsonElement)this.codecHolder.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, this.value).getOrThrow();
                    object.add("data", element);
                    fileWriter.write(GSON.toJson((JsonElement)object));
                    return;
                }
                case 1: {
                    CompoundTag compound = new CompoundTag();
                    Tag element = (Tag)this.codecHolder.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, this.value).getOrThrow();
                    compound.put("data", element);
                    NbtIo.writeCompressed((CompoundTag)compound, (Path)file.toPath());
                    return;
                }
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving data", e);
        }
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public CodecHolder<T> getCodecHolder() {
        return this.codecHolder;
    }

    @Override
    @ApiStatus.AvailableSince(value="1.0.0")
    @NotNull
    public T getData() {
        return this.value;
    }

    @Override
    @ApiStatus.AvailableSince(value="1.0.0")
    public void setData(@NotNull T value) {
        this.value = Objects.requireNonNull(value);
        this.markDirty();
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public void markDirty() {
        this.dirty = true;
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static enum Type {
        JSON,
        NBT;

    }
}

