/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.serialization;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalLong;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public class Codecs
extends ExtraCodecs {
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Boolean> BOOL = Codec.BOOL;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Byte> BYTE = Codec.BYTE;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Short> SHORT = Codec.SHORT;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Integer> INT = Codec.INT;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Long> LONG = Codec.LONG;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Float> FLOAT = Codec.FLOAT;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Double> DOUBLE = Codec.DOUBLE;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<String> STRING = Codec.STRING;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final PrimitiveCodec<Character> CHARACTER = new PrimitiveCodec<Character>(){

        public <T> DataResult<Character> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(s -> Character.valueOf(s.charAt(0)));
        }

        public <T> T write(DynamicOps<T> ops, Character value) {
            return (T)ops.createString(String.valueOf(value.charValue()));
        }

        public String toString() {
            return "Character";
        }
    };
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final Codec<UUID> UUID = UUIDUtil.AUTHLIB_CODEC;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final Codec<BigInteger> BIG_INTEGER = Codec.STRING.xmap(BigInteger::new, BigInteger::toString);
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final Codec<BigDecimal> BIG_DECIMAL = Codec.STRING.xmap(BigDecimal::new, BigDecimal::toString);
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final Codec<GameProfile> GAME_PROFILE = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.AUTHLIB_CODEC.fieldOf("id").forGetter(GameProfile::getId), (App)Codec.STRING.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)instance, GameProfile::new));
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final Codec<OptionalLong> OPTIONAL_LONG = new Codec<OptionalLong>(){

        public <T> DataResult<Pair<OptionalLong, T>> decode(DynamicOps<T> ops, T input) {
            DataResult longResult = Codec.LONG.decode(ops, input);
            return longResult.result().map(pair -> DataResult.success((Object)Pair.of((Object)OptionalLong.of((Long)pair.getFirst()), (Object)pair.getSecond()))).orElse(DataResult.success((Object)Pair.of((Object)OptionalLong.empty(), input)));
        }

        public <T> DataResult<T> encode(OptionalLong input, DynamicOps<T> ops, T prefix) {
            return input.isPresent() ? Codec.LONG.encode((Object)input.getAsLong(), ops, prefix) : DataResult.success(prefix);
        }
    };
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final Codec<ResourceKey> REGISTRY_KEY = ResourceLocation.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final Codec<TagKey> TAG_KEY = RecordCodecBuilder.create(instance -> instance.group((App)REGISTRY_KEY.fieldOf("registryRef").forGetter(TagKey::registry), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(TagKey::location)).apply((Applicative)instance, TagKey::create));

    private Codecs() {
    }
}

