/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.serialization;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.OptionalLong;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public class PacketCodecs
implements ByteBufCodecs {
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, Character> CHARACTER = STRING_UTF8.map(s -> Character.valueOf(s.charAt(0)), c -> String.valueOf(c.charValue()));
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, UUID> UUID = UUIDUtil.STREAM_CODEC;
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, IntProvider> INT_PROVIDER = ByteBufCodecs.fromCodec((Codec)IntProvider.CODEC);
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, BigInteger> BIG_INTEGER = ByteBufCodecs.STRING_UTF8.map(BigInteger::new, BigInteger::toString);
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, BigDecimal> BIG_DECIMAL = ByteBufCodecs.STRING_UTF8.map(BigDecimal::new, BigDecimal::toString);
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, OptionalLong> OPTIONAL_LONG = StreamCodec.ofMember((value, buf) -> {
        buf.writeBoolean(value.isPresent());
        if (value.isPresent()) {
            buf.writeLong(value.getAsLong());
        }
    }, buf -> {
        boolean present = buf.readBoolean();
        return present ? OptionalLong.of(buf.readLong()) : OptionalLong.empty();
    });
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, ResourceKey> REGISTRY_KEY = ResourceLocation.STREAM_CODEC.map(ResourceKey::createRegistryKey, ResourceKey::location);
    @ApiStatus.AvailableSince(value="1.0.0")
    public static final StreamCodec<ByteBuf, TagKey> TAG_KEY = StreamCodec.composite(REGISTRY_KEY, TagKey::registry, (StreamCodec)ResourceLocation.STREAM_CODEC, TagKey::location, TagKey::create);

    private PacketCodecs() {
    }
}

