/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.api.util;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.scsupercraft.mc.libraries.corelib.CoreLib;
import dev.scsupercraft.mc.libraries.corelib.api.data.SyncedData;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="1.0.0")
public class Synchronisation {
    private static final Map<ResourceLocation, SyncedObject<?>> SYNCED_OBJECTS = new HashMap();

    @ApiStatus.AvailableSince(value="1.0.0")
    public static <T> void setup(SyncedData<T> syncedData, CodecHolder<T> codecHolder) {
        if (!SYNCED_OBJECTS.containsKey(syncedData.getSyncId())) {
            SYNCED_OBJECTS.put(syncedData.getSyncId(), new SyncedObject<T>(syncedData, codecHolder));
        }
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static void synchronise(SyncedData<?> syncedData) {
        Synchronisation.synchronise(SYNCED_OBJECTS.get(syncedData.getSyncId()));
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static void synchronise(SyncedData<?> syncedData, ServerPlayer client) {
        Synchronisation.synchronise(SYNCED_OBJECTS.get(syncedData.getSyncId()), client);
    }

    @ApiStatus.AvailableSince(value="1.0.0")
    public static void synchronise(ServerPlayer client) {
        SYNCED_OBJECTS.values().forEach(obj -> Synchronisation.synchronise(obj, client));
    }

    private static void synchronise(SyncedObject<?> syncedObject) {
        CoreLib.LOGGER.info("Synchronising {} to all clients...", (Object)syncedObject.syncedData.getSyncId());
        syncedObject.sync();
    }

    private static void synchronise(SyncedObject<?> syncedObject, ServerPlayer client) {
        CoreLib.LOGGER.info("Synchronising {} to client {}...", (Object)syncedObject.syncedData.getSyncId(), (Object)client.getGameProfile().getName());
        syncedObject.sync(client);
    }

    private static <T> SyncedObject<T> get(ResourceLocation id) {
        return (SyncedObject)Utils.cast(SYNCED_OBJECTS.get(id));
    }

    private Synchronisation() {
    }

    static {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, DataSyncPacket.PACKET_ID, DataSyncPacket.PACKET_CODEC, (packet, context) -> {
            SyncedData syncedData = Synchronisation.get(packet.id()).syncedData();
            syncedData.setSyncedData(packet.data());
            CoreLib.LOGGER.info("Synchronised {} with the server.", (Object)packet.id());
        });
        PlayerEvent.PLAYER_JOIN.register(Synchronisation::synchronise);
    }

    private record SyncedObject<T>(SyncedData<T> syncedData, CodecHolder<T> codecHolder) {
        private DataSyncPacket<T> createPacket() {
            return new DataSyncPacket(this.syncedData.getSyncId(), this.syncedData.getData());
        }

        private void sync() {
            if (CoreLib.server == null) {
                return;
            }
            NetworkManager.sendToPlayers((Iterable)CoreLib.server.getPlayerList().getPlayers(), this.createPacket());
        }

        private void sync(ServerPlayer client) {
            if (CoreLib.server == null || client == null) {
                return;
            }
            NetworkManager.sendToPlayer((ServerPlayer)client, this.createPacket());
        }
    }

    private record DataSyncPacket<T>(ResourceLocation id, T data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<DataSyncPacket<?>> PACKET_ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"corelib", (String)"data_sync"));
        public static final StreamCodec<FriendlyByteBuf, DataSyncPacket<?>> PACKET_CODEC = StreamCodec.ofMember((value, buf) -> {
            buf.writeResourceLocation(value.id);
            SyncedObject synced = Synchronisation.get(value.id);
            synced.codecHolder().packetCodec().encode(buf, value.data);
        }, buf -> {
            ResourceLocation id = buf.readResourceLocation();
            return new DataSyncPacket<Object>(id, Synchronisation.get(id).codecHolder().packetCodec().decode(buf));
        });

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

