/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.serialization.resolver.basic;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHelper;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialization.GenericClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecordCodecResolver
implements CodecResolver {
    private static <T> Codec<T> buildRecordCodec(Class<T> recordClass, Map<RecordComponent, CodecHolder<?>> codecs) {
        try {
            Constructor constructor = (Constructor)Utils.cast(recordClass.getDeclaredConstructors()[0]);
            constructor.setAccessible(true);
            if (codecs.size() == 0) {
                return Codec.unit(constructor.newInstance(new Object[0]));
            }
            ArrayList<RecordCodecBuilder> builders = new ArrayList<RecordCodecBuilder>();
            for (RecordComponent component : codecs.keySet()) {
                CodecHolder<?> holder = codecs.get(component);
                Method accessor = component.getAccessor();
                accessor.setAccessible(true);
                builders.add(holder.codec().flatXmap(RecordCodecResolver::toResult, RecordCodecResolver::fromResult).fieldOf(component.getName()).forGetter(obj -> {
                    try {
                        return new Result<Object>(accessor.invoke(obj, new Object[0]), null);
                    }
                    catch (Exception e) {
                        return new Result<Object>(null, e);
                    }
                }));
            }
            return RecordCodecBuilder.create(instance -> RecordCodecResolver.group(builders, instance, args -> {
                try {
                    return constructor.newInstance(args);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build record codec!", e);
        }
    }

    private static <O> App<RecordCodecBuilder.Mu<O>, O> group(List<RecordCodecBuilder<O, ?>> list, RecordCodecBuilder.Instance<O> instance, Function<Object[], O> function) {
        switch (list.size()) {
            case 1: {
                return instance.group((App)list.get(0)).apply(instance, a -> function.apply(new Object[]{a}));
            }
            case 2: {
                return instance.group((App)list.get(0), (App)list.get(1)).apply(instance, (a, b) -> function.apply(new Object[]{a, b}));
            }
            case 3: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2)).apply(instance, (a, b, c) -> function.apply(new Object[]{a, b, c}));
            }
            case 4: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3)).apply(instance, (a, b, c, d) -> function.apply(new Object[]{a, b, c, d}));
            }
            case 5: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4)).apply(instance, (a, b, c, d, e) -> function.apply(new Object[]{a, b, c, d, e}));
            }
            case 6: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5)).apply(instance, (a, b, c, d, e, f) -> function.apply(new Object[]{a, b, c, d, e, f}));
            }
            case 7: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6)).apply(instance, (a, b, c, d, e, f, g) -> function.apply(new Object[]{a, b, c, d, e, f, g}));
            }
            case 8: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7)).apply(instance, (a, b, c, d, e, f, g, h) -> function.apply(new Object[]{a, b, c, d, e, f, g, h}));
            }
            case 9: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8)).apply(instance, (a, b, c, d, e, f, g, h, i) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i}));
            }
            case 10: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8), (App)list.get(9)).apply(instance, (a, b, c, d, e, f, g, h, i, j) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i, j}));
            }
            case 11: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8), (App)list.get(9), (App)list.get(10)).apply(instance, (a, b, c, d, e, f, g, h, i, j, k) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i, j, k}));
            }
            case 12: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8), (App)list.get(9), (App)list.get(10), (App)list.get(11)).apply(instance, (a, b, c, d, e, f, g, h, i, j, k, l) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i, j, k, l}));
            }
            case 13: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8), (App)list.get(9), (App)list.get(10), (App)list.get(11), (App)list.get(12)).apply(instance, (a, b, c, d, e, f, g, h, i, j, k, l, m) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i, j, k, l, m}));
            }
            case 14: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8), (App)list.get(9), (App)list.get(10), (App)list.get(11), (App)list.get(12), (App)list.get(13)).apply(instance, (a, b, c, d, e, f, g, h, i, j, k, l, m, n) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i, j, k, l, m, n}));
            }
            case 15: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8), (App)list.get(9), (App)list.get(10), (App)list.get(11), (App)list.get(12), (App)list.get(13), (App)list.get(14)).apply(instance, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i, j, k, l, m, n, o}));
            }
            case 16: {
                return instance.group((App)list.get(0), (App)list.get(1), (App)list.get(2), (App)list.get(3), (App)list.get(4), (App)list.get(5), (App)list.get(6), (App)list.get(7), (App)list.get(8), (App)list.get(9), (App)list.get(10), (App)list.get(11), (App)list.get(12), (App)list.get(13), (App)list.get(14), (App)list.get(15)).apply(instance, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) -> function.apply(new Object[]{a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p}));
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean supportsValue(GenericClass<?> genericClass) {
        return genericClass.clazz.isRecord();
    }

    @Override
    @NotNull
    public <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
        if (!genericClass.clazz.isRecord()) {
            throw new IllegalArgumentException("You can only create an record codec from a record!");
        }
        HashMap codecs = new HashMap();
        for (RecordComponent component : genericClass.clazz.getRecordComponents()) {
            codecs.put(component, CodecHelper.getCodec(GenericClass.of(component.getGenericType(), component.getAnnotatedType(), genericClass)));
        }
        Codec<T> codec = RecordCodecResolver.buildRecordCodec((Class)Utils.cast(genericClass.clazz), codecs);
        StreamCodec packetCodec = ByteBufCodecs.fromCodec(codec);
        return new CodecHolder<T>(codec, packetCodec);
    }

    private static <T> DataResult<Result<T>> toResult(T object) {
        return DataResult.success(new Result<T>(object, null));
    }

    private static <T> DataResult<T> fromResult(Result<T> result) {
        return result.error != null ? DataResult.error(result.error::getMessage) : DataResult.success(result.value);
    }

    private record Result<T>(@Nullable T value, @Nullable Exception error) {
        @Override
        public String toString() {
            return this.value == null ? "Result[error=" + String.valueOf(this.error) + "]" : "Result[value=" + String.valueOf(this.value) + "]";
        }
    }
}

