/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.mc.libraries.corelib.serialization.resolver.unique;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHelper;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecHolder;
import dev.scsupercraft.mc.libraries.corelib.api.serialization.CodecResolver;
import dev.scsupercraft.mc.libraries.corelib.api.util.Utils;
import dev.scsupercraft.mc.libraries.corelib.serialization.GenericClass;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public final class PairCodecResolver
implements CodecResolver {
    @Override
    public boolean supportsValue(GenericClass<?> genericClass) {
        return genericClass.clazz == Pair.class || genericClass.clazz == Tuple.class || genericClass.clazz == org.apache.commons.lang3.tuple.Pair.class;
    }

    @Override
    @NotNull
    public <T> CodecHolder<T> resolveCodec(GenericClass<T> genericClass) {
        CodecHolder<Pair> codecHolder;
        Iterator<GenericClass<?>> iterator = genericClass.typeParameterIterator();
        CodecHolder holderFirst = CodecHelper.getCodec(iterator.next());
        CodecHolder holderSecond = CodecHelper.getCodec(iterator.next());
        Codec codec = (Codec)Utils.cast(Codec.pair((Codec)holderFirst.codec().fieldOf("first").codec(), (Codec)holderSecond.codec().fieldOf("second").codec()));
        StreamCodec packetCodec = PairCodecResolver.pair((StreamCodec)Utils.cast(holderFirst.packetCodec()), (StreamCodec)Utils.cast(holderSecond.packetCodec()));
        CodecHolder<Object> codecHolder1 = codecHolder = new CodecHolder<Pair>(codec, (StreamCodec)Utils.cast(packetCodec));
        if (genericClass.clazz != Pair.class) {
            if (genericClass.clazz == Tuple.class) {
                codecHolder1 = codecHolder.xmap(pair -> new Tuple(pair.getFirst(), pair.getSecond()), pair -> Pair.of((Object)pair.getA(), (Object)pair.getB()));
            } else if (genericClass.clazz == org.apache.commons.lang3.tuple.Pair.class) {
                codecHolder1 = codecHolder.xmap(pair -> org.apache.commons.lang3.tuple.Pair.of((Object)pair.getFirst(), (Object)pair.getSecond()), pair -> Pair.of((Object)pair.getLeft(), (Object)pair.getRight()));
            }
        }
        return (CodecHolder)Utils.cast(codecHolder1);
    }

    static <B extends ByteBuf, F, S> StreamCodec<B, Pair<F, S>> pair(final StreamCodec<? super B, F> first, final StreamCodec<? super B, S> second) {
        return new StreamCodec<B, Pair<F, S>>(){

            public Pair<F, S> decode(B byteBuf) {
                return new Pair(first.decode(byteBuf), second.decode(byteBuf));
            }

            public void encode(B byteBuf, Pair<F, S> pair) {
                first.encode(byteBuf, pair.getFirst());
                second.encode(byteBuf, pair.getSecond());
            }
        };
    }
}

