/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.colorblindness.client;

import com.google.gson.JsonSyntaxException;
import de.cech12.colorblindness.Constants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.effect.MobEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectRendererHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation ACHROMATOMALY = new ResourceLocation("colorblindness", "shaders/post/achromatomaly.json");
    private static final ResourceLocation ACHROMATOPSIA = new ResourceLocation("colorblindness", "shaders/post/achromatopsia.json");
    private static final ResourceLocation DEUTERANOMALY = new ResourceLocation("colorblindness", "shaders/post/deuteranomaly.json");
    private static final ResourceLocation DEUTERANOPIA = new ResourceLocation("colorblindness", "shaders/post/deuteranopia.json");
    private static final ResourceLocation PROTANOMALY = new ResourceLocation("colorblindness", "shaders/post/protanomaly.json");
    private static final ResourceLocation PROTANOPIA = new ResourceLocation("colorblindness", "shaders/post/protanopia.json");
    private static final ResourceLocation TRITANOMALY = new ResourceLocation("colorblindness", "shaders/post/tritanomaly.json");
    private static final ResourceLocation TRITANOPIA = new ResourceLocation("colorblindness", "shaders/post/tritanopia.json");
    private static PostChain achromatomalyShader;
    private static PostChain achromatopsiaShader;
    private static PostChain deuteranomalyShader;
    private static PostChain deuteranopiaShader;
    private static PostChain protanomalyShader;
    private static PostChain protanopiaShader;
    private static PostChain tritanomalyShader;
    private static PostChain tritanopiaShader;
    private static Holder<MobEffect> achromatomalyHolder;
    private static Holder<MobEffect> achromatopsiaHolder;
    private static Holder<MobEffect> deuteranomalyHolder;
    private static Holder<MobEffect> deuteranopiaHolder;
    private static Holder<MobEffect> protanomalyHolder;
    private static Holder<MobEffect> protanopiaHolder;
    private static Holder<MobEffect> tritanomalyHolder;
    private static Holder<MobEffect> tritanopiaHolder;
    private static int lastWidth;
    private static int lastHeight;
    private static final List<PostChain> activeShaders;

    public static void renderColorBlindnessEffect(float renderTickTime) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        EffectRendererHelper.makeColorShaders(mc);
        EffectRendererHelper.makeHolders();
        EffectRendererHelper.fillActiveShaders(player);
        if (activeShaders.isEmpty()) {
            return;
        }
        for (PostChain shader : activeShaders) {
            if (shader == null) continue;
            shader.process(renderTickTime);
        }
        mc.getMainRenderTarget().bindWrite(false);
    }

    private static void fillActiveShaders(LocalPlayer player) {
        activeShaders.clear();
        if (EffectRendererHelper.hasEffect(player, achromatopsiaHolder)) {
            activeShaders.add(achromatopsiaShader);
            return;
        }
        if (EffectRendererHelper.hasEffect(player, achromatomalyHolder)) {
            activeShaders.add(achromatomalyShader);
        }
        if (EffectRendererHelper.hasEffect(player, tritanopiaHolder)) {
            activeShaders.add(tritanopiaShader);
        } else if (EffectRendererHelper.hasEffect(player, tritanomalyHolder)) {
            activeShaders.add(tritanomalyShader);
        }
        if (EffectRendererHelper.hasEffect(player, deuteranopiaHolder)) {
            activeShaders.add(deuteranopiaShader);
        } else if (EffectRendererHelper.hasEffect(player, deuteranomalyHolder)) {
            activeShaders.add(deuteranomalyShader);
        }
        if (EffectRendererHelper.hasEffect(player, protanopiaHolder)) {
            activeShaders.add(protanopiaShader);
        } else if (EffectRendererHelper.hasEffect(player, protanomalyHolder)) {
            activeShaders.add(protanomalyShader);
        }
    }

    private static boolean hasEffect(LocalPlayer player, Holder<MobEffect> effectHolder) {
        return effectHolder != null && player.hasEffect(effectHolder);
    }

    private static PostChain createShaderGroup(ResourceLocation location) {
        try {
            Minecraft mc = Minecraft.getInstance();
            PostChain postChain = new PostChain(mc.getTextureManager(), (ResourceProvider)mc.getResourceManager(), mc.getMainRenderTarget(), location);
            postChain.resize(mc.getWindow().getWidth(), mc.getWindow().getHeight());
            return postChain;
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load shader: {}", (Object)location, (Object)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            LOGGER.warn("Failed to parse shader: {}", (Object)location, (Object)jsonsyntaxexception);
        }
        return null;
    }

    private static void makeColorShaders(Minecraft mc) {
        int width = mc.getWindow().getWidth();
        int height = mc.getWindow().getHeight();
        boolean resizeNeeded = false;
        if (width != lastWidth || height != lastHeight) {
            lastWidth = width;
            lastHeight = height;
            resizeNeeded = true;
        }
        if (achromatomalyShader == null) {
            achromatomalyShader = EffectRendererHelper.createShaderGroup(ACHROMATOMALY);
        } else if (resizeNeeded) {
            achromatomalyShader.resize(width, height);
        }
        if (achromatopsiaShader == null) {
            achromatopsiaShader = EffectRendererHelper.createShaderGroup(ACHROMATOPSIA);
        } else if (resizeNeeded) {
            achromatopsiaShader.resize(width, height);
        }
        if (deuteranomalyShader == null) {
            deuteranomalyShader = EffectRendererHelper.createShaderGroup(DEUTERANOMALY);
        } else if (resizeNeeded) {
            deuteranomalyShader.resize(width, height);
        }
        if (deuteranopiaShader == null) {
            deuteranopiaShader = EffectRendererHelper.createShaderGroup(DEUTERANOPIA);
        } else if (resizeNeeded) {
            deuteranopiaShader.resize(width, height);
        }
        if (protanomalyShader == null) {
            protanomalyShader = EffectRendererHelper.createShaderGroup(PROTANOMALY);
        } else if (resizeNeeded) {
            protanomalyShader.resize(width, height);
        }
        if (protanopiaShader == null) {
            protanopiaShader = EffectRendererHelper.createShaderGroup(PROTANOPIA);
        } else if (resizeNeeded) {
            protanopiaShader.resize(width, height);
        }
        if (tritanomalyShader == null) {
            tritanomalyShader = EffectRendererHelper.createShaderGroup(TRITANOMALY);
        } else if (resizeNeeded) {
            tritanomalyShader.resize(width, height);
        }
        if (tritanopiaShader == null) {
            tritanopiaShader = EffectRendererHelper.createShaderGroup(TRITANOPIA);
        } else if (resizeNeeded) {
            tritanopiaShader.resize(width, height);
        }
    }

    private static void makeHolders() {
        if (achromatomalyHolder == null) {
            achromatomalyHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.ACHROMATOMALY.get());
        }
        if (achromatopsiaHolder == null) {
            achromatopsiaHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.ACHROMATOPSIA.get());
        }
        if (deuteranomalyHolder == null) {
            deuteranomalyHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.DEUTERANOMALY.get());
        }
        if (deuteranopiaHolder == null) {
            deuteranopiaHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.DEUTERANOPIA.get());
        }
        if (protanomalyHolder == null) {
            protanomalyHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.PROTANOMALY.get());
        }
        if (protanopiaHolder == null) {
            protanopiaHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.PROTANOPIA.get());
        }
        if (tritanomalyHolder == null) {
            tritanomalyHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.TRITANOMALY.get());
        }
        if (tritanopiaHolder == null) {
            tritanopiaHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)Constants.TRITANOPIA.get());
        }
    }

    static {
        lastWidth = 0;
        lastHeight = 0;
        activeShaders = new ArrayList<PostChain>();
    }
}

