/*
 * Decompiled with CFR 0.152.
 */
package com.genamistik.mod.quireli.block;

import com.genamistik.mod.quireli.block.entity.DestroyblockBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class DestroyblockBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public DestroyblockBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60913_(1.0f, 10.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_5871_(ItemStack itemstack, BlockGetter level, List<Component> list, TooltipFlag flag) {
        super.m_5871_(itemstack, level, list, flag);
        list.add((Component)Component.m_237113_((String)"\u00a7c\u00a78Destroys blocks in front when powered by redstone (signal \u22656)"));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof MenuProvider) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)((MenuProvider)tileEntity), (BlockPos)pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DestroyblockBlockEntity(pos, state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int power = level.m_277086_(pos);
            if (power >= 6) {
                this.destroyBlockInFront(state, serverLevel, pos);
            }
        }
    }

    private void destroyBlockInFront(BlockState state, ServerLevel level, BlockPos pos) {
        boolean hasFortune;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos targetPos = pos.m_121945_(facing);
        BlockState targetState = level.m_8055_(targetPos);
        if (targetState.m_60795_() || targetState.m_60800_((BlockGetter)level, targetPos) < 0.0f) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof DestroyblockBlockEntity)) {
            return;
        }
        DestroyblockBlockEntity destroyer = (DestroyblockBlockEntity)blockEntity;
        ItemStack tool = destroyer.m_8020_(0);
        boolean hasSilkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0;
        boolean bl = hasFortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool) > 0;
        if (!tool.m_41619_() && tool.m_41763_() && !tool.m_41784_().m_128471_("Unbreakable")) {
            tool.m_220157_(1, level.f_46441_, null);
            if (tool.m_41773_() >= tool.m_41776_()) {
                tool.m_41774_(1);
            }
            destroyer.m_6596_();
        }
        List drops = Block.m_49874_((BlockState)targetState, (ServerLevel)level, (BlockPos)targetPos, (BlockEntity)level.m_7702_(targetPos), null, (ItemStack)tool);
        level.m_46961_(targetPos, false);
        for (ItemStack drop : drops) {
            Containers.m_18992_((Level)level, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), (ItemStack)drop);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof DestroyblockBlockEntity) {
                DestroyblockBlockEntity be = (DestroyblockBlockEntity)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)be);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }
}

