/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.mixin.sodium;

import betterblockentities.BetterBlockEntities;
import betterblockentities.ModelLoader;
import betterblockentities.gui.ConfigManager;
import betterblockentities.mixin.sodium.AbstractBlockRenderContextAccessor;
import betterblockentities.util.BlockEntityExt;
import betterblockentities.util.BlockEntityManager;
import betterblockentities.util.BlockRenderHelper;
import betterblockentities.util.ModelTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.color.ColorProviderRegistry;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1092;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3709;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_8168;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={BlockRenderer.class})
public class BlockRendererMixin {
    @Shadow
    @Final
    private Vector3f posOffset;
    @Shadow
    @Nullable
    private ColorProvider<class_2680> colorProvider;
    @Shadow
    @Final
    private ColorProviderRegistry colorProviderRegistry;

    @Inject(method={"renderModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderModel(class_1087 model, class_2680 state, class_2338 pos, class_2338 origin, CallbackInfo ci) {
        try {
            class_2248 block = state.method_26204();
            if (BlockEntityManager.isSupportedBlock(block) && !ConfigManager.CONFIG.master_optimize) {
                if (block instanceof class_3709) {
                    return;
                }
                if (block instanceof class_2244) {
                    return;
                }
                ci.cancel();
                return;
            }
            AbstractBlockRenderContextAccessor acc = this.setupContext(state, pos, origin);
            if (acc == null) {
                return;
            }
            QuadEmitter emitter = acc.getEmitterInvoke();
            if (block instanceof class_2508 || block instanceof class_7713) {
                ci.cancel();
                if (!ConfigManager.CONFIG.optimize_signs) {
                    return;
                }
                emitter.pushTransform(ModelTransform.rotateY(BlockRenderHelper.computeSignRotation(state)));
                model.emitQuads(emitter, acc.getLevel(), pos, state, acc.getRandom(), acc::isFaceCulledInvoke);
                emitter.popTransform();
            } else if (block instanceof class_7715 || block instanceof class_2551) {
                if (!ConfigManager.CONFIG.optimize_signs) {
                    ci.cancel();
                }
            } else if (block instanceof class_2281 || block instanceof class_2336 || block instanceof class_2480) {
                boolean isShulker = block instanceof class_2480;
                if (isShulker && !ConfigManager.CONFIG.optimize_shulkers || !isShulker && !ConfigManager.CONFIG.optimize_chests) {
                    return;
                }
                ci.cancel();
                List parts = model.method_68512(acc.getRandom());
                int quadThreshold = isShulker ? 10 : 6;
                Map<Boolean, List<class_10889>> partitioned = parts.stream().collect(Collectors.partitioningBy(p -> p.method_68509(null).size() > quadThreshold));
                List<class_10889> lidParts = partitioned.get(true);
                List<class_10889> trunkParts = partitioned.get(false);
                ArrayList<class_10889> merged = new ArrayList<class_10889>();
                BlockEntityExt ext = this.getBlockEntityInstance(pos);
                boolean shouldRender = this.shouldRender(ext);
                if (ConfigManager.CONFIG.updateType == 1) {
                    merged.addAll(trunkParts);
                } else if (shouldRender) {
                    merged.addAll(trunkParts);
                }
                if (shouldRender) {
                    merged.addAll(lidParts);
                }
                BlockRenderHelper.emitQuads(merged, emitter, acc::isFaceCulledInvoke);
            } else if (block instanceof class_3709) {
                if (!ConfigManager.CONFIG.optimize_bells) {
                    return;
                }
                ci.cancel();
                class_5819 rand = acc.getRandom();
                List bell_part = model.method_68512(rand);
                ArrayList bell_body_part = new ArrayList();
                BlockEntityExt ext = this.getBlockEntityInstance(pos);
                boolean shouldRender = this.shouldRender(ext);
                if (shouldRender) {
                    try {
                        class_1092 manager = class_310.method_1551().method_1554();
                        class_1087 bell_body = (class_1087)manager.getModel(ModelLoader.BELL_BODY_KEY);
                        bell_body_part.addAll(bell_body.method_68512(rand));
                    }
                    catch (Exception e) {
                        BetterBlockEntities.getLogger().error("Error: Retrieving bell body BlockModelPart at {}", (Object)pos, (Object)e);
                    }
                }
                ArrayList<class_10889> merged = new ArrayList<class_10889>(bell_part);
                if (!bell_body_part.isEmpty()) {
                    merged.addAll(bell_body_part);
                }
                BlockRenderHelper.emitQuads(merged, emitter, acc::isFaceCulledInvoke);
            } else if (block instanceof class_8168) {
                if (!ConfigManager.CONFIG.optimize_decoratedpots) {
                    ci.cancel();
                    return;
                }
                BlockEntityExt ext = this.getBlockEntityInstance(pos);
                boolean shouldRender = this.shouldRender(ext);
                if (!shouldRender) {
                    ci.cancel();
                }
            }
            this.restoreContext();
        }
        catch (Exception e) {
            BetterBlockEntities.getLogger().error("Error: General fault in BlockRenderer at {}", (Object)pos, (Object)e);
        }
    }

    @Unique
    private boolean shouldRender(BlockEntityExt ext) {
        return ext == null || !ext.getRemoveChunkVariant();
    }

    @Unique
    private BlockEntityExt getBlockEntityInstance(class_2338 pos) {
        try {
            BlockEntityExt bex;
            class_638 world = class_310.method_1551().field_1687;
            class_2586 blockEntity = world.method_8321(pos);
            return blockEntity instanceof BlockEntityExt ? (bex = (BlockEntityExt)blockEntity) : null;
        }
        catch (Exception e) {
            BetterBlockEntities.getLogger().error("Error: Getting Block Entity and accessor at {}", (Object)pos, (Object)e);
            return null;
        }
    }

    @Unique
    AbstractBlockRenderContextAccessor setupContext(class_2680 state, class_2338 pos, class_2338 origin) {
        try {
            AbstractBlockRenderContextAccessor acc = (AbstractBlockRenderContextAccessor)((Object)this);
            acc.setState(state);
            acc.setPos(pos);
            acc.prepareAoInfoInvoke(true);
            this.posOffset.set((float)origin.method_10263(), (float)origin.method_10264(), (float)origin.method_10260());
            if (state.method_49228()) {
                class_243 offset = state.method_26226(pos);
                this.posOffset.add((float)offset.field_1352, (float)offset.field_1351, (float)offset.field_1350);
            }
            this.colorProvider = this.colorProviderRegistry.getColorProvider(state.method_26204());
            acc.prepareCullingInvoke(true);
            acc.setDefaultRenderType(class_4696.method_23679((class_2680)state));
            acc.setAllowDowngrade(true);
            acc.getRandom().method_43052(state.method_26190(pos));
            return acc;
        }
        catch (Exception e) {
            BetterBlockEntities.getLogger().error("Error: Setting up BlockRenderer context failed! at {}", (Object)pos, (Object)e);
            return null;
        }
    }

    @Unique
    void restoreContext() {
        AbstractBlockRenderContextAccessor acc = (AbstractBlockRenderContextAccessor)((Object)this);
        acc.setDefaultRenderType(null);
    }
}

