/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.pack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_155;
import net.minecraft.class_3264;

public class PackMetadataBuilder {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public Map<String, byte[]> createMetadataAndIcon() {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        entries.put("pack.mcmeta", this.createPackMcmeta());
        this.loadIcon(entries);
        return entries;
    }

    private byte[] createPackMcmeta() {
        int version = class_155.method_16673().method_70592(class_3264.field_14188);
        JsonObject packJson = new JsonObject();
        JsonObject packInfo = new JsonObject();
        packInfo.addProperty("pack_format", (Number)version);
        packInfo.addProperty("description", "BBE Resources");
        packJson.add("pack", (JsonElement)packInfo);
        return GSON.toJson((JsonElement)packJson).getBytes(StandardCharsets.UTF_8);
    }

    private void loadIcon(Map<String, byte[]> entries) {
        try (InputStream input = PackMetadataBuilder.class.getResourceAsStream("/assets/betterblockentities/icon.png");){
            if (input != null) {
                entries.put("pack.png", input.readAllBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

