/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.util;

import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4604;

public class BlockVisibilityChecker {
    private static final class_243[] BLOCK_SAMPLE_OFFSETS = BlockVisibilityChecker.generateFaceGrid(5);

    public static boolean isBlockInFOVAndVisible(class_4604 frustum, class_2586 blockEntity) {
        class_1297 player = class_310.method_1551().method_1560();
        class_2338 blockPos = blockEntity.method_11016();
        class_243 eyePos = player.method_5836(1.0f);
        class_243 center = new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
        double maxDistance = 20.0;
        if (eyePos.method_1025(center) > maxDistance * maxDistance) {
            return false;
        }
        if (!BlockVisibilityChecker.isBlockInViewFrustum(frustum, blockEntity)) {
            return false;
        }
        for (class_243 offset : BLOCK_SAMPLE_OFFSETS) {
            class_243 target = new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
            class_3965 hit = player.method_37908().method_17742(new class_3959(eyePos, target, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, player));
            if (hit.method_17783() != class_239.class_240.field_1332 || !hit.method_17777().equals((Object)blockPos)) continue;
            return true;
        }
        return false;
    }

    public static class_2338 getOtherChestHalf(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof class_2281)) {
            return null;
        }
        class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
        if (type == class_2745.field_12569) {
            return null;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2281.field_10768);
        class_2350 side = type == class_2745.field_12574 ? facing.method_10170() : facing.method_10160();
        class_2338 otherPos = pos.method_10093(side);
        class_2680 otherState = world.method_8320(otherPos);
        if (!(otherState.method_26204() instanceof class_2281)) {
            return null;
        }
        class_2745 otherType = (class_2745)otherState.method_11654((class_2769)class_2281.field_10770);
        if (otherType == class_2745.field_12569) {
            return null;
        }
        return otherPos;
    }

    private static class_238 setupBox(class_2586 entity, class_2338 pos) {
        if (entity instanceof class_2573) {
            return new class_238(pos).method_1009(0.0, 1.0, 0.0);
        }
        if (!(entity instanceof class_2595)) {
            return new class_238(pos);
        }
        class_2338 other = BlockVisibilityChecker.getOtherChestHalf(entity.method_10997(), pos);
        if (other == null) {
            return new class_238(pos);
        }
        return new class_238(pos).method_991(new class_238(other));
    }

    private static boolean isBlockInViewFrustum(class_4604 frustum, class_2586 blockEntity) {
        return frustum != null && frustum.method_23093(BlockVisibilityChecker.setupBox(blockEntity, blockEntity.method_11016()));
    }

    private static class_243[] generateFaceGrid(int resolution) {
        ArrayList<class_243> list = new ArrayList<class_243>();
        double step = 1.0 / (double)(resolution - 1);
        for (int y = 0; y < resolution; ++y) {
            for (int x = 0; x < resolution; ++x) {
                double u = (double)x * step;
                double v = (double)y * step;
                list.add(new class_243(0.0, v, u));
                list.add(new class_243(1.0, v, u));
                list.add(new class_243(u, v, 0.0));
                list.add(new class_243(u, v, 1.0));
                list.add(new class_243(u, 0.0, v));
                list.add(new class_243(u, 1.0, v));
            }
        }
        return list.toArray(new class_243[0]);
    }
}

