/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.util;

import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.minecraft.class_1058;

public class ModelTransform {
    public static QuadTransform rotateY(float degrees) {
        float radians = (float)Math.toRadians(degrees);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float centerX = 0.5f;
        float centerZ = 0.5f;
        return quad -> {
            for (int i = 0; i < 4; ++i) {
                float x = quad.x(i) - centerX;
                float y = quad.y(i);
                float z = quad.z(i) - centerZ;
                float newX = x * cos - z * sin;
                float newZ = x * sin + z * cos;
                quad.pos(i, newX + centerX, y, newZ + centerZ);
            }
            return true;
        };
    }

    public static QuadTransform swapSprite(class_1058 newSprite) {
        return quad -> {
            if (!(quad instanceof MutableQuadViewImpl)) {
                return true;
            }
            MutableQuadViewImpl mQuad = (MutableQuadViewImpl)quad;
            class_1058 oldSprite = mQuad.cachedSprite();
            if (oldSprite == null) {
                return true;
            }
            for (int i = 0; i < 4; ++i) {
                float uNorm = (mQuad.u(i) - oldSprite.method_4594()) / (oldSprite.method_4577() - oldSprite.method_4594());
                float vNorm = (mQuad.v(i) - oldSprite.method_4593()) / (oldSprite.method_4575() - oldSprite.method_4593());
                mQuad.uv(i, newSprite.method_4594() + uNorm * (newSprite.method_4577() - newSprite.method_4594()), newSprite.method_4593() + vNorm * (newSprite.method_4575() - newSprite.method_4593()));
            }
            mQuad.cachedSprite(newSprite);
            return true;
        };
    }

    private ModelTransform() {
        throw new IllegalStateException("Instancing of this class is not allowed!");
    }
}

