package betterblockentities.mixin.minecraft;

/* local */
import betterblockentities.chunk.ChunkUpdateDispatcher;
import betterblockentities.gui.ConfigManager;
import betterblockentities.mixin.minecraft.chest.ChestBlockEntityAccessor;
import betterblockentities.mixin.minecraft.chest.ChestLidAnimatorAccessor;
import betterblockentities.util.BlockEntityExt;
import betterblockentities.util.BlockEntityManager;
import betterblockentities.util.BlockEntityTracker;

/* fabric */
import betterblockentities.util.BlockVisibilityChecker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_5560;
import net.minecraft.class_638;
/* mixin */
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_638.class)
public class ClientWorldMixin {
    @Inject(method = "handleBlockUpdate", at = @At("TAIL"), cancellable = true)
    public void handleBlockUpdate(class_2338 pos, class_2680 state, int flags, CallbackInfo ci) {
        if (!ConfigManager.CONFIG.master_optimize) return;

        class_638 world = (class_638) (Object) this;
        if (!world.method_8608()) return;

        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null || !BlockEntityManager.isSupportedEntity(blockEntity)) return;

        BlockEntityExt inst = (BlockEntityExt) blockEntity;

        /* get other chest half */
        class_2586 alt = getOtherChestHalf(blockEntity.method_10997(), blockEntity.method_11016());

        /* sync other half if it’s animating */
        if (alt != null && ((class_2618) alt).method_11274(0.5f) > 0f) {
            class_5560 src = ((ChestBlockEntityAccessor) alt).getLidAnimator();
            class_5560 dst = ((ChestBlockEntityAccessor) blockEntity).getLidAnimator();

            ChestLidAnimatorAccessor accSrc = (ChestLidAnimatorAccessor) src;
            ChestLidAnimatorAccessor accDst = (ChestLidAnimatorAccessor) dst;

            accDst.setOpen(accSrc.getOpen());
            accDst.setProgress(accSrc.getProgress());
            accDst.setLastProgress(accSrc.getLastProgress());

            inst.setJustReceivedUpdate(true);
        }

        /* force smart updates on other half if needed */
        else if (ConfigManager.CONFIG.updateType == 0) {
            if (alt != null) {
                BlockEntityExt altExt = (BlockEntityExt) alt;
                if (altExt.getJustReceivedUpdate() && altExt.getRemoveChunkVariant()) {
                    inst.setRemoveChunkVariant(true);
                    ChunkUpdateDispatcher.queueRebuildAtBlockPos(blockEntity.method_10997(), pos.method_10063());
                    BlockEntityTracker.animMap.add(alt.method_11016().method_10063());
                    inst.setJustReceivedUpdate(true);
                }
            }
        }
    }

    @Unique
    private static class_2595 getOtherChestHalf(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);

        if (!(state.method_26204() instanceof class_2281)) return null;

        class_2745 type = state.method_11654(class_2281.field_10770);
        class_2350 facing = state.method_11654(class_2281.field_10768);

        class_2350 side;
        if (type == class_2745.field_12574) {
            side = facing.method_10170();
        } else if (type == class_2745.field_12571) {
            side = facing.method_10160();
        } else {
            return null;
        }

        class_2338 otherPos = pos.method_10093(side);
        class_2586 be = world.method_8321(otherPos);

        return be instanceof class_2595 ? (class_2595) be : null;
    }
}
