package betterblockentities.mixin.minecraft.shulker;

/* local */
import betterblockentities.util.BlockEntityExt;
import net.minecraft.block.entity.*;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2627.class)
public abstract class ShulkerBoxBlockEntityMixin {
    /* only run tick logic when we receive a block event */
    @Inject(method = "tick", at = @At("HEAD"), cancellable = true)
    private static void onTick(class_1937 world, class_2338 pos, class_2680 state, class_2627 blockEntity, CallbackInfo ci) {
        if (!(((BlockEntityExt)blockEntity).getJustReceivedUpdate()))
            ci.cancel();
    }

    /* capture block event for conditional rendering in BlockEntityManager */
    @Inject(method = "onSyncedBlockEvent", at = @At("HEAD"), cancellable = true)
    private void onBlockEvent(int type, int data, CallbackInfoReturnable<Boolean> cir) {
        if (type != 1) return;
        ((BlockEntityExt)this).setJustReceivedUpdate(true);
    }
}
