package betterblockentities.util;


/* java/misc */
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4604;

public class BlockVisibilityChecker {
    /* checks if passed blockEntity is in the view frustum and LOS in not blocked */
    public static boolean isBlockInFOVAndVisible(class_4604 frustum, class_2586 blockEntity) {
        class_1297 player = class_310.method_1551().method_1560();
        class_2338 blockPos = blockEntity.method_11016();
        class_243 eyePos = player.method_5836(1.0f);

        /* center of the block */
        class_243 center = new class_243(
                blockPos.method_10263() + 0.5,
                blockPos.method_10264() + 0.5,
                blockPos.method_10260() + 0.5
        );

        /* max distance check */
        double maxDistance = 20.0;
        if (eyePos.method_1025(center) > maxDistance * maxDistance) return false;

        /* check if block is inside view frustum */
        if (!isBlockInViewFrustum(frustum, blockEntity)) return false;

        /* LOS check to multiple points on the block */
        for (class_243 offset : BLOCK_SAMPLE_OFFSETS) {
            class_243 target = new class_243(
                    blockPos.method_10263() + offset.field_1352,
                    blockPos.method_10264() + offset.field_1351,
                    blockPos.method_10260() + offset.field_1350
            );

            class_239 hit = player.method_73183().method_17742(new class_3959(
                    eyePos,
                    target,
                    class_3959.class_3960.field_23142,
                    class_3959.class_242.field_1348,
                    player
            ));

            /* did we hit? return early */
            if (hit.method_17783() == class_239.class_240.field_1332 && ((class_3965) hit).method_17777().equals(blockPos)) {
                return true;
            }
        }
        return false; //all sample points blocked
    }

    /* get the other chest half's block pos so we can generate its bounding box */
    public static class_2338 getOtherChestHalf(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof class_2281)) return null;

        class_2745 type = state.method_11654(class_2281.field_10770);
        if (type == class_2745.field_12569) return null; // important

        class_2350 facing = state.method_11654(class_2281.field_10768);

        class_2350 side = (type == class_2745.field_12574)
                ? facing.method_10170()
                : facing.method_10160();

        class_2338 otherPos = pos.method_10093(side);

        class_2680 otherState = world.method_8320(otherPos);
        if (!(otherState.method_26204() instanceof class_2281)) return null;

        class_2745 otherType = otherState.method_11654(class_2281.field_10770);
        if (otherType == class_2745.field_12569) return null;

        return otherPos;
    }

    /*
        setup bounding box, we could probably skip the function above
        and just expand the existing box instead of using box union
        which should be slightly more efficient. guess this is a TODO
    */
    private static class_238 setupBox(class_2586 entity, class_2338 pos) {
        if (entity instanceof class_2573)
            return new class_238(pos).method_1009(0, 1, 0);
        else if (!(entity instanceof class_2595))
            return new class_238(pos);

        class_2338 other = getOtherChestHalf(entity.method_10997(), pos);
        if (other == null) return new class_238(pos);

        return new class_238(pos).method_991(new class_238(other));
    }

    /* preform frustum visibility check */
    private static boolean isBlockInViewFrustum(class_4604 frustum, class_2586 blockEntity) {
        return frustum != null && frustum.method_23093(setupBox(blockEntity, blockEntity.method_11016()));
    }

    /* generate sample points to raycast to */
    private static class_243[] generateFaceGrid(int resolution) {
        List<class_243> list = new ArrayList<>();
        double step = 1.0 / (resolution - 1);

        for (int y = 0; y < resolution; y++) {
            for (int x = 0; x < resolution; x++) {
                double u = x * step; // horizontal
                double v = y * step; // vertical

                list.add(new class_243(0.0, v, u));
                list.add(new class_243(1.0, v, u));
                list.add(new class_243(u, v, 0.0));
                list.add(new class_243(u, v, 1.0));
                list.add(new class_243(u, 0.0, v));
                list.add(new class_243(u, 1.0, v));
            }
        }
        return list.toArray(new class_243[0]);
    }

    /* sample points */
    private static final class_243[] BLOCK_SAMPLE_OFFSETS = generateFaceGrid(5);
}
